/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sqs.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.services.sqs.model.MessageAttributeValue;
import software.amazon.awssdk.services.sqs.model.MessageBodyAttributeMapCopier;
import software.amazon.awssdk.services.sqs.model.SqsRequest;
import software.amazon.awssdk.utils.CollectionUtils;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class SendMessageRequest
extends SqsRequest
implements ToCopyableBuilder<Builder, SendMessageRequest> {
    private static final SdkField<String> QUEUE_URL_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(SendMessageRequest.getter(SendMessageRequest::queueUrl)).setter(SendMessageRequest.setter(Builder::queueUrl)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("QueueUrl").build()}).build();
    private static final SdkField<String> MESSAGE_BODY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(SendMessageRequest.getter(SendMessageRequest::messageBody)).setter(SendMessageRequest.setter(Builder::messageBody)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MessageBody").build()}).build();
    private static final SdkField<Integer> DELAY_SECONDS_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).getter(SendMessageRequest.getter(SendMessageRequest::delaySeconds)).setter(SendMessageRequest.setter(Builder::delaySeconds)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DelaySeconds").build()}).build();
    private static final SdkField<Map<String, MessageAttributeValue>> MESSAGE_ATTRIBUTES_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).getter(SendMessageRequest.getter(SendMessageRequest::messageAttributes)).setter(SendMessageRequest.setter(Builder::messageAttributes)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MessageAttribute").build(), MapTrait.builder().keyLocationName("Name").valueLocationName("Value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(MessageAttributeValue::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Value").build()}).build()).isFlattened(true).build()}).build();
    private static final SdkField<String> MESSAGE_DEDUPLICATION_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(SendMessageRequest.getter(SendMessageRequest::messageDeduplicationId)).setter(SendMessageRequest.setter(Builder::messageDeduplicationId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MessageDeduplicationId").build()}).build();
    private static final SdkField<String> MESSAGE_GROUP_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(SendMessageRequest.getter(SendMessageRequest::messageGroupId)).setter(SendMessageRequest.setter(Builder::messageGroupId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MessageGroupId").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(QUEUE_URL_FIELD, MESSAGE_BODY_FIELD, DELAY_SECONDS_FIELD, MESSAGE_ATTRIBUTES_FIELD, MESSAGE_DEDUPLICATION_ID_FIELD, MESSAGE_GROUP_ID_FIELD));
    private final String queueUrl;
    private final String messageBody;
    private final Integer delaySeconds;
    private final Map<String, MessageAttributeValue> messageAttributes;
    private final String messageDeduplicationId;
    private final String messageGroupId;

    private SendMessageRequest(BuilderImpl builder) {
        super(builder);
        this.queueUrl = builder.queueUrl;
        this.messageBody = builder.messageBody;
        this.delaySeconds = builder.delaySeconds;
        this.messageAttributes = builder.messageAttributes;
        this.messageDeduplicationId = builder.messageDeduplicationId;
        this.messageGroupId = builder.messageGroupId;
    }

    public String queueUrl() {
        return this.queueUrl;
    }

    public String messageBody() {
        return this.messageBody;
    }

    public Integer delaySeconds() {
        return this.delaySeconds;
    }

    public Map<String, MessageAttributeValue> messageAttributes() {
        return this.messageAttributes;
    }

    public String messageDeduplicationId() {
        return this.messageDeduplicationId;
    }

    public String messageGroupId() {
        return this.messageGroupId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.queueUrl());
        hashCode = 31 * hashCode + Objects.hashCode(this.messageBody());
        hashCode = 31 * hashCode + Objects.hashCode(this.delaySeconds());
        hashCode = 31 * hashCode + Objects.hashCode(this.messageAttributes());
        hashCode = 31 * hashCode + Objects.hashCode(this.messageDeduplicationId());
        hashCode = 31 * hashCode + Objects.hashCode(this.messageGroupId());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SendMessageRequest)) {
            return false;
        }
        SendMessageRequest other = (SendMessageRequest)((Object)obj);
        return Objects.equals(this.queueUrl(), other.queueUrl()) && Objects.equals(this.messageBody(), other.messageBody()) && Objects.equals(this.delaySeconds(), other.delaySeconds()) && Objects.equals(this.messageAttributes(), other.messageAttributes()) && Objects.equals(this.messageDeduplicationId(), other.messageDeduplicationId()) && Objects.equals(this.messageGroupId(), other.messageGroupId());
    }

    public String toString() {
        return ToString.builder((String)"SendMessageRequest").add("QueueUrl", (Object)this.queueUrl()).add("MessageBody", (Object)this.messageBody()).add("DelaySeconds", (Object)this.delaySeconds()).add("MessageAttributes", this.messageAttributes()).add("MessageDeduplicationId", (Object)this.messageDeduplicationId()).add("MessageGroupId", (Object)this.messageGroupId()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "QueueUrl": {
                return Optional.ofNullable(clazz.cast(this.queueUrl()));
            }
            case "MessageBody": {
                return Optional.ofNullable(clazz.cast(this.messageBody()));
            }
            case "DelaySeconds": {
                return Optional.ofNullable(clazz.cast(this.delaySeconds()));
            }
            case "MessageAttributes": {
                return Optional.ofNullable(clazz.cast(this.messageAttributes()));
            }
            case "MessageDeduplicationId": {
                return Optional.ofNullable(clazz.cast(this.messageDeduplicationId()));
            }
            case "MessageGroupId": {
                return Optional.ofNullable(clazz.cast(this.messageGroupId()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<SendMessageRequest, T> g) {
        return obj -> g.apply((SendMessageRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends SqsRequest.BuilderImpl
    implements Builder {
        private String queueUrl;
        private String messageBody;
        private Integer delaySeconds;
        private Map<String, MessageAttributeValue> messageAttributes = DefaultSdkAutoConstructMap.getInstance();
        private String messageDeduplicationId;
        private String messageGroupId;

        private BuilderImpl() {
        }

        private BuilderImpl(SendMessageRequest model) {
            super(model);
            this.queueUrl(model.queueUrl);
            this.messageBody(model.messageBody);
            this.delaySeconds(model.delaySeconds);
            this.messageAttributes(model.messageAttributes);
            this.messageDeduplicationId(model.messageDeduplicationId);
            this.messageGroupId(model.messageGroupId);
        }

        public final String getQueueUrl() {
            return this.queueUrl;
        }

        @Override
        public final Builder queueUrl(String queueUrl) {
            this.queueUrl = queueUrl;
            return this;
        }

        public final void setQueueUrl(String queueUrl) {
            this.queueUrl = queueUrl;
        }

        public final String getMessageBody() {
            return this.messageBody;
        }

        @Override
        public final Builder messageBody(String messageBody) {
            this.messageBody = messageBody;
            return this;
        }

        public final void setMessageBody(String messageBody) {
            this.messageBody = messageBody;
        }

        public final Integer getDelaySeconds() {
            return this.delaySeconds;
        }

        @Override
        public final Builder delaySeconds(Integer delaySeconds) {
            this.delaySeconds = delaySeconds;
            return this;
        }

        public final void setDelaySeconds(Integer delaySeconds) {
            this.delaySeconds = delaySeconds;
        }

        public final Map<String, MessageAttributeValue.Builder> getMessageAttributes() {
            return this.messageAttributes != null ? CollectionUtils.mapValues(this.messageAttributes, MessageAttributeValue::toBuilder) : null;
        }

        @Override
        public final Builder messageAttributes(Map<String, MessageAttributeValue> messageAttributes) {
            this.messageAttributes = MessageBodyAttributeMapCopier.copy(messageAttributes);
            return this;
        }

        public final void setMessageAttributes(Map<String, MessageAttributeValue.BuilderImpl> messageAttributes) {
            this.messageAttributes = MessageBodyAttributeMapCopier.copyFromBuilder(messageAttributes);
        }

        public final String getMessageDeduplicationId() {
            return this.messageDeduplicationId;
        }

        @Override
        public final Builder messageDeduplicationId(String messageDeduplicationId) {
            this.messageDeduplicationId = messageDeduplicationId;
            return this;
        }

        public final void setMessageDeduplicationId(String messageDeduplicationId) {
            this.messageDeduplicationId = messageDeduplicationId;
        }

        public final String getMessageGroupId() {
            return this.messageGroupId;
        }

        @Override
        public final Builder messageGroupId(String messageGroupId) {
            this.messageGroupId = messageGroupId;
            return this;
        }

        public final void setMessageGroupId(String messageGroupId) {
            this.messageGroupId = messageGroupId;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public SendMessageRequest build() {
            return new SendMessageRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SqsRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, SendMessageRequest> {
        public Builder queueUrl(String var1);

        public Builder messageBody(String var1);

        public Builder delaySeconds(Integer var1);

        public Builder messageAttributes(Map<String, MessageAttributeValue> var1);

        public Builder messageDeduplicationId(String var1);

        public Builder messageGroupId(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

