/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ssm.model;

import java.util.Collection;
import java.util.List;
import javax.annotation.Generated;
import software.amazon.awssdk.AmazonWebServiceRequest;
import software.amazon.awssdk.runtime.SdkInternalList;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public class CreatePatchBaselineRequest extends AmazonWebServiceRequest implements
        ToCopyableBuilder<CreatePatchBaselineRequest.Builder, CreatePatchBaselineRequest> {
    private final String name;

    private final PatchFilterGroup globalFilters;

    private final PatchRuleGroup approvalRules;

    private final List<String> approvedPatches;

    private final List<String> rejectedPatches;

    private final String description;

    private final String clientToken;

    private CreatePatchBaselineRequest(BuilderImpl builder) {
        this.name = builder.name;
        this.globalFilters = builder.globalFilters;
        this.approvalRules = builder.approvalRules;
        this.approvedPatches = builder.approvedPatches;
        this.rejectedPatches = builder.rejectedPatches;
        this.description = builder.description;
        this.clientToken = builder.clientToken;
    }

    /**
     * <p>
     * The name of the patch baseline.
     * </p>
     * 
     * @return The name of the patch baseline.
     */
    public String name() {
        return name;
    }

    /**
     * <p>
     * A set of global filters used to exclude patches from the baseline.
     * </p>
     * 
     * @return A set of global filters used to exclude patches from the baseline.
     */
    public PatchFilterGroup globalFilters() {
        return globalFilters;
    }

    /**
     * <p>
     * A set of rules used to include patches in the baseline.
     * </p>
     * 
     * @return A set of rules used to include patches in the baseline.
     */
    public PatchRuleGroup approvalRules() {
        return approvalRules;
    }

    /**
     * <p>
     * A list of explicitly approved patches for the baseline.
     * </p>
     * 
     * @return A list of explicitly approved patches for the baseline.
     */
    public List<String> approvedPatches() {
        return approvedPatches;
    }

    /**
     * <p>
     * A list of explicitly rejected patches for the baseline.
     * </p>
     * 
     * @return A list of explicitly rejected patches for the baseline.
     */
    public List<String> rejectedPatches() {
        return rejectedPatches;
    }

    /**
     * <p>
     * A description of the patch baseline.
     * </p>
     * 
     * @return A description of the patch baseline.
     */
    public String description() {
        return description;
    }

    /**
     * <p>
     * User-provided idempotency token.
     * </p>
     * 
     * @return User-provided idempotency token.
     */
    public String clientToken() {
        return clientToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + ((name() == null) ? 0 : name().hashCode());
        hashCode = 31 * hashCode + ((globalFilters() == null) ? 0 : globalFilters().hashCode());
        hashCode = 31 * hashCode + ((approvalRules() == null) ? 0 : approvalRules().hashCode());
        hashCode = 31 * hashCode + ((approvedPatches() == null) ? 0 : approvedPatches().hashCode());
        hashCode = 31 * hashCode + ((rejectedPatches() == null) ? 0 : rejectedPatches().hashCode());
        hashCode = 31 * hashCode + ((description() == null) ? 0 : description().hashCode());
        hashCode = 31 * hashCode + ((clientToken() == null) ? 0 : clientToken().hashCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreatePatchBaselineRequest)) {
            return false;
        }
        CreatePatchBaselineRequest other = (CreatePatchBaselineRequest) obj;
        if (other.name() == null ^ this.name() == null) {
            return false;
        }
        if (other.name() != null && !other.name().equals(this.name())) {
            return false;
        }
        if (other.globalFilters() == null ^ this.globalFilters() == null) {
            return false;
        }
        if (other.globalFilters() != null && !other.globalFilters().equals(this.globalFilters())) {
            return false;
        }
        if (other.approvalRules() == null ^ this.approvalRules() == null) {
            return false;
        }
        if (other.approvalRules() != null && !other.approvalRules().equals(this.approvalRules())) {
            return false;
        }
        if (other.approvedPatches() == null ^ this.approvedPatches() == null) {
            return false;
        }
        if (other.approvedPatches() != null && !other.approvedPatches().equals(this.approvedPatches())) {
            return false;
        }
        if (other.rejectedPatches() == null ^ this.rejectedPatches() == null) {
            return false;
        }
        if (other.rejectedPatches() != null && !other.rejectedPatches().equals(this.rejectedPatches())) {
            return false;
        }
        if (other.description() == null ^ this.description() == null) {
            return false;
        }
        if (other.description() != null && !other.description().equals(this.description())) {
            return false;
        }
        if (other.clientToken() == null ^ this.clientToken() == null) {
            return false;
        }
        if (other.clientToken() != null && !other.clientToken().equals(this.clientToken())) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (name() != null) {
            sb.append("Name: ").append(name()).append(",");
        }
        if (globalFilters() != null) {
            sb.append("GlobalFilters: ").append(globalFilters()).append(",");
        }
        if (approvalRules() != null) {
            sb.append("ApprovalRules: ").append(approvalRules()).append(",");
        }
        if (approvedPatches() != null) {
            sb.append("ApprovedPatches: ").append(approvedPatches()).append(",");
        }
        if (rejectedPatches() != null) {
            sb.append("RejectedPatches: ").append(rejectedPatches()).append(",");
        }
        if (description() != null) {
            sb.append("Description: ").append(description()).append(",");
        }
        if (clientToken() != null) {
            sb.append("ClientToken: ").append(clientToken()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    public interface Builder extends CopyableBuilder<Builder, CreatePatchBaselineRequest> {
        /**
         * <p>
         * The name of the patch baseline.
         * </p>
         * 
         * @param name
         *        The name of the patch baseline.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * A set of global filters used to exclude patches from the baseline.
         * </p>
         * 
         * @param globalFilters
         *        A set of global filters used to exclude patches from the baseline.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder globalFilters(PatchFilterGroup globalFilters);

        /**
         * <p>
         * A set of rules used to include patches in the baseline.
         * </p>
         * 
         * @param approvalRules
         *        A set of rules used to include patches in the baseline.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder approvalRules(PatchRuleGroup approvalRules);

        /**
         * <p>
         * A list of explicitly approved patches for the baseline.
         * </p>
         * 
         * @param approvedPatches
         *        A list of explicitly approved patches for the baseline.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder approvedPatches(Collection<String> approvedPatches);

        /**
         * <p>
         * A list of explicitly approved patches for the baseline.
         * </p>
         * <p>
         * <b>NOTE:</b> This method appends the values to the existing list (if any). Use
         * {@link #setApprovedPatches(java.util.Collection)} or {@link #withApprovedPatches(java.util.Collection)} if
         * you want to override the existing values.
         * </p>
         * 
         * @param approvedPatches
         *        A list of explicitly approved patches for the baseline.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder approvedPatches(String... approvedPatches);

        /**
         * <p>
         * A list of explicitly rejected patches for the baseline.
         * </p>
         * 
         * @param rejectedPatches
         *        A list of explicitly rejected patches for the baseline.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder rejectedPatches(Collection<String> rejectedPatches);

        /**
         * <p>
         * A list of explicitly rejected patches for the baseline.
         * </p>
         * <p>
         * <b>NOTE:</b> This method appends the values to the existing list (if any). Use
         * {@link #setRejectedPatches(java.util.Collection)} or {@link #withRejectedPatches(java.util.Collection)} if
         * you want to override the existing values.
         * </p>
         * 
         * @param rejectedPatches
         *        A list of explicitly rejected patches for the baseline.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder rejectedPatches(String... rejectedPatches);

        /**
         * <p>
         * A description of the patch baseline.
         * </p>
         * 
         * @param description
         *        A description of the patch baseline.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * <p>
         * User-provided idempotency token.
         * </p>
         * 
         * @param clientToken
         *        User-provided idempotency token.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder clientToken(String clientToken);
    }

    private static final class BuilderImpl implements Builder {
        private String name;

        private PatchFilterGroup globalFilters;

        private PatchRuleGroup approvalRules;

        private List<String> approvedPatches = new SdkInternalList<>();

        private List<String> rejectedPatches = new SdkInternalList<>();

        private String description;

        private String clientToken;

        private BuilderImpl() {
        }

        private BuilderImpl(CreatePatchBaselineRequest model) {
            setName(model.name);
            setGlobalFilters(model.globalFilters);
            setApprovalRules(model.approvalRules);
            setApprovedPatches(model.approvedPatches);
            setRejectedPatches(model.rejectedPatches);
            setDescription(model.description);
            setClientToken(model.clientToken);
        }

        public final String getName() {
            return name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final void setName(String name) {
            this.name = name;
        }

        public final PatchFilterGroup getGlobalFilters() {
            return globalFilters;
        }

        @Override
        public final Builder globalFilters(PatchFilterGroup globalFilters) {
            this.globalFilters = globalFilters;
            return this;
        }

        public final void setGlobalFilters(PatchFilterGroup globalFilters) {
            this.globalFilters = globalFilters;
        }

        public final PatchRuleGroup getApprovalRules() {
            return approvalRules;
        }

        @Override
        public final Builder approvalRules(PatchRuleGroup approvalRules) {
            this.approvalRules = approvalRules;
            return this;
        }

        public final void setApprovalRules(PatchRuleGroup approvalRules) {
            this.approvalRules = approvalRules;
        }

        public final Collection<String> getApprovedPatches() {
            return approvedPatches;
        }

        @Override
        public final Builder approvedPatches(Collection<String> approvedPatches) {
            this.approvedPatches = PatchIdListCopier.copy(approvedPatches);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder approvedPatches(String... approvedPatches) {
            if (this.approvedPatches == null) {
                this.approvedPatches = new SdkInternalList<>(approvedPatches.length);
            }
            for (String e : approvedPatches) {
                this.approvedPatches.add(e);
            }
            return this;
        }

        public final void setApprovedPatches(Collection<String> approvedPatches) {
            this.approvedPatches = PatchIdListCopier.copy(approvedPatches);
        }

        @SafeVarargs
        public final void setApprovedPatches(String... approvedPatches) {
            if (this.approvedPatches == null) {
                this.approvedPatches = new SdkInternalList<>(approvedPatches.length);
            }
            for (String e : approvedPatches) {
                this.approvedPatches.add(e);
            }
        }

        public final Collection<String> getRejectedPatches() {
            return rejectedPatches;
        }

        @Override
        public final Builder rejectedPatches(Collection<String> rejectedPatches) {
            this.rejectedPatches = PatchIdListCopier.copy(rejectedPatches);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder rejectedPatches(String... rejectedPatches) {
            if (this.rejectedPatches == null) {
                this.rejectedPatches = new SdkInternalList<>(rejectedPatches.length);
            }
            for (String e : rejectedPatches) {
                this.rejectedPatches.add(e);
            }
            return this;
        }

        public final void setRejectedPatches(Collection<String> rejectedPatches) {
            this.rejectedPatches = PatchIdListCopier.copy(rejectedPatches);
        }

        @SafeVarargs
        public final void setRejectedPatches(String... rejectedPatches) {
            if (this.rejectedPatches == null) {
                this.rejectedPatches = new SdkInternalList<>(rejectedPatches.length);
            }
            for (String e : rejectedPatches) {
                this.rejectedPatches.add(e);
            }
        }

        public final String getDescription() {
            return description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        public final String getClientToken() {
            return clientToken;
        }

        @Override
        public final Builder clientToken(String clientToken) {
            this.clientToken = clientToken;
            return this;
        }

        public final void setClientToken(String clientToken) {
            this.clientToken = clientToken;
        }

        @Override
        public CreatePatchBaselineRequest build() {
            return new CreatePatchBaselineRequest(this);
        }
    }
}
