/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ssm.model;

import java.util.Collection;
import java.util.List;
import javax.annotation.Generated;
import software.amazon.awssdk.AmazonWebServiceRequest;
import software.amazon.awssdk.runtime.SdkInternalList;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public class DeleteParametersRequest extends AmazonWebServiceRequest implements
        ToCopyableBuilder<DeleteParametersRequest.Builder, DeleteParametersRequest> {
    private final List<String> names;

    private DeleteParametersRequest(BuilderImpl builder) {
        this.names = builder.names;
    }

    /**
     * <p>
     * The names of the parameters to delete.
     * </p>
     * 
     * @return The names of the parameters to delete.
     */
    public List<String> names() {
        return names;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + ((names() == null) ? 0 : names().hashCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DeleteParametersRequest)) {
            return false;
        }
        DeleteParametersRequest other = (DeleteParametersRequest) obj;
        if (other.names() == null ^ this.names() == null) {
            return false;
        }
        if (other.names() != null && !other.names().equals(this.names())) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (names() != null) {
            sb.append("Names: ").append(names()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    public interface Builder extends CopyableBuilder<Builder, DeleteParametersRequest> {
        /**
         * <p>
         * The names of the parameters to delete.
         * </p>
         * 
         * @param names
         *        The names of the parameters to delete.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder names(Collection<String> names);

        /**
         * <p>
         * The names of the parameters to delete.
         * </p>
         * <p>
         * <b>NOTE:</b> This method appends the values to the existing list (if any). Use
         * {@link #setNames(java.util.Collection)} or {@link #withNames(java.util.Collection)} if you want to override
         * the existing values.
         * </p>
         * 
         * @param names
         *        The names of the parameters to delete.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder names(String... names);
    }

    private static final class BuilderImpl implements Builder {
        private List<String> names = new SdkInternalList<>();

        private BuilderImpl() {
        }

        private BuilderImpl(DeleteParametersRequest model) {
            setNames(model.names);
        }

        public final Collection<String> getNames() {
            return names;
        }

        @Override
        public final Builder names(Collection<String> names) {
            this.names = ParameterNameListCopier.copy(names);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder names(String... names) {
            if (this.names == null) {
                this.names = new SdkInternalList<>(names.length);
            }
            for (String e : names) {
                this.names.add(e);
            }
            return this;
        }

        public final void setNames(Collection<String> names) {
            this.names = ParameterNameListCopier.copy(names);
        }

        @SafeVarargs
        public final void setNames(String... names) {
            if (this.names == null) {
                this.names = new SdkInternalList<>(names.length);
            }
            for (String e : names) {
                this.names.add(e);
            }
        }

        @Override
        public DeleteParametersRequest build() {
            return new DeleteParametersRequest(this);
        }
    }
}
