/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ssm.model;

import java.util.Collection;
import java.util.List;
import javax.annotation.Generated;
import software.amazon.awssdk.AmazonWebServiceResult;
import software.amazon.awssdk.ResponseMetadata;
import software.amazon.awssdk.runtime.SdkInternalList;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public class DescribeInstanceAssociationsStatusResponse extends AmazonWebServiceResult<ResponseMetadata> implements
        ToCopyableBuilder<DescribeInstanceAssociationsStatusResponse.Builder, DescribeInstanceAssociationsStatusResponse> {
    private final List<InstanceAssociationStatusInfo> instanceAssociationStatusInfos;

    private final String nextToken;

    private DescribeInstanceAssociationsStatusResponse(BuilderImpl builder) {
        this.instanceAssociationStatusInfos = builder.instanceAssociationStatusInfos;
        this.nextToken = builder.nextToken;
    }

    /**
     * <p>
     * Status information about the association.
     * </p>
     * 
     * @return Status information about the association.
     */
    public List<InstanceAssociationStatusInfo> instanceAssociationStatusInfos() {
        return instanceAssociationStatusInfos;
    }

    /**
     * <p>
     * The token to use when requesting the next set of items. If there are no additional items to return, the string is
     * empty.
     * </p>
     * 
     * @return The token to use when requesting the next set of items. If there are no additional items to return, the
     *         string is empty.
     */
    public String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + ((instanceAssociationStatusInfos() == null) ? 0 : instanceAssociationStatusInfos().hashCode());
        hashCode = 31 * hashCode + ((nextToken() == null) ? 0 : nextToken().hashCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeInstanceAssociationsStatusResponse)) {
            return false;
        }
        DescribeInstanceAssociationsStatusResponse other = (DescribeInstanceAssociationsStatusResponse) obj;
        if (other.instanceAssociationStatusInfos() == null ^ this.instanceAssociationStatusInfos() == null) {
            return false;
        }
        if (other.instanceAssociationStatusInfos() != null
                && !other.instanceAssociationStatusInfos().equals(this.instanceAssociationStatusInfos())) {
            return false;
        }
        if (other.nextToken() == null ^ this.nextToken() == null) {
            return false;
        }
        if (other.nextToken() != null && !other.nextToken().equals(this.nextToken())) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (instanceAssociationStatusInfos() != null) {
            sb.append("InstanceAssociationStatusInfos: ").append(instanceAssociationStatusInfos()).append(",");
        }
        if (nextToken() != null) {
            sb.append("NextToken: ").append(nextToken()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    public interface Builder extends CopyableBuilder<Builder, DescribeInstanceAssociationsStatusResponse> {
        /**
         * <p>
         * Status information about the association.
         * </p>
         * 
         * @param instanceAssociationStatusInfos
         *        Status information about the association.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder instanceAssociationStatusInfos(Collection<InstanceAssociationStatusInfo> instanceAssociationStatusInfos);

        /**
         * <p>
         * Status information about the association.
         * </p>
         * <p>
         * <b>NOTE:</b> This method appends the values to the existing list (if any). Use
         * {@link #setInstanceAssociationStatusInfos(java.util.Collection)} or
         * {@link #withInstanceAssociationStatusInfos(java.util.Collection)} if you want to override the existing
         * values.
         * </p>
         * 
         * @param instanceAssociationStatusInfos
         *        Status information about the association.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder instanceAssociationStatusInfos(InstanceAssociationStatusInfo... instanceAssociationStatusInfos);

        /**
         * <p>
         * The token to use when requesting the next set of items. If there are no additional items to return, the
         * string is empty.
         * </p>
         * 
         * @param nextToken
         *        The token to use when requesting the next set of items. If there are no additional items to return,
         *        the string is empty.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);
    }

    private static final class BuilderImpl implements Builder {
        private List<InstanceAssociationStatusInfo> instanceAssociationStatusInfos = new SdkInternalList<>();

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeInstanceAssociationsStatusResponse model) {
            setInstanceAssociationStatusInfos(model.instanceAssociationStatusInfos);
            setNextToken(model.nextToken);
        }

        public final Collection<InstanceAssociationStatusInfo> getInstanceAssociationStatusInfos() {
            return instanceAssociationStatusInfos;
        }

        @Override
        public final Builder instanceAssociationStatusInfos(
                Collection<InstanceAssociationStatusInfo> instanceAssociationStatusInfos) {
            this.instanceAssociationStatusInfos = InstanceAssociationStatusInfosCopier.copy(instanceAssociationStatusInfos);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder instanceAssociationStatusInfos(InstanceAssociationStatusInfo... instanceAssociationStatusInfos) {
            if (this.instanceAssociationStatusInfos == null) {
                this.instanceAssociationStatusInfos = new SdkInternalList<>(instanceAssociationStatusInfos.length);
            }
            for (InstanceAssociationStatusInfo e : instanceAssociationStatusInfos) {
                this.instanceAssociationStatusInfos.add(e);
            }
            return this;
        }

        public final void setInstanceAssociationStatusInfos(
                Collection<InstanceAssociationStatusInfo> instanceAssociationStatusInfos) {
            this.instanceAssociationStatusInfos = InstanceAssociationStatusInfosCopier.copy(instanceAssociationStatusInfos);
        }

        @SafeVarargs
        public final void setInstanceAssociationStatusInfos(InstanceAssociationStatusInfo... instanceAssociationStatusInfos) {
            if (this.instanceAssociationStatusInfos == null) {
                this.instanceAssociationStatusInfos = new SdkInternalList<>(instanceAssociationStatusInfos.length);
            }
            for (InstanceAssociationStatusInfo e : instanceAssociationStatusInfos) {
                this.instanceAssociationStatusInfos.add(e);
            }
        }

        public final String getNextToken() {
            return nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public DescribeInstanceAssociationsStatusResponse build() {
            return new DescribeInstanceAssociationsStatusResponse(this);
        }
    }
}
