/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ssm.model;

import java.util.Collection;
import java.util.List;
import javax.annotation.Generated;
import software.amazon.awssdk.AmazonWebServiceRequest;
import software.amazon.awssdk.runtime.SdkInternalList;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public class DescribeInstancePatchStatesForPatchGroupRequest extends AmazonWebServiceRequest
        implements
        ToCopyableBuilder<DescribeInstancePatchStatesForPatchGroupRequest.Builder, DescribeInstancePatchStatesForPatchGroupRequest> {
    private final String patchGroup;

    private final List<InstancePatchStateFilter> filters;

    private final String nextToken;

    private final Integer maxResults;

    private DescribeInstancePatchStatesForPatchGroupRequest(BuilderImpl builder) {
        this.patchGroup = builder.patchGroup;
        this.filters = builder.filters;
        this.nextToken = builder.nextToken;
        this.maxResults = builder.maxResults;
    }

    /**
     * <p>
     * The name of the patch group for which the patch state information should be retrieved.
     * </p>
     * 
     * @return The name of the patch group for which the patch state information should be retrieved.
     */
    public String patchGroup() {
        return patchGroup;
    }

    /**
     * <p>
     * Each entry in the array is a structure containing:
     * </p>
     * <p>
     * Key (string between 1 and 200 characters)
     * </p>
     * <p>
     * Values (array containing a single string)
     * </p>
     * <p>
     * Type (string "Equal", "NotEqual", "LessThan", "GreaterThan")
     * </p>
     * 
     * @return Each entry in the array is a structure containing:</p>
     *         <p>
     *         Key (string between 1 and 200 characters)
     *         </p>
     *         <p>
     *         Values (array containing a single string)
     *         </p>
     *         <p>
     *         Type (string "Equal", "NotEqual", "LessThan", "GreaterThan")
     */
    public List<InstancePatchStateFilter> filters() {
        return filters;
    }

    /**
     * <p>
     * The token for the next set of items to return. (You received this token from a previous call.)
     * </p>
     * 
     * @return The token for the next set of items to return. (You received this token from a previous call.)
     */
    public String nextToken() {
        return nextToken;
    }

    /**
     * <p>
     * The maximum number of patches to return (per page).
     * </p>
     * 
     * @return The maximum number of patches to return (per page).
     */
    public Integer maxResults() {
        return maxResults;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + ((patchGroup() == null) ? 0 : patchGroup().hashCode());
        hashCode = 31 * hashCode + ((filters() == null) ? 0 : filters().hashCode());
        hashCode = 31 * hashCode + ((nextToken() == null) ? 0 : nextToken().hashCode());
        hashCode = 31 * hashCode + ((maxResults() == null) ? 0 : maxResults().hashCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeInstancePatchStatesForPatchGroupRequest)) {
            return false;
        }
        DescribeInstancePatchStatesForPatchGroupRequest other = (DescribeInstancePatchStatesForPatchGroupRequest) obj;
        if (other.patchGroup() == null ^ this.patchGroup() == null) {
            return false;
        }
        if (other.patchGroup() != null && !other.patchGroup().equals(this.patchGroup())) {
            return false;
        }
        if (other.filters() == null ^ this.filters() == null) {
            return false;
        }
        if (other.filters() != null && !other.filters().equals(this.filters())) {
            return false;
        }
        if (other.nextToken() == null ^ this.nextToken() == null) {
            return false;
        }
        if (other.nextToken() != null && !other.nextToken().equals(this.nextToken())) {
            return false;
        }
        if (other.maxResults() == null ^ this.maxResults() == null) {
            return false;
        }
        if (other.maxResults() != null && !other.maxResults().equals(this.maxResults())) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (patchGroup() != null) {
            sb.append("PatchGroup: ").append(patchGroup()).append(",");
        }
        if (filters() != null) {
            sb.append("Filters: ").append(filters()).append(",");
        }
        if (nextToken() != null) {
            sb.append("NextToken: ").append(nextToken()).append(",");
        }
        if (maxResults() != null) {
            sb.append("MaxResults: ").append(maxResults()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    public interface Builder extends CopyableBuilder<Builder, DescribeInstancePatchStatesForPatchGroupRequest> {
        /**
         * <p>
         * The name of the patch group for which the patch state information should be retrieved.
         * </p>
         * 
         * @param patchGroup
         *        The name of the patch group for which the patch state information should be retrieved.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder patchGroup(String patchGroup);

        /**
         * <p>
         * Each entry in the array is a structure containing:
         * </p>
         * <p>
         * Key (string between 1 and 200 characters)
         * </p>
         * <p>
         * Values (array containing a single string)
         * </p>
         * <p>
         * Type (string "Equal", "NotEqual", "LessThan", "GreaterThan")
         * </p>
         * 
         * @param filters
         *        Each entry in the array is a structure containing:</p>
         *        <p>
         *        Key (string between 1 and 200 characters)
         *        </p>
         *        <p>
         *        Values (array containing a single string)
         *        </p>
         *        <p>
         *        Type (string "Equal", "NotEqual", "LessThan", "GreaterThan")
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder filters(Collection<InstancePatchStateFilter> filters);

        /**
         * <p>
         * Each entry in the array is a structure containing:
         * </p>
         * <p>
         * Key (string between 1 and 200 characters)
         * </p>
         * <p>
         * Values (array containing a single string)
         * </p>
         * <p>
         * Type (string "Equal", "NotEqual", "LessThan", "GreaterThan")
         * </p>
         * <p>
         * <b>NOTE:</b> This method appends the values to the existing list (if any). Use
         * {@link #setFilters(java.util.Collection)} or {@link #withFilters(java.util.Collection)} if you want to
         * override the existing values.
         * </p>
         * 
         * @param filters
         *        Each entry in the array is a structure containing:</p>
         *        <p>
         *        Key (string between 1 and 200 characters)
         *        </p>
         *        <p>
         *        Values (array containing a single string)
         *        </p>
         *        <p>
         *        Type (string "Equal", "NotEqual", "LessThan", "GreaterThan")
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder filters(InstancePatchStateFilter... filters);

        /**
         * <p>
         * The token for the next set of items to return. (You received this token from a previous call.)
         * </p>
         * 
         * @param nextToken
         *        The token for the next set of items to return. (You received this token from a previous call.)
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);

        /**
         * <p>
         * The maximum number of patches to return (per page).
         * </p>
         * 
         * @param maxResults
         *        The maximum number of patches to return (per page).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maxResults(Integer maxResults);
    }

    private static final class BuilderImpl implements Builder {
        private String patchGroup;

        private List<InstancePatchStateFilter> filters = new SdkInternalList<>();

        private String nextToken;

        private Integer maxResults;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeInstancePatchStatesForPatchGroupRequest model) {
            setPatchGroup(model.patchGroup);
            setFilters(model.filters);
            setNextToken(model.nextToken);
            setMaxResults(model.maxResults);
        }

        public final String getPatchGroup() {
            return patchGroup;
        }

        @Override
        public final Builder patchGroup(String patchGroup) {
            this.patchGroup = patchGroup;
            return this;
        }

        public final void setPatchGroup(String patchGroup) {
            this.patchGroup = patchGroup;
        }

        public final Collection<InstancePatchStateFilter> getFilters() {
            return filters;
        }

        @Override
        public final Builder filters(Collection<InstancePatchStateFilter> filters) {
            this.filters = InstancePatchStateFilterListCopier.copy(filters);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder filters(InstancePatchStateFilter... filters) {
            if (this.filters == null) {
                this.filters = new SdkInternalList<>(filters.length);
            }
            for (InstancePatchStateFilter e : filters) {
                this.filters.add(e);
            }
            return this;
        }

        public final void setFilters(Collection<InstancePatchStateFilter> filters) {
            this.filters = InstancePatchStateFilterListCopier.copy(filters);
        }

        @SafeVarargs
        public final void setFilters(InstancePatchStateFilter... filters) {
            if (this.filters == null) {
                this.filters = new SdkInternalList<>(filters.length);
            }
            for (InstancePatchStateFilter e : filters) {
                this.filters.add(e);
            }
        }

        public final String getNextToken() {
            return nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        public final Integer getMaxResults() {
            return maxResults;
        }

        @Override
        public final Builder maxResults(Integer maxResults) {
            this.maxResults = maxResults;
            return this;
        }

        public final void setMaxResults(Integer maxResults) {
            this.maxResults = maxResults;
        }

        @Override
        public DescribeInstancePatchStatesForPatchGroupRequest build() {
            return new DescribeInstancePatchStatesForPatchGroupRequest(this);
        }
    }
}
