/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ssm.model;

import java.util.Collection;
import java.util.List;
import javax.annotation.Generated;
import software.amazon.awssdk.AmazonWebServiceRequest;
import software.amazon.awssdk.runtime.SdkInternalList;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public class DescribeInstancePatchesRequest extends AmazonWebServiceRequest implements
        ToCopyableBuilder<DescribeInstancePatchesRequest.Builder, DescribeInstancePatchesRequest> {
    private final String instanceId;

    private final List<PatchOrchestratorFilter> filters;

    private final String nextToken;

    private final Integer maxResults;

    private DescribeInstancePatchesRequest(BuilderImpl builder) {
        this.instanceId = builder.instanceId;
        this.filters = builder.filters;
        this.nextToken = builder.nextToken;
        this.maxResults = builder.maxResults;
    }

    /**
     * <p>
     * The ID of the instance whose patch state information should be retrieved.
     * </p>
     * 
     * @return The ID of the instance whose patch state information should be retrieved.
     */
    public String instanceId() {
        return instanceId;
    }

    /**
     * <p>
     * Each entry in the array is a structure containing:
     * </p>
     * <p>
     * Key (string, between 1 and 128 characters)
     * </p>
     * <p>
     * Values (array of strings, each string between 1 and 256 characters)
     * </p>
     * 
     * @return Each entry in the array is a structure containing:</p>
     *         <p>
     *         Key (string, between 1 and 128 characters)
     *         </p>
     *         <p>
     *         Values (array of strings, each string between 1 and 256 characters)
     */
    public List<PatchOrchestratorFilter> filters() {
        return filters;
    }

    /**
     * <p>
     * The token for the next set of items to return. (You received this token from a previous call.)
     * </p>
     * 
     * @return The token for the next set of items to return. (You received this token from a previous call.)
     */
    public String nextToken() {
        return nextToken;
    }

    /**
     * <p>
     * The maximum number of patches to return (per page).
     * </p>
     * 
     * @return The maximum number of patches to return (per page).
     */
    public Integer maxResults() {
        return maxResults;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + ((instanceId() == null) ? 0 : instanceId().hashCode());
        hashCode = 31 * hashCode + ((filters() == null) ? 0 : filters().hashCode());
        hashCode = 31 * hashCode + ((nextToken() == null) ? 0 : nextToken().hashCode());
        hashCode = 31 * hashCode + ((maxResults() == null) ? 0 : maxResults().hashCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeInstancePatchesRequest)) {
            return false;
        }
        DescribeInstancePatchesRequest other = (DescribeInstancePatchesRequest) obj;
        if (other.instanceId() == null ^ this.instanceId() == null) {
            return false;
        }
        if (other.instanceId() != null && !other.instanceId().equals(this.instanceId())) {
            return false;
        }
        if (other.filters() == null ^ this.filters() == null) {
            return false;
        }
        if (other.filters() != null && !other.filters().equals(this.filters())) {
            return false;
        }
        if (other.nextToken() == null ^ this.nextToken() == null) {
            return false;
        }
        if (other.nextToken() != null && !other.nextToken().equals(this.nextToken())) {
            return false;
        }
        if (other.maxResults() == null ^ this.maxResults() == null) {
            return false;
        }
        if (other.maxResults() != null && !other.maxResults().equals(this.maxResults())) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (instanceId() != null) {
            sb.append("InstanceId: ").append(instanceId()).append(",");
        }
        if (filters() != null) {
            sb.append("Filters: ").append(filters()).append(",");
        }
        if (nextToken() != null) {
            sb.append("NextToken: ").append(nextToken()).append(",");
        }
        if (maxResults() != null) {
            sb.append("MaxResults: ").append(maxResults()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    public interface Builder extends CopyableBuilder<Builder, DescribeInstancePatchesRequest> {
        /**
         * <p>
         * The ID of the instance whose patch state information should be retrieved.
         * </p>
         * 
         * @param instanceId
         *        The ID of the instance whose patch state information should be retrieved.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder instanceId(String instanceId);

        /**
         * <p>
         * Each entry in the array is a structure containing:
         * </p>
         * <p>
         * Key (string, between 1 and 128 characters)
         * </p>
         * <p>
         * Values (array of strings, each string between 1 and 256 characters)
         * </p>
         * 
         * @param filters
         *        Each entry in the array is a structure containing:</p>
         *        <p>
         *        Key (string, between 1 and 128 characters)
         *        </p>
         *        <p>
         *        Values (array of strings, each string between 1 and 256 characters)
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder filters(Collection<PatchOrchestratorFilter> filters);

        /**
         * <p>
         * Each entry in the array is a structure containing:
         * </p>
         * <p>
         * Key (string, between 1 and 128 characters)
         * </p>
         * <p>
         * Values (array of strings, each string between 1 and 256 characters)
         * </p>
         * <p>
         * <b>NOTE:</b> This method appends the values to the existing list (if any). Use
         * {@link #setFilters(java.util.Collection)} or {@link #withFilters(java.util.Collection)} if you want to
         * override the existing values.
         * </p>
         * 
         * @param filters
         *        Each entry in the array is a structure containing:</p>
         *        <p>
         *        Key (string, between 1 and 128 characters)
         *        </p>
         *        <p>
         *        Values (array of strings, each string between 1 and 256 characters)
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder filters(PatchOrchestratorFilter... filters);

        /**
         * <p>
         * The token for the next set of items to return. (You received this token from a previous call.)
         * </p>
         * 
         * @param nextToken
         *        The token for the next set of items to return. (You received this token from a previous call.)
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);

        /**
         * <p>
         * The maximum number of patches to return (per page).
         * </p>
         * 
         * @param maxResults
         *        The maximum number of patches to return (per page).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maxResults(Integer maxResults);
    }

    private static final class BuilderImpl implements Builder {
        private String instanceId;

        private List<PatchOrchestratorFilter> filters = new SdkInternalList<>();

        private String nextToken;

        private Integer maxResults;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeInstancePatchesRequest model) {
            setInstanceId(model.instanceId);
            setFilters(model.filters);
            setNextToken(model.nextToken);
            setMaxResults(model.maxResults);
        }

        public final String getInstanceId() {
            return instanceId;
        }

        @Override
        public final Builder instanceId(String instanceId) {
            this.instanceId = instanceId;
            return this;
        }

        public final void setInstanceId(String instanceId) {
            this.instanceId = instanceId;
        }

        public final Collection<PatchOrchestratorFilter> getFilters() {
            return filters;
        }

        @Override
        public final Builder filters(Collection<PatchOrchestratorFilter> filters) {
            this.filters = PatchOrchestratorFilterListCopier.copy(filters);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder filters(PatchOrchestratorFilter... filters) {
            if (this.filters == null) {
                this.filters = new SdkInternalList<>(filters.length);
            }
            for (PatchOrchestratorFilter e : filters) {
                this.filters.add(e);
            }
            return this;
        }

        public final void setFilters(Collection<PatchOrchestratorFilter> filters) {
            this.filters = PatchOrchestratorFilterListCopier.copy(filters);
        }

        @SafeVarargs
        public final void setFilters(PatchOrchestratorFilter... filters) {
            if (this.filters == null) {
                this.filters = new SdkInternalList<>(filters.length);
            }
            for (PatchOrchestratorFilter e : filters) {
                this.filters.add(e);
            }
        }

        public final String getNextToken() {
            return nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        public final Integer getMaxResults() {
            return maxResults;
        }

        @Override
        public final Builder maxResults(Integer maxResults) {
            this.maxResults = maxResults;
            return this;
        }

        public final void setMaxResults(Integer maxResults) {
            this.maxResults = maxResults;
        }

        @Override
        public DescribeInstancePatchesRequest build() {
            return new DescribeInstancePatchesRequest(this);
        }
    }
}
