/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ssm.model;

import java.util.Collection;
import java.util.List;
import javax.annotation.Generated;
import software.amazon.awssdk.AmazonWebServiceResult;
import software.amazon.awssdk.ResponseMetadata;
import software.amazon.awssdk.runtime.SdkInternalList;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public class DescribeInstancePatchesResponse extends AmazonWebServiceResult<ResponseMetadata> implements
        ToCopyableBuilder<DescribeInstancePatchesResponse.Builder, DescribeInstancePatchesResponse> {
    private final List<PatchComplianceData> patches;

    private final String nextToken;

    private DescribeInstancePatchesResponse(BuilderImpl builder) {
        this.patches = builder.patches;
        this.nextToken = builder.nextToken;
    }

    /**
     * <p>
     * Each entry in the array is a structure containing:
     * </p>
     * <p>
     * Title (string)
     * </p>
     * <p>
     * KBId (string)
     * </p>
     * <p>
     * Classification (string)
     * </p>
     * <p>
     * Severity (string)
     * </p>
     * <p>
     * State (string: "INSTALLED", "INSTALLED OTHER", "MISSING", "NOT APPLICABLE", "FAILED")
     * </p>
     * <p>
     * InstalledTime (DateTime)
     * </p>
     * <p>
     * InstalledBy (string)
     * </p>
     * 
     * @return Each entry in the array is a structure containing:</p>
     *         <p>
     *         Title (string)
     *         </p>
     *         <p>
     *         KBId (string)
     *         </p>
     *         <p>
     *         Classification (string)
     *         </p>
     *         <p>
     *         Severity (string)
     *         </p>
     *         <p>
     *         State (string: "INSTALLED", "INSTALLED OTHER", "MISSING", "NOT APPLICABLE", "FAILED")
     *         </p>
     *         <p>
     *         InstalledTime (DateTime)
     *         </p>
     *         <p>
     *         InstalledBy (string)
     */
    public List<PatchComplianceData> patches() {
        return patches;
    }

    /**
     * <p>
     * The token to use when requesting the next set of items. If there are no additional items to return, the string is
     * empty.
     * </p>
     * 
     * @return The token to use when requesting the next set of items. If there are no additional items to return, the
     *         string is empty.
     */
    public String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + ((patches() == null) ? 0 : patches().hashCode());
        hashCode = 31 * hashCode + ((nextToken() == null) ? 0 : nextToken().hashCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeInstancePatchesResponse)) {
            return false;
        }
        DescribeInstancePatchesResponse other = (DescribeInstancePatchesResponse) obj;
        if (other.patches() == null ^ this.patches() == null) {
            return false;
        }
        if (other.patches() != null && !other.patches().equals(this.patches())) {
            return false;
        }
        if (other.nextToken() == null ^ this.nextToken() == null) {
            return false;
        }
        if (other.nextToken() != null && !other.nextToken().equals(this.nextToken())) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (patches() != null) {
            sb.append("Patches: ").append(patches()).append(",");
        }
        if (nextToken() != null) {
            sb.append("NextToken: ").append(nextToken()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    public interface Builder extends CopyableBuilder<Builder, DescribeInstancePatchesResponse> {
        /**
         * <p>
         * Each entry in the array is a structure containing:
         * </p>
         * <p>
         * Title (string)
         * </p>
         * <p>
         * KBId (string)
         * </p>
         * <p>
         * Classification (string)
         * </p>
         * <p>
         * Severity (string)
         * </p>
         * <p>
         * State (string: "INSTALLED", "INSTALLED OTHER", "MISSING", "NOT APPLICABLE", "FAILED")
         * </p>
         * <p>
         * InstalledTime (DateTime)
         * </p>
         * <p>
         * InstalledBy (string)
         * </p>
         * 
         * @param patches
         *        Each entry in the array is a structure containing:</p>
         *        <p>
         *        Title (string)
         *        </p>
         *        <p>
         *        KBId (string)
         *        </p>
         *        <p>
         *        Classification (string)
         *        </p>
         *        <p>
         *        Severity (string)
         *        </p>
         *        <p>
         *        State (string: "INSTALLED", "INSTALLED OTHER", "MISSING", "NOT APPLICABLE", "FAILED")
         *        </p>
         *        <p>
         *        InstalledTime (DateTime)
         *        </p>
         *        <p>
         *        InstalledBy (string)
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder patches(Collection<PatchComplianceData> patches);

        /**
         * <p>
         * Each entry in the array is a structure containing:
         * </p>
         * <p>
         * Title (string)
         * </p>
         * <p>
         * KBId (string)
         * </p>
         * <p>
         * Classification (string)
         * </p>
         * <p>
         * Severity (string)
         * </p>
         * <p>
         * State (string: "INSTALLED", "INSTALLED OTHER", "MISSING", "NOT APPLICABLE", "FAILED")
         * </p>
         * <p>
         * InstalledTime (DateTime)
         * </p>
         * <p>
         * InstalledBy (string)
         * </p>
         * <p>
         * <b>NOTE:</b> This method appends the values to the existing list (if any). Use
         * {@link #setPatches(java.util.Collection)} or {@link #withPatches(java.util.Collection)} if you want to
         * override the existing values.
         * </p>
         * 
         * @param patches
         *        Each entry in the array is a structure containing:</p>
         *        <p>
         *        Title (string)
         *        </p>
         *        <p>
         *        KBId (string)
         *        </p>
         *        <p>
         *        Classification (string)
         *        </p>
         *        <p>
         *        Severity (string)
         *        </p>
         *        <p>
         *        State (string: "INSTALLED", "INSTALLED OTHER", "MISSING", "NOT APPLICABLE", "FAILED")
         *        </p>
         *        <p>
         *        InstalledTime (DateTime)
         *        </p>
         *        <p>
         *        InstalledBy (string)
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder patches(PatchComplianceData... patches);

        /**
         * <p>
         * The token to use when requesting the next set of items. If there are no additional items to return, the
         * string is empty.
         * </p>
         * 
         * @param nextToken
         *        The token to use when requesting the next set of items. If there are no additional items to return,
         *        the string is empty.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);
    }

    private static final class BuilderImpl implements Builder {
        private List<PatchComplianceData> patches = new SdkInternalList<>();

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeInstancePatchesResponse model) {
            setPatches(model.patches);
            setNextToken(model.nextToken);
        }

        public final Collection<PatchComplianceData> getPatches() {
            return patches;
        }

        @Override
        public final Builder patches(Collection<PatchComplianceData> patches) {
            this.patches = PatchComplianceDataListCopier.copy(patches);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder patches(PatchComplianceData... patches) {
            if (this.patches == null) {
                this.patches = new SdkInternalList<>(patches.length);
            }
            for (PatchComplianceData e : patches) {
                this.patches.add(e);
            }
            return this;
        }

        public final void setPatches(Collection<PatchComplianceData> patches) {
            this.patches = PatchComplianceDataListCopier.copy(patches);
        }

        @SafeVarargs
        public final void setPatches(PatchComplianceData... patches) {
            if (this.patches == null) {
                this.patches = new SdkInternalList<>(patches.length);
            }
            for (PatchComplianceData e : patches) {
                this.patches.add(e);
            }
        }

        public final String getNextToken() {
            return nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public DescribeInstancePatchesResponse build() {
            return new DescribeInstancePatchesResponse(this);
        }
    }
}
