/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ssm.model;

import java.util.Collection;
import java.util.List;
import javax.annotation.Generated;
import software.amazon.awssdk.AmazonWebServiceRequest;
import software.amazon.awssdk.runtime.SdkInternalList;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public class DescribeMaintenanceWindowExecutionTaskInvocationsRequest extends AmazonWebServiceRequest
        implements
        ToCopyableBuilder<DescribeMaintenanceWindowExecutionTaskInvocationsRequest.Builder, DescribeMaintenanceWindowExecutionTaskInvocationsRequest> {
    private final String windowExecutionId;

    private final String taskId;

    private final List<MaintenanceWindowFilter> filters;

    private final Integer maxResults;

    private final String nextToken;

    private DescribeMaintenanceWindowExecutionTaskInvocationsRequest(BuilderImpl builder) {
        this.windowExecutionId = builder.windowExecutionId;
        this.taskId = builder.taskId;
        this.filters = builder.filters;
        this.maxResults = builder.maxResults;
        this.nextToken = builder.nextToken;
    }

    /**
     * <p>
     * The ID of the Maintenance Window execution the task is part of.
     * </p>
     * 
     * @return The ID of the Maintenance Window execution the task is part of.
     */
    public String windowExecutionId() {
        return windowExecutionId;
    }

    /**
     * <p>
     * The ID of the specific task in the Maintenance Window task that should be retrieved.
     * </p>
     * 
     * @return The ID of the specific task in the Maintenance Window task that should be retrieved.
     */
    public String taskId() {
        return taskId;
    }

    /**
     * <p>
     * Optional filters used to scope down the returned task invocations. The supported filter key is STATUS with the
     * corresponding values PENDING, IN_PROGRESS, SUCCESS, FAILED, TIMED_OUT, CANCELLING, and CANCELLED.
     * </p>
     * 
     * @return Optional filters used to scope down the returned task invocations. The supported filter key is STATUS
     *         with the corresponding values PENDING, IN_PROGRESS, SUCCESS, FAILED, TIMED_OUT, CANCELLING, and
     *         CANCELLED.
     */
    public List<MaintenanceWindowFilter> filters() {
        return filters;
    }

    /**
     * <p>
     * The maximum number of items to return for this call. The call also returns a token that you can specify in a
     * subsequent call to get the next set of results.
     * </p>
     * 
     * @return The maximum number of items to return for this call. The call also returns a token that you can specify
     *         in a subsequent call to get the next set of results.
     */
    public Integer maxResults() {
        return maxResults;
    }

    /**
     * <p>
     * The token for the next set of items to return. (You received this token from a previous call.)
     * </p>
     * 
     * @return The token for the next set of items to return. (You received this token from a previous call.)
     */
    public String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + ((windowExecutionId() == null) ? 0 : windowExecutionId().hashCode());
        hashCode = 31 * hashCode + ((taskId() == null) ? 0 : taskId().hashCode());
        hashCode = 31 * hashCode + ((filters() == null) ? 0 : filters().hashCode());
        hashCode = 31 * hashCode + ((maxResults() == null) ? 0 : maxResults().hashCode());
        hashCode = 31 * hashCode + ((nextToken() == null) ? 0 : nextToken().hashCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeMaintenanceWindowExecutionTaskInvocationsRequest)) {
            return false;
        }
        DescribeMaintenanceWindowExecutionTaskInvocationsRequest other = (DescribeMaintenanceWindowExecutionTaskInvocationsRequest) obj;
        if (other.windowExecutionId() == null ^ this.windowExecutionId() == null) {
            return false;
        }
        if (other.windowExecutionId() != null && !other.windowExecutionId().equals(this.windowExecutionId())) {
            return false;
        }
        if (other.taskId() == null ^ this.taskId() == null) {
            return false;
        }
        if (other.taskId() != null && !other.taskId().equals(this.taskId())) {
            return false;
        }
        if (other.filters() == null ^ this.filters() == null) {
            return false;
        }
        if (other.filters() != null && !other.filters().equals(this.filters())) {
            return false;
        }
        if (other.maxResults() == null ^ this.maxResults() == null) {
            return false;
        }
        if (other.maxResults() != null && !other.maxResults().equals(this.maxResults())) {
            return false;
        }
        if (other.nextToken() == null ^ this.nextToken() == null) {
            return false;
        }
        if (other.nextToken() != null && !other.nextToken().equals(this.nextToken())) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (windowExecutionId() != null) {
            sb.append("WindowExecutionId: ").append(windowExecutionId()).append(",");
        }
        if (taskId() != null) {
            sb.append("TaskId: ").append(taskId()).append(",");
        }
        if (filters() != null) {
            sb.append("Filters: ").append(filters()).append(",");
        }
        if (maxResults() != null) {
            sb.append("MaxResults: ").append(maxResults()).append(",");
        }
        if (nextToken() != null) {
            sb.append("NextToken: ").append(nextToken()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    public interface Builder extends CopyableBuilder<Builder, DescribeMaintenanceWindowExecutionTaskInvocationsRequest> {
        /**
         * <p>
         * The ID of the Maintenance Window execution the task is part of.
         * </p>
         * 
         * @param windowExecutionId
         *        The ID of the Maintenance Window execution the task is part of.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder windowExecutionId(String windowExecutionId);

        /**
         * <p>
         * The ID of the specific task in the Maintenance Window task that should be retrieved.
         * </p>
         * 
         * @param taskId
         *        The ID of the specific task in the Maintenance Window task that should be retrieved.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder taskId(String taskId);

        /**
         * <p>
         * Optional filters used to scope down the returned task invocations. The supported filter key is STATUS with
         * the corresponding values PENDING, IN_PROGRESS, SUCCESS, FAILED, TIMED_OUT, CANCELLING, and CANCELLED.
         * </p>
         * 
         * @param filters
         *        Optional filters used to scope down the returned task invocations. The supported filter key is STATUS
         *        with the corresponding values PENDING, IN_PROGRESS, SUCCESS, FAILED, TIMED_OUT, CANCELLING, and
         *        CANCELLED.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder filters(Collection<MaintenanceWindowFilter> filters);

        /**
         * <p>
         * Optional filters used to scope down the returned task invocations. The supported filter key is STATUS with
         * the corresponding values PENDING, IN_PROGRESS, SUCCESS, FAILED, TIMED_OUT, CANCELLING, and CANCELLED.
         * </p>
         * <p>
         * <b>NOTE:</b> This method appends the values to the existing list (if any). Use
         * {@link #setFilters(java.util.Collection)} or {@link #withFilters(java.util.Collection)} if you want to
         * override the existing values.
         * </p>
         * 
         * @param filters
         *        Optional filters used to scope down the returned task invocations. The supported filter key is STATUS
         *        with the corresponding values PENDING, IN_PROGRESS, SUCCESS, FAILED, TIMED_OUT, CANCELLING, and
         *        CANCELLED.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder filters(MaintenanceWindowFilter... filters);

        /**
         * <p>
         * The maximum number of items to return for this call. The call also returns a token that you can specify in a
         * subsequent call to get the next set of results.
         * </p>
         * 
         * @param maxResults
         *        The maximum number of items to return for this call. The call also returns a token that you can
         *        specify in a subsequent call to get the next set of results.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maxResults(Integer maxResults);

        /**
         * <p>
         * The token for the next set of items to return. (You received this token from a previous call.)
         * </p>
         * 
         * @param nextToken
         *        The token for the next set of items to return. (You received this token from a previous call.)
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);
    }

    private static final class BuilderImpl implements Builder {
        private String windowExecutionId;

        private String taskId;

        private List<MaintenanceWindowFilter> filters = new SdkInternalList<>();

        private Integer maxResults;

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeMaintenanceWindowExecutionTaskInvocationsRequest model) {
            setWindowExecutionId(model.windowExecutionId);
            setTaskId(model.taskId);
            setFilters(model.filters);
            setMaxResults(model.maxResults);
            setNextToken(model.nextToken);
        }

        public final String getWindowExecutionId() {
            return windowExecutionId;
        }

        @Override
        public final Builder windowExecutionId(String windowExecutionId) {
            this.windowExecutionId = windowExecutionId;
            return this;
        }

        public final void setWindowExecutionId(String windowExecutionId) {
            this.windowExecutionId = windowExecutionId;
        }

        public final String getTaskId() {
            return taskId;
        }

        @Override
        public final Builder taskId(String taskId) {
            this.taskId = taskId;
            return this;
        }

        public final void setTaskId(String taskId) {
            this.taskId = taskId;
        }

        public final Collection<MaintenanceWindowFilter> getFilters() {
            return filters;
        }

        @Override
        public final Builder filters(Collection<MaintenanceWindowFilter> filters) {
            this.filters = MaintenanceWindowFilterListCopier.copy(filters);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder filters(MaintenanceWindowFilter... filters) {
            if (this.filters == null) {
                this.filters = new SdkInternalList<>(filters.length);
            }
            for (MaintenanceWindowFilter e : filters) {
                this.filters.add(e);
            }
            return this;
        }

        public final void setFilters(Collection<MaintenanceWindowFilter> filters) {
            this.filters = MaintenanceWindowFilterListCopier.copy(filters);
        }

        @SafeVarargs
        public final void setFilters(MaintenanceWindowFilter... filters) {
            if (this.filters == null) {
                this.filters = new SdkInternalList<>(filters.length);
            }
            for (MaintenanceWindowFilter e : filters) {
                this.filters.add(e);
            }
        }

        public final Integer getMaxResults() {
            return maxResults;
        }

        @Override
        public final Builder maxResults(Integer maxResults) {
            this.maxResults = maxResults;
            return this;
        }

        public final void setMaxResults(Integer maxResults) {
            this.maxResults = maxResults;
        }

        public final String getNextToken() {
            return nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public DescribeMaintenanceWindowExecutionTaskInvocationsRequest build() {
            return new DescribeMaintenanceWindowExecutionTaskInvocationsRequest(this);
        }
    }
}
