/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ssm.model;

import java.util.Collection;
import java.util.List;
import javax.annotation.Generated;
import software.amazon.awssdk.AmazonWebServiceResult;
import software.amazon.awssdk.ResponseMetadata;
import software.amazon.awssdk.runtime.SdkInternalList;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public class DescribeParametersResponse extends AmazonWebServiceResult<ResponseMetadata> implements
        ToCopyableBuilder<DescribeParametersResponse.Builder, DescribeParametersResponse> {
    private final List<ParameterMetadata> parameters;

    private final String nextToken;

    private DescribeParametersResponse(BuilderImpl builder) {
        this.parameters = builder.parameters;
        this.nextToken = builder.nextToken;
    }

    /**
     * <p>
     * Parameters returned by the request.
     * </p>
     * 
     * @return Parameters returned by the request.
     */
    public List<ParameterMetadata> parameters() {
        return parameters;
    }

    /**
     * <p>
     * The token to use when requesting the next set of items. If there are no additional items to return, the string is
     * empty.
     * </p>
     * 
     * @return The token to use when requesting the next set of items. If there are no additional items to return, the
     *         string is empty.
     */
    public String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + ((parameters() == null) ? 0 : parameters().hashCode());
        hashCode = 31 * hashCode + ((nextToken() == null) ? 0 : nextToken().hashCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeParametersResponse)) {
            return false;
        }
        DescribeParametersResponse other = (DescribeParametersResponse) obj;
        if (other.parameters() == null ^ this.parameters() == null) {
            return false;
        }
        if (other.parameters() != null && !other.parameters().equals(this.parameters())) {
            return false;
        }
        if (other.nextToken() == null ^ this.nextToken() == null) {
            return false;
        }
        if (other.nextToken() != null && !other.nextToken().equals(this.nextToken())) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (parameters() != null) {
            sb.append("Parameters: ").append(parameters()).append(",");
        }
        if (nextToken() != null) {
            sb.append("NextToken: ").append(nextToken()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    public interface Builder extends CopyableBuilder<Builder, DescribeParametersResponse> {
        /**
         * <p>
         * Parameters returned by the request.
         * </p>
         * 
         * @param parameters
         *        Parameters returned by the request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder parameters(Collection<ParameterMetadata> parameters);

        /**
         * <p>
         * Parameters returned by the request.
         * </p>
         * <p>
         * <b>NOTE:</b> This method appends the values to the existing list (if any). Use
         * {@link #setParameters(java.util.Collection)} or {@link #withParameters(java.util.Collection)} if you want to
         * override the existing values.
         * </p>
         * 
         * @param parameters
         *        Parameters returned by the request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder parameters(ParameterMetadata... parameters);

        /**
         * <p>
         * The token to use when requesting the next set of items. If there are no additional items to return, the
         * string is empty.
         * </p>
         * 
         * @param nextToken
         *        The token to use when requesting the next set of items. If there are no additional items to return,
         *        the string is empty.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);
    }

    private static final class BuilderImpl implements Builder {
        private List<ParameterMetadata> parameters = new SdkInternalList<>();

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeParametersResponse model) {
            setParameters(model.parameters);
            setNextToken(model.nextToken);
        }

        public final Collection<ParameterMetadata> getParameters() {
            return parameters;
        }

        @Override
        public final Builder parameters(Collection<ParameterMetadata> parameters) {
            this.parameters = ParameterMetadataListCopier.copy(parameters);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder parameters(ParameterMetadata... parameters) {
            if (this.parameters == null) {
                this.parameters = new SdkInternalList<>(parameters.length);
            }
            for (ParameterMetadata e : parameters) {
                this.parameters.add(e);
            }
            return this;
        }

        public final void setParameters(Collection<ParameterMetadata> parameters) {
            this.parameters = ParameterMetadataListCopier.copy(parameters);
        }

        @SafeVarargs
        public final void setParameters(ParameterMetadata... parameters) {
            if (this.parameters == null) {
                this.parameters = new SdkInternalList<>(parameters.length);
            }
            for (ParameterMetadata e : parameters) {
                this.parameters.add(e);
            }
        }

        public final String getNextToken() {
            return nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public DescribeParametersResponse build() {
            return new DescribeParametersResponse(this);
        }
    }
}
