/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ssm.model;

import java.util.Collection;
import java.util.List;
import javax.annotation.Generated;
import software.amazon.awssdk.AmazonWebServiceResult;
import software.amazon.awssdk.ResponseMetadata;
import software.amazon.awssdk.runtime.SdkInternalList;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public class DescribePatchBaselinesResponse extends AmazonWebServiceResult<ResponseMetadata> implements
        ToCopyableBuilder<DescribePatchBaselinesResponse.Builder, DescribePatchBaselinesResponse> {
    private final List<PatchBaselineIdentity> baselineIdentities;

    private final String nextToken;

    private DescribePatchBaselinesResponse(BuilderImpl builder) {
        this.baselineIdentities = builder.baselineIdentities;
        this.nextToken = builder.nextToken;
    }

    /**
     * <p>
     * An array of PatchBaselineIdentity elements.
     * </p>
     * 
     * @return An array of PatchBaselineIdentity elements.
     */
    public List<PatchBaselineIdentity> baselineIdentities() {
        return baselineIdentities;
    }

    /**
     * <p>
     * The token to use when requesting the next set of items. If there are no additional items to return, the string is
     * empty.
     * </p>
     * 
     * @return The token to use when requesting the next set of items. If there are no additional items to return, the
     *         string is empty.
     */
    public String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + ((baselineIdentities() == null) ? 0 : baselineIdentities().hashCode());
        hashCode = 31 * hashCode + ((nextToken() == null) ? 0 : nextToken().hashCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribePatchBaselinesResponse)) {
            return false;
        }
        DescribePatchBaselinesResponse other = (DescribePatchBaselinesResponse) obj;
        if (other.baselineIdentities() == null ^ this.baselineIdentities() == null) {
            return false;
        }
        if (other.baselineIdentities() != null && !other.baselineIdentities().equals(this.baselineIdentities())) {
            return false;
        }
        if (other.nextToken() == null ^ this.nextToken() == null) {
            return false;
        }
        if (other.nextToken() != null && !other.nextToken().equals(this.nextToken())) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (baselineIdentities() != null) {
            sb.append("BaselineIdentities: ").append(baselineIdentities()).append(",");
        }
        if (nextToken() != null) {
            sb.append("NextToken: ").append(nextToken()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    public interface Builder extends CopyableBuilder<Builder, DescribePatchBaselinesResponse> {
        /**
         * <p>
         * An array of PatchBaselineIdentity elements.
         * </p>
         * 
         * @param baselineIdentities
         *        An array of PatchBaselineIdentity elements.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder baselineIdentities(Collection<PatchBaselineIdentity> baselineIdentities);

        /**
         * <p>
         * An array of PatchBaselineIdentity elements.
         * </p>
         * <p>
         * <b>NOTE:</b> This method appends the values to the existing list (if any). Use
         * {@link #setBaselineIdentities(java.util.Collection)} or {@link #withBaselineIdentities(java.util.Collection)}
         * if you want to override the existing values.
         * </p>
         * 
         * @param baselineIdentities
         *        An array of PatchBaselineIdentity elements.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder baselineIdentities(PatchBaselineIdentity... baselineIdentities);

        /**
         * <p>
         * The token to use when requesting the next set of items. If there are no additional items to return, the
         * string is empty.
         * </p>
         * 
         * @param nextToken
         *        The token to use when requesting the next set of items. If there are no additional items to return,
         *        the string is empty.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);
    }

    private static final class BuilderImpl implements Builder {
        private List<PatchBaselineIdentity> baselineIdentities = new SdkInternalList<>();

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribePatchBaselinesResponse model) {
            setBaselineIdentities(model.baselineIdentities);
            setNextToken(model.nextToken);
        }

        public final Collection<PatchBaselineIdentity> getBaselineIdentities() {
            return baselineIdentities;
        }

        @Override
        public final Builder baselineIdentities(Collection<PatchBaselineIdentity> baselineIdentities) {
            this.baselineIdentities = PatchBaselineIdentityListCopier.copy(baselineIdentities);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder baselineIdentities(PatchBaselineIdentity... baselineIdentities) {
            if (this.baselineIdentities == null) {
                this.baselineIdentities = new SdkInternalList<>(baselineIdentities.length);
            }
            for (PatchBaselineIdentity e : baselineIdentities) {
                this.baselineIdentities.add(e);
            }
            return this;
        }

        public final void setBaselineIdentities(Collection<PatchBaselineIdentity> baselineIdentities) {
            this.baselineIdentities = PatchBaselineIdentityListCopier.copy(baselineIdentities);
        }

        @SafeVarargs
        public final void setBaselineIdentities(PatchBaselineIdentity... baselineIdentities) {
            if (this.baselineIdentities == null) {
                this.baselineIdentities = new SdkInternalList<>(baselineIdentities.length);
            }
            for (PatchBaselineIdentity e : baselineIdentities) {
                this.baselineIdentities.add(e);
            }
        }

        public final String getNextToken() {
            return nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public DescribePatchBaselinesResponse build() {
            return new DescribePatchBaselinesResponse(this);
        }
    }
}
