/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ssm.model;

import java.util.Collection;
import java.util.List;
import javax.annotation.Generated;
import software.amazon.awssdk.annotation.SdkInternalApi;
import software.amazon.awssdk.protocol.ProtocolMarshaller;
import software.amazon.awssdk.protocol.StructuredPojo;
import software.amazon.awssdk.runtime.SdkInternalList;
import software.amazon.awssdk.services.ssm.transform.DocumentIdentifierMarshaller;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Describes the name of an SSM document.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class DocumentIdentifier implements StructuredPojo, ToCopyableBuilder<DocumentIdentifier.Builder, DocumentIdentifier> {
    private final String name;

    private final String owner;

    private final List<String> platformTypes;

    private final String documentVersion;

    private final String documentType;

    private final String schemaVersion;

    private DocumentIdentifier(BuilderImpl builder) {
        this.name = builder.name;
        this.owner = builder.owner;
        this.platformTypes = builder.platformTypes;
        this.documentVersion = builder.documentVersion;
        this.documentType = builder.documentType;
        this.schemaVersion = builder.schemaVersion;
    }

    /**
     * <p>
     * The name of the SSM document.
     * </p>
     * 
     * @return The name of the SSM document.
     */
    public String name() {
        return name;
    }

    /**
     * <p>
     * The AWS user account of the person who created the document.
     * </p>
     * 
     * @return The AWS user account of the person who created the document.
     */
    public String owner() {
        return owner;
    }

    /**
     * <p>
     * The operating system platform.
     * </p>
     * 
     * @return The operating system platform.
     * @see PlatformType
     */
    public List<String> platformTypes() {
        return platformTypes;
    }

    /**
     * <p>
     * The document version.
     * </p>
     * 
     * @return The document version.
     */
    public String documentVersion() {
        return documentVersion;
    }

    /**
     * <p>
     * The document type.
     * </p>
     * 
     * @return The document type.
     * @see DocumentType
     */
    public String documentType() {
        return documentType;
    }

    /**
     * <p>
     * The schema version.
     * </p>
     * 
     * @return The schema version.
     */
    public String schemaVersion() {
        return schemaVersion;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + ((name() == null) ? 0 : name().hashCode());
        hashCode = 31 * hashCode + ((owner() == null) ? 0 : owner().hashCode());
        hashCode = 31 * hashCode + ((platformTypes() == null) ? 0 : platformTypes().hashCode());
        hashCode = 31 * hashCode + ((documentVersion() == null) ? 0 : documentVersion().hashCode());
        hashCode = 31 * hashCode + ((documentType() == null) ? 0 : documentType().hashCode());
        hashCode = 31 * hashCode + ((schemaVersion() == null) ? 0 : schemaVersion().hashCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DocumentIdentifier)) {
            return false;
        }
        DocumentIdentifier other = (DocumentIdentifier) obj;
        if (other.name() == null ^ this.name() == null) {
            return false;
        }
        if (other.name() != null && !other.name().equals(this.name())) {
            return false;
        }
        if (other.owner() == null ^ this.owner() == null) {
            return false;
        }
        if (other.owner() != null && !other.owner().equals(this.owner())) {
            return false;
        }
        if (other.platformTypes() == null ^ this.platformTypes() == null) {
            return false;
        }
        if (other.platformTypes() != null && !other.platformTypes().equals(this.platformTypes())) {
            return false;
        }
        if (other.documentVersion() == null ^ this.documentVersion() == null) {
            return false;
        }
        if (other.documentVersion() != null && !other.documentVersion().equals(this.documentVersion())) {
            return false;
        }
        if (other.documentType() == null ^ this.documentType() == null) {
            return false;
        }
        if (other.documentType() != null && !other.documentType().equals(this.documentType())) {
            return false;
        }
        if (other.schemaVersion() == null ^ this.schemaVersion() == null) {
            return false;
        }
        if (other.schemaVersion() != null && !other.schemaVersion().equals(this.schemaVersion())) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (name() != null) {
            sb.append("Name: ").append(name()).append(",");
        }
        if (owner() != null) {
            sb.append("Owner: ").append(owner()).append(",");
        }
        if (platformTypes() != null) {
            sb.append("PlatformTypes: ").append(platformTypes()).append(",");
        }
        if (documentVersion() != null) {
            sb.append("DocumentVersion: ").append(documentVersion()).append(",");
        }
        if (documentType() != null) {
            sb.append("DocumentType: ").append(documentType()).append(",");
        }
        if (schemaVersion() != null) {
            sb.append("SchemaVersion: ").append(schemaVersion()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    @SdkInternalApi
    @Override
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        DocumentIdentifierMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    public interface Builder extends CopyableBuilder<Builder, DocumentIdentifier> {
        /**
         * <p>
         * The name of the SSM document.
         * </p>
         * 
         * @param name
         *        The name of the SSM document.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * The AWS user account of the person who created the document.
         * </p>
         * 
         * @param owner
         *        The AWS user account of the person who created the document.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder owner(String owner);

        /**
         * <p>
         * The operating system platform.
         * </p>
         * 
         * @param platformTypes
         *        The operating system platform.
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see PlatformType
         */
        Builder platformTypes(Collection<String> platformTypes);

        /**
         * <p>
         * The operating system platform.
         * </p>
         * <p>
         * <b>NOTE:</b> This method appends the values to the existing list (if any). Use
         * {@link #setPlatformTypes(java.util.Collection)} or {@link #withPlatformTypes(java.util.Collection)} if you
         * want to override the existing values.
         * </p>
         * 
         * @param platformTypes
         *        The operating system platform.
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see PlatformType
         */
        Builder platformTypes(String... platformTypes);

        /**
         * <p>
         * The operating system platform.
         * </p>
         * <p>
         * <b>NOTE:</b> This method appends the values to the existing list (if any). Use
         * {@link #setPlatformTypes(java.util.Collection)} or {@link #withPlatformTypes(java.util.Collection)} if you
         * want to override the existing values.
         * </p>
         * 
         * @param platformTypes
         *        The operating system platform.
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see PlatformType
         */
        Builder platformTypes(PlatformType... platformTypes);

        /**
         * <p>
         * The document version.
         * </p>
         * 
         * @param documentVersion
         *        The document version.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder documentVersion(String documentVersion);

        /**
         * <p>
         * The document type.
         * </p>
         * 
         * @param documentType
         *        The document type.
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see DocumentType
         */
        Builder documentType(String documentType);

        /**
         * <p>
         * The document type.
         * </p>
         * 
         * @param documentType
         *        The document type.
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see DocumentType
         */
        Builder documentType(DocumentType documentType);

        /**
         * <p>
         * The schema version.
         * </p>
         * 
         * @param schemaVersion
         *        The schema version.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder schemaVersion(String schemaVersion);
    }

    private static final class BuilderImpl implements Builder {
        private String name;

        private String owner;

        private List<String> platformTypes = new SdkInternalList<>();

        private String documentVersion;

        private String documentType;

        private String schemaVersion;

        private BuilderImpl() {
        }

        private BuilderImpl(DocumentIdentifier model) {
            setName(model.name);
            setOwner(model.owner);
            setPlatformTypes(model.platformTypes);
            setDocumentVersion(model.documentVersion);
            setDocumentType(model.documentType);
            setSchemaVersion(model.schemaVersion);
        }

        public final String getName() {
            return name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final void setName(String name) {
            this.name = name;
        }

        public final String getOwner() {
            return owner;
        }

        @Override
        public final Builder owner(String owner) {
            this.owner = owner;
            return this;
        }

        public final void setOwner(String owner) {
            this.owner = owner;
        }

        public final Collection<String> getPlatformTypes() {
            return platformTypes;
        }

        @Override
        public final Builder platformTypes(Collection<String> platformTypes) {
            this.platformTypes = PlatformTypeListCopier.copy(platformTypes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder platformTypes(String... platformTypes) {
            if (this.platformTypes == null) {
                this.platformTypes = new SdkInternalList<>(platformTypes.length);
            }
            for (String e : platformTypes) {
                this.platformTypes.add(e);
            }
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder platformTypes(PlatformType... platformTypes) {
            if (this.platformTypes == null) {
                this.platformTypes = new SdkInternalList<String>(platformTypes.length);
            }
            for (PlatformType ele : platformTypes) {
                this.platformTypes.add(ele.toString());
            }
            return this;
        }

        public final void setPlatformTypes(Collection<String> platformTypes) {
            this.platformTypes = PlatformTypeListCopier.copy(platformTypes);
        }

        @SafeVarargs
        public final void setPlatformTypes(String... platformTypes) {
            if (this.platformTypes == null) {
                this.platformTypes = new SdkInternalList<>(platformTypes.length);
            }
            for (String e : platformTypes) {
                this.platformTypes.add(e);
            }
        }

        @SafeVarargs
        public final void setPlatformTypes(PlatformType... platformTypes) {
            if (this.platformTypes == null) {
                this.platformTypes = new SdkInternalList<String>(platformTypes.length);
            }
            for (PlatformType ele : platformTypes) {
                this.platformTypes.add(ele.toString());
            }
        }

        public final String getDocumentVersion() {
            return documentVersion;
        }

        @Override
        public final Builder documentVersion(String documentVersion) {
            this.documentVersion = documentVersion;
            return this;
        }

        public final void setDocumentVersion(String documentVersion) {
            this.documentVersion = documentVersion;
        }

        public final String getDocumentType() {
            return documentType;
        }

        @Override
        public final Builder documentType(String documentType) {
            this.documentType = documentType;
            return this;
        }

        @Override
        public final Builder documentType(DocumentType documentType) {
            this.documentType(documentType.toString());
            return this;
        }

        public final void setDocumentType(String documentType) {
            this.documentType = documentType;
        }

        public final void setDocumentType(DocumentType documentType) {
            this.documentType(documentType.toString());
        }

        public final String getSchemaVersion() {
            return schemaVersion;
        }

        @Override
        public final Builder schemaVersion(String schemaVersion) {
            this.schemaVersion = schemaVersion;
            return this;
        }

        public final void setSchemaVersion(String schemaVersion) {
            this.schemaVersion = schemaVersion;
        }

        @Override
        public DocumentIdentifier build() {
            return new DocumentIdentifier(this);
        }
    }
}
