/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ssm.model;

import java.util.Collection;
import java.util.List;
import javax.annotation.Generated;
import software.amazon.awssdk.AmazonWebServiceRequest;
import software.amazon.awssdk.runtime.SdkInternalList;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public class GetInventoryRequest extends AmazonWebServiceRequest implements
        ToCopyableBuilder<GetInventoryRequest.Builder, GetInventoryRequest> {
    private final List<InventoryFilter> filters;

    private final List<ResultAttribute> resultAttributes;

    private final String nextToken;

    private final Integer maxResults;

    private GetInventoryRequest(BuilderImpl builder) {
        this.filters = builder.filters;
        this.resultAttributes = builder.resultAttributes;
        this.nextToken = builder.nextToken;
        this.maxResults = builder.maxResults;
    }

    /**
     * <p>
     * One or more filters. Use a filter to return a more specific list of results.
     * </p>
     * 
     * @return One or more filters. Use a filter to return a more specific list of results.
     */
    public List<InventoryFilter> filters() {
        return filters;
    }

    /**
     * <p>
     * The list of inventory item types to return.
     * </p>
     * 
     * @return The list of inventory item types to return.
     */
    public List<ResultAttribute> resultAttributes() {
        return resultAttributes;
    }

    /**
     * <p>
     * The token for the next set of items to return. (You received this token from a previous call.)
     * </p>
     * 
     * @return The token for the next set of items to return. (You received this token from a previous call.)
     */
    public String nextToken() {
        return nextToken;
    }

    /**
     * <p>
     * The maximum number of items to return for this call. The call also returns a token that you can specify in a
     * subsequent call to get the next set of results.
     * </p>
     * 
     * @return The maximum number of items to return for this call. The call also returns a token that you can specify
     *         in a subsequent call to get the next set of results.
     */
    public Integer maxResults() {
        return maxResults;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + ((filters() == null) ? 0 : filters().hashCode());
        hashCode = 31 * hashCode + ((resultAttributes() == null) ? 0 : resultAttributes().hashCode());
        hashCode = 31 * hashCode + ((nextToken() == null) ? 0 : nextToken().hashCode());
        hashCode = 31 * hashCode + ((maxResults() == null) ? 0 : maxResults().hashCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetInventoryRequest)) {
            return false;
        }
        GetInventoryRequest other = (GetInventoryRequest) obj;
        if (other.filters() == null ^ this.filters() == null) {
            return false;
        }
        if (other.filters() != null && !other.filters().equals(this.filters())) {
            return false;
        }
        if (other.resultAttributes() == null ^ this.resultAttributes() == null) {
            return false;
        }
        if (other.resultAttributes() != null && !other.resultAttributes().equals(this.resultAttributes())) {
            return false;
        }
        if (other.nextToken() == null ^ this.nextToken() == null) {
            return false;
        }
        if (other.nextToken() != null && !other.nextToken().equals(this.nextToken())) {
            return false;
        }
        if (other.maxResults() == null ^ this.maxResults() == null) {
            return false;
        }
        if (other.maxResults() != null && !other.maxResults().equals(this.maxResults())) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (filters() != null) {
            sb.append("Filters: ").append(filters()).append(",");
        }
        if (resultAttributes() != null) {
            sb.append("ResultAttributes: ").append(resultAttributes()).append(",");
        }
        if (nextToken() != null) {
            sb.append("NextToken: ").append(nextToken()).append(",");
        }
        if (maxResults() != null) {
            sb.append("MaxResults: ").append(maxResults()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    public interface Builder extends CopyableBuilder<Builder, GetInventoryRequest> {
        /**
         * <p>
         * One or more filters. Use a filter to return a more specific list of results.
         * </p>
         * 
         * @param filters
         *        One or more filters. Use a filter to return a more specific list of results.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder filters(Collection<InventoryFilter> filters);

        /**
         * <p>
         * One or more filters. Use a filter to return a more specific list of results.
         * </p>
         * <p>
         * <b>NOTE:</b> This method appends the values to the existing list (if any). Use
         * {@link #setFilters(java.util.Collection)} or {@link #withFilters(java.util.Collection)} if you want to
         * override the existing values.
         * </p>
         * 
         * @param filters
         *        One or more filters. Use a filter to return a more specific list of results.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder filters(InventoryFilter... filters);

        /**
         * <p>
         * The list of inventory item types to return.
         * </p>
         * 
         * @param resultAttributes
         *        The list of inventory item types to return.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resultAttributes(Collection<ResultAttribute> resultAttributes);

        /**
         * <p>
         * The list of inventory item types to return.
         * </p>
         * <p>
         * <b>NOTE:</b> This method appends the values to the existing list (if any). Use
         * {@link #setResultAttributes(java.util.Collection)} or {@link #withResultAttributes(java.util.Collection)} if
         * you want to override the existing values.
         * </p>
         * 
         * @param resultAttributes
         *        The list of inventory item types to return.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resultAttributes(ResultAttribute... resultAttributes);

        /**
         * <p>
         * The token for the next set of items to return. (You received this token from a previous call.)
         * </p>
         * 
         * @param nextToken
         *        The token for the next set of items to return. (You received this token from a previous call.)
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);

        /**
         * <p>
         * The maximum number of items to return for this call. The call also returns a token that you can specify in a
         * subsequent call to get the next set of results.
         * </p>
         * 
         * @param maxResults
         *        The maximum number of items to return for this call. The call also returns a token that you can
         *        specify in a subsequent call to get the next set of results.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maxResults(Integer maxResults);
    }

    private static final class BuilderImpl implements Builder {
        private List<InventoryFilter> filters = new SdkInternalList<>();

        private List<ResultAttribute> resultAttributes = new SdkInternalList<>();

        private String nextToken;

        private Integer maxResults;

        private BuilderImpl() {
        }

        private BuilderImpl(GetInventoryRequest model) {
            setFilters(model.filters);
            setResultAttributes(model.resultAttributes);
            setNextToken(model.nextToken);
            setMaxResults(model.maxResults);
        }

        public final Collection<InventoryFilter> getFilters() {
            return filters;
        }

        @Override
        public final Builder filters(Collection<InventoryFilter> filters) {
            this.filters = InventoryFilterListCopier.copy(filters);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder filters(InventoryFilter... filters) {
            if (this.filters == null) {
                this.filters = new SdkInternalList<>(filters.length);
            }
            for (InventoryFilter e : filters) {
                this.filters.add(e);
            }
            return this;
        }

        public final void setFilters(Collection<InventoryFilter> filters) {
            this.filters = InventoryFilterListCopier.copy(filters);
        }

        @SafeVarargs
        public final void setFilters(InventoryFilter... filters) {
            if (this.filters == null) {
                this.filters = new SdkInternalList<>(filters.length);
            }
            for (InventoryFilter e : filters) {
                this.filters.add(e);
            }
        }

        public final Collection<ResultAttribute> getResultAttributes() {
            return resultAttributes;
        }

        @Override
        public final Builder resultAttributes(Collection<ResultAttribute> resultAttributes) {
            this.resultAttributes = ResultAttributeListCopier.copy(resultAttributes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder resultAttributes(ResultAttribute... resultAttributes) {
            if (this.resultAttributes == null) {
                this.resultAttributes = new SdkInternalList<>(resultAttributes.length);
            }
            for (ResultAttribute e : resultAttributes) {
                this.resultAttributes.add(e);
            }
            return this;
        }

        public final void setResultAttributes(Collection<ResultAttribute> resultAttributes) {
            this.resultAttributes = ResultAttributeListCopier.copy(resultAttributes);
        }

        @SafeVarargs
        public final void setResultAttributes(ResultAttribute... resultAttributes) {
            if (this.resultAttributes == null) {
                this.resultAttributes = new SdkInternalList<>(resultAttributes.length);
            }
            for (ResultAttribute e : resultAttributes) {
                this.resultAttributes.add(e);
            }
        }

        public final String getNextToken() {
            return nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        public final Integer getMaxResults() {
            return maxResults;
        }

        @Override
        public final Builder maxResults(Integer maxResults) {
            this.maxResults = maxResults;
            return this;
        }

        public final void setMaxResults(Integer maxResults) {
            this.maxResults = maxResults;
        }

        @Override
        public GetInventoryRequest build() {
            return new GetInventoryRequest(this);
        }
    }
}
