/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ssm.model;

import java.util.Collection;
import java.util.List;
import javax.annotation.Generated;
import software.amazon.awssdk.AmazonWebServiceResult;
import software.amazon.awssdk.ResponseMetadata;
import software.amazon.awssdk.runtime.SdkInternalList;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public class GetInventoryResponse extends AmazonWebServiceResult<ResponseMetadata> implements
        ToCopyableBuilder<GetInventoryResponse.Builder, GetInventoryResponse> {
    private final List<InventoryResultEntity> entities;

    private final String nextToken;

    private GetInventoryResponse(BuilderImpl builder) {
        this.entities = builder.entities;
        this.nextToken = builder.nextToken;
    }

    /**
     * <p>
     * Collection of inventory entities such as a collection of instance inventory.
     * </p>
     * 
     * @return Collection of inventory entities such as a collection of instance inventory.
     */
    public List<InventoryResultEntity> entities() {
        return entities;
    }

    /**
     * <p>
     * The token to use when requesting the next set of items. If there are no additional items to return, the string is
     * empty.
     * </p>
     * 
     * @return The token to use when requesting the next set of items. If there are no additional items to return, the
     *         string is empty.
     */
    public String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + ((entities() == null) ? 0 : entities().hashCode());
        hashCode = 31 * hashCode + ((nextToken() == null) ? 0 : nextToken().hashCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetInventoryResponse)) {
            return false;
        }
        GetInventoryResponse other = (GetInventoryResponse) obj;
        if (other.entities() == null ^ this.entities() == null) {
            return false;
        }
        if (other.entities() != null && !other.entities().equals(this.entities())) {
            return false;
        }
        if (other.nextToken() == null ^ this.nextToken() == null) {
            return false;
        }
        if (other.nextToken() != null && !other.nextToken().equals(this.nextToken())) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (entities() != null) {
            sb.append("Entities: ").append(entities()).append(",");
        }
        if (nextToken() != null) {
            sb.append("NextToken: ").append(nextToken()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    public interface Builder extends CopyableBuilder<Builder, GetInventoryResponse> {
        /**
         * <p>
         * Collection of inventory entities such as a collection of instance inventory.
         * </p>
         * 
         * @param entities
         *        Collection of inventory entities such as a collection of instance inventory.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder entities(Collection<InventoryResultEntity> entities);

        /**
         * <p>
         * Collection of inventory entities such as a collection of instance inventory.
         * </p>
         * <p>
         * <b>NOTE:</b> This method appends the values to the existing list (if any). Use
         * {@link #setEntities(java.util.Collection)} or {@link #withEntities(java.util.Collection)} if you want to
         * override the existing values.
         * </p>
         * 
         * @param entities
         *        Collection of inventory entities such as a collection of instance inventory.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder entities(InventoryResultEntity... entities);

        /**
         * <p>
         * The token to use when requesting the next set of items. If there are no additional items to return, the
         * string is empty.
         * </p>
         * 
         * @param nextToken
         *        The token to use when requesting the next set of items. If there are no additional items to return,
         *        the string is empty.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);
    }

    private static final class BuilderImpl implements Builder {
        private List<InventoryResultEntity> entities = new SdkInternalList<>();

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(GetInventoryResponse model) {
            setEntities(model.entities);
            setNextToken(model.nextToken);
        }

        public final Collection<InventoryResultEntity> getEntities() {
            return entities;
        }

        @Override
        public final Builder entities(Collection<InventoryResultEntity> entities) {
            this.entities = InventoryResultEntityListCopier.copy(entities);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder entities(InventoryResultEntity... entities) {
            if (this.entities == null) {
                this.entities = new SdkInternalList<>(entities.length);
            }
            for (InventoryResultEntity e : entities) {
                this.entities.add(e);
            }
            return this;
        }

        public final void setEntities(Collection<InventoryResultEntity> entities) {
            this.entities = InventoryResultEntityListCopier.copy(entities);
        }

        @SafeVarargs
        public final void setEntities(InventoryResultEntity... entities) {
            if (this.entities == null) {
                this.entities = new SdkInternalList<>(entities.length);
            }
            for (InventoryResultEntity e : entities) {
                this.entities.add(e);
            }
        }

        public final String getNextToken() {
            return nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public GetInventoryResponse build() {
            return new GetInventoryResponse(this);
        }
    }
}
