/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ssm.model;

import java.util.Collection;
import java.util.List;
import javax.annotation.Generated;
import software.amazon.awssdk.AmazonWebServiceResult;
import software.amazon.awssdk.ResponseMetadata;
import software.amazon.awssdk.runtime.SdkInternalList;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public class GetParameterHistoryResponse extends AmazonWebServiceResult<ResponseMetadata> implements
        ToCopyableBuilder<GetParameterHistoryResponse.Builder, GetParameterHistoryResponse> {
    private final List<ParameterHistory> parameters;

    private final String nextToken;

    private GetParameterHistoryResponse(BuilderImpl builder) {
        this.parameters = builder.parameters;
        this.nextToken = builder.nextToken;
    }

    /**
     * <p>
     * A list of parameters returned by the request.
     * </p>
     * 
     * @return A list of parameters returned by the request.
     */
    public List<ParameterHistory> parameters() {
        return parameters;
    }

    /**
     * <p>
     * The token to use when requesting the next set of items. If there are no additional items to return, the string is
     * empty.
     * </p>
     * 
     * @return The token to use when requesting the next set of items. If there are no additional items to return, the
     *         string is empty.
     */
    public String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + ((parameters() == null) ? 0 : parameters().hashCode());
        hashCode = 31 * hashCode + ((nextToken() == null) ? 0 : nextToken().hashCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetParameterHistoryResponse)) {
            return false;
        }
        GetParameterHistoryResponse other = (GetParameterHistoryResponse) obj;
        if (other.parameters() == null ^ this.parameters() == null) {
            return false;
        }
        if (other.parameters() != null && !other.parameters().equals(this.parameters())) {
            return false;
        }
        if (other.nextToken() == null ^ this.nextToken() == null) {
            return false;
        }
        if (other.nextToken() != null && !other.nextToken().equals(this.nextToken())) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (parameters() != null) {
            sb.append("Parameters: ").append(parameters()).append(",");
        }
        if (nextToken() != null) {
            sb.append("NextToken: ").append(nextToken()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    public interface Builder extends CopyableBuilder<Builder, GetParameterHistoryResponse> {
        /**
         * <p>
         * A list of parameters returned by the request.
         * </p>
         * 
         * @param parameters
         *        A list of parameters returned by the request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder parameters(Collection<ParameterHistory> parameters);

        /**
         * <p>
         * A list of parameters returned by the request.
         * </p>
         * <p>
         * <b>NOTE:</b> This method appends the values to the existing list (if any). Use
         * {@link #setParameters(java.util.Collection)} or {@link #withParameters(java.util.Collection)} if you want to
         * override the existing values.
         * </p>
         * 
         * @param parameters
         *        A list of parameters returned by the request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder parameters(ParameterHistory... parameters);

        /**
         * <p>
         * The token to use when requesting the next set of items. If there are no additional items to return, the
         * string is empty.
         * </p>
         * 
         * @param nextToken
         *        The token to use when requesting the next set of items. If there are no additional items to return,
         *        the string is empty.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);
    }

    private static final class BuilderImpl implements Builder {
        private List<ParameterHistory> parameters = new SdkInternalList<>();

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(GetParameterHistoryResponse model) {
            setParameters(model.parameters);
            setNextToken(model.nextToken);
        }

        public final Collection<ParameterHistory> getParameters() {
            return parameters;
        }

        @Override
        public final Builder parameters(Collection<ParameterHistory> parameters) {
            this.parameters = ParameterHistoryListCopier.copy(parameters);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder parameters(ParameterHistory... parameters) {
            if (this.parameters == null) {
                this.parameters = new SdkInternalList<>(parameters.length);
            }
            for (ParameterHistory e : parameters) {
                this.parameters.add(e);
            }
            return this;
        }

        public final void setParameters(Collection<ParameterHistory> parameters) {
            this.parameters = ParameterHistoryListCopier.copy(parameters);
        }

        @SafeVarargs
        public final void setParameters(ParameterHistory... parameters) {
            if (this.parameters == null) {
                this.parameters = new SdkInternalList<>(parameters.length);
            }
            for (ParameterHistory e : parameters) {
                this.parameters.add(e);
            }
        }

        public final String getNextToken() {
            return nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public GetParameterHistoryResponse build() {
            return new GetParameterHistoryResponse(this);
        }
    }
}
