/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ssm.model;

import java.util.Map;
import javax.annotation.Generated;
import software.amazon.awssdk.annotation.SdkInternalApi;
import software.amazon.awssdk.protocol.ProtocolMarshaller;
import software.amazon.awssdk.protocol.StructuredPojo;
import software.amazon.awssdk.services.ssm.transform.InventoryResultEntityMarshaller;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Inventory query results.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class InventoryResultEntity implements StructuredPojo,
        ToCopyableBuilder<InventoryResultEntity.Builder, InventoryResultEntity> {
    private final String id;

    private final Map<String, InventoryResultItem> data;

    private InventoryResultEntity(BuilderImpl builder) {
        this.id = builder.id;
        this.data = builder.data;
    }

    /**
     * <p>
     * ID of the inventory result entity. For example, for managed instance inventory the result will be the managed
     * instance ID. For EC2 instance inventory, the result will be the instance ID.
     * </p>
     * 
     * @return ID of the inventory result entity. For example, for managed instance inventory the result will be the
     *         managed instance ID. For EC2 instance inventory, the result will be the instance ID.
     */
    public String id() {
        return id;
    }

    /**
     * <p>
     * The data section in the inventory result entity json.
     * </p>
     * 
     * @return The data section in the inventory result entity json.
     */
    public Map<String, InventoryResultItem> data() {
        return data;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + ((id() == null) ? 0 : id().hashCode());
        hashCode = 31 * hashCode + ((data() == null) ? 0 : data().hashCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof InventoryResultEntity)) {
            return false;
        }
        InventoryResultEntity other = (InventoryResultEntity) obj;
        if (other.id() == null ^ this.id() == null) {
            return false;
        }
        if (other.id() != null && !other.id().equals(this.id())) {
            return false;
        }
        if (other.data() == null ^ this.data() == null) {
            return false;
        }
        if (other.data() != null && !other.data().equals(this.data())) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (id() != null) {
            sb.append("Id: ").append(id()).append(",");
        }
        if (data() != null) {
            sb.append("Data: ").append(data()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    @SdkInternalApi
    @Override
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        InventoryResultEntityMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    public interface Builder extends CopyableBuilder<Builder, InventoryResultEntity> {
        /**
         * <p>
         * ID of the inventory result entity. For example, for managed instance inventory the result will be the managed
         * instance ID. For EC2 instance inventory, the result will be the instance ID.
         * </p>
         * 
         * @param id
         *        ID of the inventory result entity. For example, for managed instance inventory the result will be the
         *        managed instance ID. For EC2 instance inventory, the result will be the instance ID.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder id(String id);

        /**
         * <p>
         * The data section in the inventory result entity json.
         * </p>
         * 
         * @param data
         *        The data section in the inventory result entity json.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder data(Map<String, InventoryResultItem> data);
    }

    private static final class BuilderImpl implements Builder {
        private String id;

        private Map<String, InventoryResultItem> data;

        private BuilderImpl() {
        }

        private BuilderImpl(InventoryResultEntity model) {
            setId(model.id);
            setData(model.data);
        }

        public final String getId() {
            return id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final void setId(String id) {
            this.id = id;
        }

        public final Map<String, InventoryResultItem> getData() {
            return data;
        }

        @Override
        public final Builder data(Map<String, InventoryResultItem> data) {
            this.data = InventoryResultItemMapCopier.copy(data);
            return this;
        }

        public final void setData(Map<String, InventoryResultItem> data) {
            this.data = InventoryResultItemMapCopier.copy(data);
        }

        @Override
        public InventoryResultEntity build() {
            return new InventoryResultEntity(this);
        }
    }
}
