/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ssm.model;

import java.util.HashMap;
import java.util.Map;
import javax.annotation.Generated;
import software.amazon.awssdk.runtime.StandardMemberCopier;

@Generated("software.amazon.awssdk:codegen")
final class MaintenanceWindowTaskParametersCopier {
    static Map<String, MaintenanceWindowTaskParameterValueExpression> copy(
            Map<String, MaintenanceWindowTaskParameterValueExpression> maintenanceWindowTaskParametersParam) {
        if (maintenanceWindowTaskParametersParam == null) {
            return null;
        }
        Map<String, MaintenanceWindowTaskParameterValueExpression> maintenanceWindowTaskParametersParamCopy = new HashMap<>(
                maintenanceWindowTaskParametersParam.size());
        for (Map.Entry<String, MaintenanceWindowTaskParameterValueExpression> e : maintenanceWindowTaskParametersParam.entrySet()) {
            maintenanceWindowTaskParametersParamCopy.put(StandardMemberCopier.copy(e.getKey()), e.getValue());
        }
        return maintenanceWindowTaskParametersParamCopy;
    }
}
