/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ssm.model;

import java.util.Date;
import javax.annotation.Generated;
import software.amazon.awssdk.annotation.SdkInternalApi;
import software.amazon.awssdk.protocol.ProtocolMarshaller;
import software.amazon.awssdk.protocol.StructuredPojo;
import software.amazon.awssdk.runtime.StandardMemberCopier;
import software.amazon.awssdk.services.ssm.transform.PatchMarshaller;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Represents metadata about a patch.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class Patch implements StructuredPojo, ToCopyableBuilder<Patch.Builder, Patch> {
    private final String id;

    private final Date releaseDate;

    private final String title;

    private final String description;

    private final String contentUrl;

    private final String vendor;

    private final String productFamily;

    private final String product;

    private final String classification;

    private final String msrcSeverity;

    private final String kbNumber;

    private final String msrcNumber;

    private final String language;

    private Patch(BuilderImpl builder) {
        this.id = builder.id;
        this.releaseDate = builder.releaseDate;
        this.title = builder.title;
        this.description = builder.description;
        this.contentUrl = builder.contentUrl;
        this.vendor = builder.vendor;
        this.productFamily = builder.productFamily;
        this.product = builder.product;
        this.classification = builder.classification;
        this.msrcSeverity = builder.msrcSeverity;
        this.kbNumber = builder.kbNumber;
        this.msrcNumber = builder.msrcNumber;
        this.language = builder.language;
    }

    /**
     * <p>
     * The ID of the patch (this is different than the Microsoft Knowledge Base ID).
     * </p>
     * 
     * @return The ID of the patch (this is different than the Microsoft Knowledge Base ID).
     */
    public String id() {
        return id;
    }

    /**
     * <p>
     * The date the patch was released.
     * </p>
     * 
     * @return The date the patch was released.
     */
    public Date releaseDate() {
        return releaseDate;
    }

    /**
     * <p>
     * The title of the patch.
     * </p>
     * 
     * @return The title of the patch.
     */
    public String title() {
        return title;
    }

    /**
     * <p>
     * The description of the patch.
     * </p>
     * 
     * @return The description of the patch.
     */
    public String description() {
        return description;
    }

    /**
     * <p>
     * The URL where more information can be obtained about the patch.
     * </p>
     * 
     * @return The URL where more information can be obtained about the patch.
     */
    public String contentUrl() {
        return contentUrl;
    }

    /**
     * <p>
     * The name of the vendor providing the patch.
     * </p>
     * 
     * @return The name of the vendor providing the patch.
     */
    public String vendor() {
        return vendor;
    }

    /**
     * <p>
     * The product family the patch is applicable for (for example, Windows).
     * </p>
     * 
     * @return The product family the patch is applicable for (for example, Windows).
     */
    public String productFamily() {
        return productFamily;
    }

    /**
     * <p>
     * The specific product the patch is applicable for (for example, WindowsServer2016).
     * </p>
     * 
     * @return The specific product the patch is applicable for (for example, WindowsServer2016).
     */
    public String product() {
        return product;
    }

    /**
     * <p>
     * The classification of the patch (for example, SecurityUpdates, Updates, CriticalUpdates).
     * </p>
     * 
     * @return The classification of the patch (for example, SecurityUpdates, Updates, CriticalUpdates).
     */
    public String classification() {
        return classification;
    }

    /**
     * <p>
     * The severity of the patch (for example Critical, Important, Moderate).
     * </p>
     * 
     * @return The severity of the patch (for example Critical, Important, Moderate).
     */
    public String msrcSeverity() {
        return msrcSeverity;
    }

    /**
     * <p>
     * The Microsoft Knowledge Base ID of the patch.
     * </p>
     * 
     * @return The Microsoft Knowledge Base ID of the patch.
     */
    public String kbNumber() {
        return kbNumber;
    }

    /**
     * <p>
     * The ID of the MSRC bulletin the patch is related to.
     * </p>
     * 
     * @return The ID of the MSRC bulletin the patch is related to.
     */
    public String msrcNumber() {
        return msrcNumber;
    }

    /**
     * <p>
     * The language of the patch if it's language-specific.
     * </p>
     * 
     * @return The language of the patch if it's language-specific.
     */
    public String language() {
        return language;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + ((id() == null) ? 0 : id().hashCode());
        hashCode = 31 * hashCode + ((releaseDate() == null) ? 0 : releaseDate().hashCode());
        hashCode = 31 * hashCode + ((title() == null) ? 0 : title().hashCode());
        hashCode = 31 * hashCode + ((description() == null) ? 0 : description().hashCode());
        hashCode = 31 * hashCode + ((contentUrl() == null) ? 0 : contentUrl().hashCode());
        hashCode = 31 * hashCode + ((vendor() == null) ? 0 : vendor().hashCode());
        hashCode = 31 * hashCode + ((productFamily() == null) ? 0 : productFamily().hashCode());
        hashCode = 31 * hashCode + ((product() == null) ? 0 : product().hashCode());
        hashCode = 31 * hashCode + ((classification() == null) ? 0 : classification().hashCode());
        hashCode = 31 * hashCode + ((msrcSeverity() == null) ? 0 : msrcSeverity().hashCode());
        hashCode = 31 * hashCode + ((kbNumber() == null) ? 0 : kbNumber().hashCode());
        hashCode = 31 * hashCode + ((msrcNumber() == null) ? 0 : msrcNumber().hashCode());
        hashCode = 31 * hashCode + ((language() == null) ? 0 : language().hashCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Patch)) {
            return false;
        }
        Patch other = (Patch) obj;
        if (other.id() == null ^ this.id() == null) {
            return false;
        }
        if (other.id() != null && !other.id().equals(this.id())) {
            return false;
        }
        if (other.releaseDate() == null ^ this.releaseDate() == null) {
            return false;
        }
        if (other.releaseDate() != null && !other.releaseDate().equals(this.releaseDate())) {
            return false;
        }
        if (other.title() == null ^ this.title() == null) {
            return false;
        }
        if (other.title() != null && !other.title().equals(this.title())) {
            return false;
        }
        if (other.description() == null ^ this.description() == null) {
            return false;
        }
        if (other.description() != null && !other.description().equals(this.description())) {
            return false;
        }
        if (other.contentUrl() == null ^ this.contentUrl() == null) {
            return false;
        }
        if (other.contentUrl() != null && !other.contentUrl().equals(this.contentUrl())) {
            return false;
        }
        if (other.vendor() == null ^ this.vendor() == null) {
            return false;
        }
        if (other.vendor() != null && !other.vendor().equals(this.vendor())) {
            return false;
        }
        if (other.productFamily() == null ^ this.productFamily() == null) {
            return false;
        }
        if (other.productFamily() != null && !other.productFamily().equals(this.productFamily())) {
            return false;
        }
        if (other.product() == null ^ this.product() == null) {
            return false;
        }
        if (other.product() != null && !other.product().equals(this.product())) {
            return false;
        }
        if (other.classification() == null ^ this.classification() == null) {
            return false;
        }
        if (other.classification() != null && !other.classification().equals(this.classification())) {
            return false;
        }
        if (other.msrcSeverity() == null ^ this.msrcSeverity() == null) {
            return false;
        }
        if (other.msrcSeverity() != null && !other.msrcSeverity().equals(this.msrcSeverity())) {
            return false;
        }
        if (other.kbNumber() == null ^ this.kbNumber() == null) {
            return false;
        }
        if (other.kbNumber() != null && !other.kbNumber().equals(this.kbNumber())) {
            return false;
        }
        if (other.msrcNumber() == null ^ this.msrcNumber() == null) {
            return false;
        }
        if (other.msrcNumber() != null && !other.msrcNumber().equals(this.msrcNumber())) {
            return false;
        }
        if (other.language() == null ^ this.language() == null) {
            return false;
        }
        if (other.language() != null && !other.language().equals(this.language())) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (id() != null) {
            sb.append("Id: ").append(id()).append(",");
        }
        if (releaseDate() != null) {
            sb.append("ReleaseDate: ").append(releaseDate()).append(",");
        }
        if (title() != null) {
            sb.append("Title: ").append(title()).append(",");
        }
        if (description() != null) {
            sb.append("Description: ").append(description()).append(",");
        }
        if (contentUrl() != null) {
            sb.append("ContentUrl: ").append(contentUrl()).append(",");
        }
        if (vendor() != null) {
            sb.append("Vendor: ").append(vendor()).append(",");
        }
        if (productFamily() != null) {
            sb.append("ProductFamily: ").append(productFamily()).append(",");
        }
        if (product() != null) {
            sb.append("Product: ").append(product()).append(",");
        }
        if (classification() != null) {
            sb.append("Classification: ").append(classification()).append(",");
        }
        if (msrcSeverity() != null) {
            sb.append("MsrcSeverity: ").append(msrcSeverity()).append(",");
        }
        if (kbNumber() != null) {
            sb.append("KbNumber: ").append(kbNumber()).append(",");
        }
        if (msrcNumber() != null) {
            sb.append("MsrcNumber: ").append(msrcNumber()).append(",");
        }
        if (language() != null) {
            sb.append("Language: ").append(language()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    @SdkInternalApi
    @Override
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        PatchMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    public interface Builder extends CopyableBuilder<Builder, Patch> {
        /**
         * <p>
         * The ID of the patch (this is different than the Microsoft Knowledge Base ID).
         * </p>
         * 
         * @param id
         *        The ID of the patch (this is different than the Microsoft Knowledge Base ID).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder id(String id);

        /**
         * <p>
         * The date the patch was released.
         * </p>
         * 
         * @param releaseDate
         *        The date the patch was released.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder releaseDate(Date releaseDate);

        /**
         * <p>
         * The title of the patch.
         * </p>
         * 
         * @param title
         *        The title of the patch.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder title(String title);

        /**
         * <p>
         * The description of the patch.
         * </p>
         * 
         * @param description
         *        The description of the patch.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * <p>
         * The URL where more information can be obtained about the patch.
         * </p>
         * 
         * @param contentUrl
         *        The URL where more information can be obtained about the patch.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder contentUrl(String contentUrl);

        /**
         * <p>
         * The name of the vendor providing the patch.
         * </p>
         * 
         * @param vendor
         *        The name of the vendor providing the patch.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder vendor(String vendor);

        /**
         * <p>
         * The product family the patch is applicable for (for example, Windows).
         * </p>
         * 
         * @param productFamily
         *        The product family the patch is applicable for (for example, Windows).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder productFamily(String productFamily);

        /**
         * <p>
         * The specific product the patch is applicable for (for example, WindowsServer2016).
         * </p>
         * 
         * @param product
         *        The specific product the patch is applicable for (for example, WindowsServer2016).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder product(String product);

        /**
         * <p>
         * The classification of the patch (for example, SecurityUpdates, Updates, CriticalUpdates).
         * </p>
         * 
         * @param classification
         *        The classification of the patch (for example, SecurityUpdates, Updates, CriticalUpdates).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder classification(String classification);

        /**
         * <p>
         * The severity of the patch (for example Critical, Important, Moderate).
         * </p>
         * 
         * @param msrcSeverity
         *        The severity of the patch (for example Critical, Important, Moderate).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder msrcSeverity(String msrcSeverity);

        /**
         * <p>
         * The Microsoft Knowledge Base ID of the patch.
         * </p>
         * 
         * @param kbNumber
         *        The Microsoft Knowledge Base ID of the patch.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder kbNumber(String kbNumber);

        /**
         * <p>
         * The ID of the MSRC bulletin the patch is related to.
         * </p>
         * 
         * @param msrcNumber
         *        The ID of the MSRC bulletin the patch is related to.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder msrcNumber(String msrcNumber);

        /**
         * <p>
         * The language of the patch if it's language-specific.
         * </p>
         * 
         * @param language
         *        The language of the patch if it's language-specific.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder language(String language);
    }

    private static final class BuilderImpl implements Builder {
        private String id;

        private Date releaseDate;

        private String title;

        private String description;

        private String contentUrl;

        private String vendor;

        private String productFamily;

        private String product;

        private String classification;

        private String msrcSeverity;

        private String kbNumber;

        private String msrcNumber;

        private String language;

        private BuilderImpl() {
        }

        private BuilderImpl(Patch model) {
            setId(model.id);
            setReleaseDate(model.releaseDate);
            setTitle(model.title);
            setDescription(model.description);
            setContentUrl(model.contentUrl);
            setVendor(model.vendor);
            setProductFamily(model.productFamily);
            setProduct(model.product);
            setClassification(model.classification);
            setMsrcSeverity(model.msrcSeverity);
            setKbNumber(model.kbNumber);
            setMsrcNumber(model.msrcNumber);
            setLanguage(model.language);
        }

        public final String getId() {
            return id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final void setId(String id) {
            this.id = id;
        }

        public final Date getReleaseDate() {
            return releaseDate;
        }

        @Override
        public final Builder releaseDate(Date releaseDate) {
            this.releaseDate = StandardMemberCopier.copy(releaseDate);
            return this;
        }

        public final void setReleaseDate(Date releaseDate) {
            this.releaseDate = StandardMemberCopier.copy(releaseDate);
        }

        public final String getTitle() {
            return title;
        }

        @Override
        public final Builder title(String title) {
            this.title = title;
            return this;
        }

        public final void setTitle(String title) {
            this.title = title;
        }

        public final String getDescription() {
            return description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        public final String getContentUrl() {
            return contentUrl;
        }

        @Override
        public final Builder contentUrl(String contentUrl) {
            this.contentUrl = contentUrl;
            return this;
        }

        public final void setContentUrl(String contentUrl) {
            this.contentUrl = contentUrl;
        }

        public final String getVendor() {
            return vendor;
        }

        @Override
        public final Builder vendor(String vendor) {
            this.vendor = vendor;
            return this;
        }

        public final void setVendor(String vendor) {
            this.vendor = vendor;
        }

        public final String getProductFamily() {
            return productFamily;
        }

        @Override
        public final Builder productFamily(String productFamily) {
            this.productFamily = productFamily;
            return this;
        }

        public final void setProductFamily(String productFamily) {
            this.productFamily = productFamily;
        }

        public final String getProduct() {
            return product;
        }

        @Override
        public final Builder product(String product) {
            this.product = product;
            return this;
        }

        public final void setProduct(String product) {
            this.product = product;
        }

        public final String getClassification() {
            return classification;
        }

        @Override
        public final Builder classification(String classification) {
            this.classification = classification;
            return this;
        }

        public final void setClassification(String classification) {
            this.classification = classification;
        }

        public final String getMsrcSeverity() {
            return msrcSeverity;
        }

        @Override
        public final Builder msrcSeverity(String msrcSeverity) {
            this.msrcSeverity = msrcSeverity;
            return this;
        }

        public final void setMsrcSeverity(String msrcSeverity) {
            this.msrcSeverity = msrcSeverity;
        }

        public final String getKbNumber() {
            return kbNumber;
        }

        @Override
        public final Builder kbNumber(String kbNumber) {
            this.kbNumber = kbNumber;
            return this;
        }

        public final void setKbNumber(String kbNumber) {
            this.kbNumber = kbNumber;
        }

        public final String getMsrcNumber() {
            return msrcNumber;
        }

        @Override
        public final Builder msrcNumber(String msrcNumber) {
            this.msrcNumber = msrcNumber;
            return this;
        }

        public final void setMsrcNumber(String msrcNumber) {
            this.msrcNumber = msrcNumber;
        }

        public final String getLanguage() {
            return language;
        }

        @Override
        public final Builder language(String language) {
            this.language = language;
            return this;
        }

        public final void setLanguage(String language) {
            this.language = language;
        }

        @Override
        public Patch build() {
            return new Patch(this);
        }
    }
}
