/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ssm.model;

import java.util.Collection;
import java.util.List;
import javax.annotation.Generated;
import software.amazon.awssdk.annotation.SdkInternalApi;
import software.amazon.awssdk.protocol.ProtocolMarshaller;
import software.amazon.awssdk.protocol.StructuredPojo;
import software.amazon.awssdk.runtime.SdkInternalList;
import software.amazon.awssdk.services.ssm.transform.PatchFilterGroupMarshaller;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A set of patch filters, typically used for approval rules.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class PatchFilterGroup implements StructuredPojo, ToCopyableBuilder<PatchFilterGroup.Builder, PatchFilterGroup> {
    private final List<PatchFilter> patchFilters;

    private PatchFilterGroup(BuilderImpl builder) {
        this.patchFilters = builder.patchFilters;
    }

    /**
     * <p>
     * The set of patch filters that make up the group.
     * </p>
     * 
     * @return The set of patch filters that make up the group.
     */
    public List<PatchFilter> patchFilters() {
        return patchFilters;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + ((patchFilters() == null) ? 0 : patchFilters().hashCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PatchFilterGroup)) {
            return false;
        }
        PatchFilterGroup other = (PatchFilterGroup) obj;
        if (other.patchFilters() == null ^ this.patchFilters() == null) {
            return false;
        }
        if (other.patchFilters() != null && !other.patchFilters().equals(this.patchFilters())) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (patchFilters() != null) {
            sb.append("PatchFilters: ").append(patchFilters()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    @SdkInternalApi
    @Override
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        PatchFilterGroupMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    public interface Builder extends CopyableBuilder<Builder, PatchFilterGroup> {
        /**
         * <p>
         * The set of patch filters that make up the group.
         * </p>
         * 
         * @param patchFilters
         *        The set of patch filters that make up the group.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder patchFilters(Collection<PatchFilter> patchFilters);

        /**
         * <p>
         * The set of patch filters that make up the group.
         * </p>
         * <p>
         * <b>NOTE:</b> This method appends the values to the existing list (if any). Use
         * {@link #setPatchFilters(java.util.Collection)} or {@link #withPatchFilters(java.util.Collection)} if you want
         * to override the existing values.
         * </p>
         * 
         * @param patchFilters
         *        The set of patch filters that make up the group.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder patchFilters(PatchFilter... patchFilters);
    }

    private static final class BuilderImpl implements Builder {
        private List<PatchFilter> patchFilters = new SdkInternalList<>();

        private BuilderImpl() {
        }

        private BuilderImpl(PatchFilterGroup model) {
            setPatchFilters(model.patchFilters);
        }

        public final Collection<PatchFilter> getPatchFilters() {
            return patchFilters;
        }

        @Override
        public final Builder patchFilters(Collection<PatchFilter> patchFilters) {
            this.patchFilters = PatchFilterListCopier.copy(patchFilters);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder patchFilters(PatchFilter... patchFilters) {
            if (this.patchFilters == null) {
                this.patchFilters = new SdkInternalList<>(patchFilters.length);
            }
            for (PatchFilter e : patchFilters) {
                this.patchFilters.add(e);
            }
            return this;
        }

        public final void setPatchFilters(Collection<PatchFilter> patchFilters) {
            this.patchFilters = PatchFilterListCopier.copy(patchFilters);
        }

        @SafeVarargs
        public final void setPatchFilters(PatchFilter... patchFilters) {
            if (this.patchFilters == null) {
                this.patchFilters = new SdkInternalList<>(patchFilters.length);
            }
            for (PatchFilter e : patchFilters) {
                this.patchFilters.add(e);
            }
        }

        @Override
        public PatchFilterGroup build() {
            return new PatchFilterGroup(this);
        }
    }
}
