/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ssm.model;

import java.util.Collection;
import java.util.List;
import javax.annotation.Generated;
import software.amazon.awssdk.annotation.SdkInternalApi;
import software.amazon.awssdk.protocol.ProtocolMarshaller;
import software.amazon.awssdk.protocol.StructuredPojo;
import software.amazon.awssdk.runtime.SdkInternalList;
import software.amazon.awssdk.services.ssm.transform.PatchRuleGroupMarshaller;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A set of rules defining the approval rules for a patch baseline.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class PatchRuleGroup implements StructuredPojo, ToCopyableBuilder<PatchRuleGroup.Builder, PatchRuleGroup> {
    private final List<PatchRule> patchRules;

    private PatchRuleGroup(BuilderImpl builder) {
        this.patchRules = builder.patchRules;
    }

    /**
     * <p>
     * The rules that make up the rule group.
     * </p>
     * 
     * @return The rules that make up the rule group.
     */
    public List<PatchRule> patchRules() {
        return patchRules;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + ((patchRules() == null) ? 0 : patchRules().hashCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PatchRuleGroup)) {
            return false;
        }
        PatchRuleGroup other = (PatchRuleGroup) obj;
        if (other.patchRules() == null ^ this.patchRules() == null) {
            return false;
        }
        if (other.patchRules() != null && !other.patchRules().equals(this.patchRules())) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (patchRules() != null) {
            sb.append("PatchRules: ").append(patchRules()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    @SdkInternalApi
    @Override
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        PatchRuleGroupMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    public interface Builder extends CopyableBuilder<Builder, PatchRuleGroup> {
        /**
         * <p>
         * The rules that make up the rule group.
         * </p>
         * 
         * @param patchRules
         *        The rules that make up the rule group.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder patchRules(Collection<PatchRule> patchRules);

        /**
         * <p>
         * The rules that make up the rule group.
         * </p>
         * <p>
         * <b>NOTE:</b> This method appends the values to the existing list (if any). Use
         * {@link #setPatchRules(java.util.Collection)} or {@link #withPatchRules(java.util.Collection)} if you want to
         * override the existing values.
         * </p>
         * 
         * @param patchRules
         *        The rules that make up the rule group.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder patchRules(PatchRule... patchRules);
    }

    private static final class BuilderImpl implements Builder {
        private List<PatchRule> patchRules = new SdkInternalList<>();

        private BuilderImpl() {
        }

        private BuilderImpl(PatchRuleGroup model) {
            setPatchRules(model.patchRules);
        }

        public final Collection<PatchRule> getPatchRules() {
            return patchRules;
        }

        @Override
        public final Builder patchRules(Collection<PatchRule> patchRules) {
            this.patchRules = PatchRuleListCopier.copy(patchRules);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder patchRules(PatchRule... patchRules) {
            if (this.patchRules == null) {
                this.patchRules = new SdkInternalList<>(patchRules.length);
            }
            for (PatchRule e : patchRules) {
                this.patchRules.add(e);
            }
            return this;
        }

        public final void setPatchRules(Collection<PatchRule> patchRules) {
            this.patchRules = PatchRuleListCopier.copy(patchRules);
        }

        @SafeVarargs
        public final void setPatchRules(PatchRule... patchRules) {
            if (this.patchRules == null) {
                this.patchRules = new SdkInternalList<>(patchRules.length);
            }
            for (PatchRule e : patchRules) {
                this.patchRules.add(e);
            }
        }

        @Override
        public PatchRuleGroup build() {
            return new PatchRuleGroup(this);
        }
    }
}
