/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ssm.model;

import java.util.Collection;
import java.util.List;
import java.util.Map;
import software.amazon.awssdk.annotation.SdkInternalApi;
import software.amazon.awssdk.protocol.ProtocolMarshaller;
import software.amazon.awssdk.protocol.StructuredPojo;
import software.amazon.awssdk.runtime.SdkInternalList;
import software.amazon.awssdk.services.ssm.model.InventoryItemEntryCopier;
import software.amazon.awssdk.services.ssm.model.InventoryItemEntryListCopier;
import software.amazon.awssdk.services.ssm.transform.InventoryItemMarshaller;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class InventoryItem
implements StructuredPojo,
ToCopyableBuilder<Builder, InventoryItem> {
    private final String typeName;
    private final String schemaVersion;
    private final String captureTime;
    private final String contentHash;
    private final List<Map<String, String>> content;

    private InventoryItem(BuilderImpl builder) {
        this.typeName = builder.typeName;
        this.schemaVersion = builder.schemaVersion;
        this.captureTime = builder.captureTime;
        this.contentHash = builder.contentHash;
        this.content = builder.content;
    }

    public String typeName() {
        return this.typeName;
    }

    public String schemaVersion() {
        return this.schemaVersion;
    }

    public String captureTime() {
        return this.captureTime;
    }

    public String contentHash() {
        return this.contentHash;
    }

    public List<Map<String, String>> content() {
        return this.content;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.typeName() == null ? 0 : this.typeName().hashCode());
        hashCode = 31 * hashCode + (this.schemaVersion() == null ? 0 : this.schemaVersion().hashCode());
        hashCode = 31 * hashCode + (this.captureTime() == null ? 0 : this.captureTime().hashCode());
        hashCode = 31 * hashCode + (this.contentHash() == null ? 0 : this.contentHash().hashCode());
        hashCode = 31 * hashCode + (this.content() == null ? 0 : this.content().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof InventoryItem)) {
            return false;
        }
        InventoryItem other = (InventoryItem)obj;
        if (other.typeName() == null ^ this.typeName() == null) {
            return false;
        }
        if (other.typeName() != null && !other.typeName().equals(this.typeName())) {
            return false;
        }
        if (other.schemaVersion() == null ^ this.schemaVersion() == null) {
            return false;
        }
        if (other.schemaVersion() != null && !other.schemaVersion().equals(this.schemaVersion())) {
            return false;
        }
        if (other.captureTime() == null ^ this.captureTime() == null) {
            return false;
        }
        if (other.captureTime() != null && !other.captureTime().equals(this.captureTime())) {
            return false;
        }
        if (other.contentHash() == null ^ this.contentHash() == null) {
            return false;
        }
        if (other.contentHash() != null && !other.contentHash().equals(this.contentHash())) {
            return false;
        }
        if (other.content() == null ^ this.content() == null) {
            return false;
        }
        return other.content() == null || other.content().equals(this.content());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.typeName() != null) {
            sb.append("TypeName: ").append(this.typeName()).append(",");
        }
        if (this.schemaVersion() != null) {
            sb.append("SchemaVersion: ").append(this.schemaVersion()).append(",");
        }
        if (this.captureTime() != null) {
            sb.append("CaptureTime: ").append(this.captureTime()).append(",");
        }
        if (this.contentHash() != null) {
            sb.append("ContentHash: ").append(this.contentHash()).append(",");
        }
        if (this.content() != null) {
            sb.append("Content: ").append(this.content()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        InventoryItemMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    private static final class BuilderImpl
    implements Builder {
        private String typeName;
        private String schemaVersion;
        private String captureTime;
        private String contentHash;
        private List<Map<String, String>> content = new SdkInternalList();

        private BuilderImpl() {
        }

        private BuilderImpl(InventoryItem model) {
            this.setTypeName(model.typeName);
            this.setSchemaVersion(model.schemaVersion);
            this.setCaptureTime(model.captureTime);
            this.setContentHash(model.contentHash);
            this.setContent(model.content);
        }

        public final String getTypeName() {
            return this.typeName;
        }

        @Override
        public final Builder typeName(String typeName) {
            this.typeName = typeName;
            return this;
        }

        public final void setTypeName(String typeName) {
            this.typeName = typeName;
        }

        public final String getSchemaVersion() {
            return this.schemaVersion;
        }

        @Override
        public final Builder schemaVersion(String schemaVersion) {
            this.schemaVersion = schemaVersion;
            return this;
        }

        public final void setSchemaVersion(String schemaVersion) {
            this.schemaVersion = schemaVersion;
        }

        public final String getCaptureTime() {
            return this.captureTime;
        }

        @Override
        public final Builder captureTime(String captureTime) {
            this.captureTime = captureTime;
            return this;
        }

        public final void setCaptureTime(String captureTime) {
            this.captureTime = captureTime;
        }

        public final String getContentHash() {
            return this.contentHash;
        }

        @Override
        public final Builder contentHash(String contentHash) {
            this.contentHash = contentHash;
            return this;
        }

        public final void setContentHash(String contentHash) {
            this.contentHash = contentHash;
        }

        public final Collection<Map<String, String>> getContent() {
            return this.content;
        }

        @Override
        public final Builder content(Collection<Map<String, String>> content) {
            this.content = InventoryItemEntryListCopier.copy(content);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder content(Map<String, String> ... content) {
            if (this.content == null) {
                this.content = new SdkInternalList(content.length);
            }
            for (Map<String, String> e : content) {
                this.content.add(InventoryItemEntryCopier.copy(e));
            }
            return this;
        }

        public final void setContent(Collection<Map<String, String>> content) {
            this.content = InventoryItemEntryListCopier.copy(content);
        }

        @SafeVarargs
        public final void setContent(Map<String, String> ... content) {
            if (this.content == null) {
                this.content = new SdkInternalList(content.length);
            }
            for (Map<String, String> e : content) {
                this.content.add(InventoryItemEntryCopier.copy(e));
            }
        }

        public InventoryItem build() {
            return new InventoryItem(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, InventoryItem> {
        public Builder typeName(String var1);

        public Builder schemaVersion(String var1);

        public Builder captureTime(String var1);

        public Builder contentHash(String var1);

        public Builder content(Collection<Map<String, String>> var1);

        public Builder content(Map<String, String> ... var1);
    }
}

