/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ssm.model;

import java.util.Collection;
import java.util.List;
import software.amazon.awssdk.annotation.SdkInternalApi;
import software.amazon.awssdk.protocol.ProtocolMarshaller;
import software.amazon.awssdk.protocol.StructuredPojo;
import software.amazon.awssdk.runtime.SdkInternalList;
import software.amazon.awssdk.services.ssm.model.NotificationEvent;
import software.amazon.awssdk.services.ssm.model.NotificationEventListCopier;
import software.amazon.awssdk.services.ssm.model.NotificationType;
import software.amazon.awssdk.services.ssm.transform.NotificationConfigMarshaller;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class NotificationConfig
implements StructuredPojo,
ToCopyableBuilder<Builder, NotificationConfig> {
    private final String notificationArn;
    private final List<String> notificationEvents;
    private final String notificationType;

    private NotificationConfig(BuilderImpl builder) {
        this.notificationArn = builder.notificationArn;
        this.notificationEvents = builder.notificationEvents;
        this.notificationType = builder.notificationType;
    }

    public String notificationArn() {
        return this.notificationArn;
    }

    public List<String> notificationEvents() {
        return this.notificationEvents;
    }

    public String notificationType() {
        return this.notificationType;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.notificationArn() == null ? 0 : this.notificationArn().hashCode());
        hashCode = 31 * hashCode + (this.notificationEvents() == null ? 0 : this.notificationEvents().hashCode());
        hashCode = 31 * hashCode + (this.notificationType() == null ? 0 : this.notificationType().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof NotificationConfig)) {
            return false;
        }
        NotificationConfig other = (NotificationConfig)obj;
        if (other.notificationArn() == null ^ this.notificationArn() == null) {
            return false;
        }
        if (other.notificationArn() != null && !other.notificationArn().equals(this.notificationArn())) {
            return false;
        }
        if (other.notificationEvents() == null ^ this.notificationEvents() == null) {
            return false;
        }
        if (other.notificationEvents() != null && !other.notificationEvents().equals(this.notificationEvents())) {
            return false;
        }
        if (other.notificationType() == null ^ this.notificationType() == null) {
            return false;
        }
        return other.notificationType() == null || other.notificationType().equals(this.notificationType());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.notificationArn() != null) {
            sb.append("NotificationArn: ").append(this.notificationArn()).append(",");
        }
        if (this.notificationEvents() != null) {
            sb.append("NotificationEvents: ").append(this.notificationEvents()).append(",");
        }
        if (this.notificationType() != null) {
            sb.append("NotificationType: ").append(this.notificationType()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        NotificationConfigMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    private static final class BuilderImpl
    implements Builder {
        private String notificationArn;
        private List<String> notificationEvents = new SdkInternalList();
        private String notificationType;

        private BuilderImpl() {
        }

        private BuilderImpl(NotificationConfig model) {
            this.setNotificationArn(model.notificationArn);
            this.setNotificationEvents(model.notificationEvents);
            this.setNotificationType(model.notificationType);
        }

        public final String getNotificationArn() {
            return this.notificationArn;
        }

        @Override
        public final Builder notificationArn(String notificationArn) {
            this.notificationArn = notificationArn;
            return this;
        }

        public final void setNotificationArn(String notificationArn) {
            this.notificationArn = notificationArn;
        }

        public final Collection<String> getNotificationEvents() {
            return this.notificationEvents;
        }

        @Override
        public final Builder notificationEvents(Collection<String> notificationEvents) {
            this.notificationEvents = NotificationEventListCopier.copy(notificationEvents);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder notificationEvents(String ... notificationEvents) {
            if (this.notificationEvents == null) {
                this.notificationEvents = new SdkInternalList(notificationEvents.length);
            }
            for (String e : notificationEvents) {
                this.notificationEvents.add(e);
            }
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder notificationEvents(NotificationEvent ... notificationEvents) {
            if (this.notificationEvents == null) {
                this.notificationEvents = new SdkInternalList(notificationEvents.length);
            }
            for (NotificationEvent ele : notificationEvents) {
                this.notificationEvents.add(ele.toString());
            }
            return this;
        }

        public final void setNotificationEvents(Collection<String> notificationEvents) {
            this.notificationEvents = NotificationEventListCopier.copy(notificationEvents);
        }

        @SafeVarargs
        public final void setNotificationEvents(String ... notificationEvents) {
            if (this.notificationEvents == null) {
                this.notificationEvents = new SdkInternalList(notificationEvents.length);
            }
            for (String e : notificationEvents) {
                this.notificationEvents.add(e);
            }
        }

        @SafeVarargs
        public final void setNotificationEvents(NotificationEvent ... notificationEvents) {
            if (this.notificationEvents == null) {
                this.notificationEvents = new SdkInternalList(notificationEvents.length);
            }
            for (NotificationEvent ele : notificationEvents) {
                this.notificationEvents.add(ele.toString());
            }
        }

        public final String getNotificationType() {
            return this.notificationType;
        }

        @Override
        public final Builder notificationType(String notificationType) {
            this.notificationType = notificationType;
            return this;
        }

        @Override
        public final Builder notificationType(NotificationType notificationType) {
            this.notificationType(notificationType.toString());
            return this;
        }

        public final void setNotificationType(String notificationType) {
            this.notificationType = notificationType;
        }

        public final void setNotificationType(NotificationType notificationType) {
            this.notificationType(notificationType.toString());
        }

        public NotificationConfig build() {
            return new NotificationConfig(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, NotificationConfig> {
        public Builder notificationArn(String var1);

        public Builder notificationEvents(Collection<String> var1);

        public Builder notificationEvents(String ... var1);

        public Builder notificationEvents(NotificationEvent ... var1);

        public Builder notificationType(String var1);

        public Builder notificationType(NotificationType var1);
    }
}

