/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ssm.model;

import java.util.Collection;
import java.util.List;
import java.util.Map;
import software.amazon.awssdk.AmazonWebServiceRequest;
import software.amazon.awssdk.runtime.SdkInternalList;
import software.amazon.awssdk.services.ssm.model.LoggingInfo;
import software.amazon.awssdk.services.ssm.model.MaintenanceWindowTaskParameterValueExpression;
import software.amazon.awssdk.services.ssm.model.MaintenanceWindowTaskParametersCopier;
import software.amazon.awssdk.services.ssm.model.MaintenanceWindowTaskType;
import software.amazon.awssdk.services.ssm.model.Target;
import software.amazon.awssdk.services.ssm.model.TargetsCopier;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class RegisterTaskWithMaintenanceWindowRequest
extends AmazonWebServiceRequest
implements ToCopyableBuilder<Builder, RegisterTaskWithMaintenanceWindowRequest> {
    private final String windowId;
    private final List<Target> targets;
    private final String taskArn;
    private final String serviceRoleArn;
    private final String taskType;
    private final Map<String, MaintenanceWindowTaskParameterValueExpression> taskParameters;
    private final Integer priority;
    private final String maxConcurrency;
    private final String maxErrors;
    private final LoggingInfo loggingInfo;
    private final String clientToken;

    private RegisterTaskWithMaintenanceWindowRequest(BuilderImpl builder) {
        this.windowId = builder.windowId;
        this.targets = builder.targets;
        this.taskArn = builder.taskArn;
        this.serviceRoleArn = builder.serviceRoleArn;
        this.taskType = builder.taskType;
        this.taskParameters = builder.taskParameters;
        this.priority = builder.priority;
        this.maxConcurrency = builder.maxConcurrency;
        this.maxErrors = builder.maxErrors;
        this.loggingInfo = builder.loggingInfo;
        this.clientToken = builder.clientToken;
    }

    public String windowId() {
        return this.windowId;
    }

    public List<Target> targets() {
        return this.targets;
    }

    public String taskArn() {
        return this.taskArn;
    }

    public String serviceRoleArn() {
        return this.serviceRoleArn;
    }

    public String taskType() {
        return this.taskType;
    }

    public Map<String, MaintenanceWindowTaskParameterValueExpression> taskParameters() {
        return this.taskParameters;
    }

    public Integer priority() {
        return this.priority;
    }

    public String maxConcurrency() {
        return this.maxConcurrency;
    }

    public String maxErrors() {
        return this.maxErrors;
    }

    public LoggingInfo loggingInfo() {
        return this.loggingInfo;
    }

    public String clientToken() {
        return this.clientToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.windowId() == null ? 0 : this.windowId().hashCode());
        hashCode = 31 * hashCode + (this.targets() == null ? 0 : this.targets().hashCode());
        hashCode = 31 * hashCode + (this.taskArn() == null ? 0 : this.taskArn().hashCode());
        hashCode = 31 * hashCode + (this.serviceRoleArn() == null ? 0 : this.serviceRoleArn().hashCode());
        hashCode = 31 * hashCode + (this.taskType() == null ? 0 : this.taskType().hashCode());
        hashCode = 31 * hashCode + (this.taskParameters() == null ? 0 : this.taskParameters().hashCode());
        hashCode = 31 * hashCode + (this.priority() == null ? 0 : this.priority().hashCode());
        hashCode = 31 * hashCode + (this.maxConcurrency() == null ? 0 : this.maxConcurrency().hashCode());
        hashCode = 31 * hashCode + (this.maxErrors() == null ? 0 : this.maxErrors().hashCode());
        hashCode = 31 * hashCode + (this.loggingInfo() == null ? 0 : this.loggingInfo().hashCode());
        hashCode = 31 * hashCode + (this.clientToken() == null ? 0 : this.clientToken().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RegisterTaskWithMaintenanceWindowRequest)) {
            return false;
        }
        RegisterTaskWithMaintenanceWindowRequest other = (RegisterTaskWithMaintenanceWindowRequest)((Object)obj);
        if (other.windowId() == null ^ this.windowId() == null) {
            return false;
        }
        if (other.windowId() != null && !other.windowId().equals(this.windowId())) {
            return false;
        }
        if (other.targets() == null ^ this.targets() == null) {
            return false;
        }
        if (other.targets() != null && !other.targets().equals(this.targets())) {
            return false;
        }
        if (other.taskArn() == null ^ this.taskArn() == null) {
            return false;
        }
        if (other.taskArn() != null && !other.taskArn().equals(this.taskArn())) {
            return false;
        }
        if (other.serviceRoleArn() == null ^ this.serviceRoleArn() == null) {
            return false;
        }
        if (other.serviceRoleArn() != null && !other.serviceRoleArn().equals(this.serviceRoleArn())) {
            return false;
        }
        if (other.taskType() == null ^ this.taskType() == null) {
            return false;
        }
        if (other.taskType() != null && !other.taskType().equals(this.taskType())) {
            return false;
        }
        if (other.taskParameters() == null ^ this.taskParameters() == null) {
            return false;
        }
        if (other.taskParameters() != null && !other.taskParameters().equals(this.taskParameters())) {
            return false;
        }
        if (other.priority() == null ^ this.priority() == null) {
            return false;
        }
        if (other.priority() != null && !other.priority().equals(this.priority())) {
            return false;
        }
        if (other.maxConcurrency() == null ^ this.maxConcurrency() == null) {
            return false;
        }
        if (other.maxConcurrency() != null && !other.maxConcurrency().equals(this.maxConcurrency())) {
            return false;
        }
        if (other.maxErrors() == null ^ this.maxErrors() == null) {
            return false;
        }
        if (other.maxErrors() != null && !other.maxErrors().equals(this.maxErrors())) {
            return false;
        }
        if (other.loggingInfo() == null ^ this.loggingInfo() == null) {
            return false;
        }
        if (other.loggingInfo() != null && !other.loggingInfo().equals(this.loggingInfo())) {
            return false;
        }
        if (other.clientToken() == null ^ this.clientToken() == null) {
            return false;
        }
        return other.clientToken() == null || other.clientToken().equals(this.clientToken());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.windowId() != null) {
            sb.append("WindowId: ").append(this.windowId()).append(",");
        }
        if (this.targets() != null) {
            sb.append("Targets: ").append(this.targets()).append(",");
        }
        if (this.taskArn() != null) {
            sb.append("TaskArn: ").append(this.taskArn()).append(",");
        }
        if (this.serviceRoleArn() != null) {
            sb.append("ServiceRoleArn: ").append(this.serviceRoleArn()).append(",");
        }
        if (this.taskType() != null) {
            sb.append("TaskType: ").append(this.taskType()).append(",");
        }
        if (this.taskParameters() != null) {
            sb.append("TaskParameters: ").append(this.taskParameters()).append(",");
        }
        if (this.priority() != null) {
            sb.append("Priority: ").append(this.priority()).append(",");
        }
        if (this.maxConcurrency() != null) {
            sb.append("MaxConcurrency: ").append(this.maxConcurrency()).append(",");
        }
        if (this.maxErrors() != null) {
            sb.append("MaxErrors: ").append(this.maxErrors()).append(",");
        }
        if (this.loggingInfo() != null) {
            sb.append("LoggingInfo: ").append(this.loggingInfo()).append(",");
        }
        if (this.clientToken() != null) {
            sb.append("ClientToken: ").append(this.clientToken()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    private static final class BuilderImpl
    implements Builder {
        private String windowId;
        private List<Target> targets = new SdkInternalList();
        private String taskArn;
        private String serviceRoleArn;
        private String taskType;
        private Map<String, MaintenanceWindowTaskParameterValueExpression> taskParameters;
        private Integer priority;
        private String maxConcurrency;
        private String maxErrors;
        private LoggingInfo loggingInfo;
        private String clientToken;

        private BuilderImpl() {
        }

        private BuilderImpl(RegisterTaskWithMaintenanceWindowRequest model) {
            this.setWindowId(model.windowId);
            this.setTargets(model.targets);
            this.setTaskArn(model.taskArn);
            this.setServiceRoleArn(model.serviceRoleArn);
            this.setTaskType(model.taskType);
            this.setTaskParameters(model.taskParameters);
            this.setPriority(model.priority);
            this.setMaxConcurrency(model.maxConcurrency);
            this.setMaxErrors(model.maxErrors);
            this.setLoggingInfo(model.loggingInfo);
            this.setClientToken(model.clientToken);
        }

        public final String getWindowId() {
            return this.windowId;
        }

        @Override
        public final Builder windowId(String windowId) {
            this.windowId = windowId;
            return this;
        }

        public final void setWindowId(String windowId) {
            this.windowId = windowId;
        }

        public final Collection<Target> getTargets() {
            return this.targets;
        }

        @Override
        public final Builder targets(Collection<Target> targets) {
            this.targets = TargetsCopier.copy(targets);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder targets(Target ... targets) {
            if (this.targets == null) {
                this.targets = new SdkInternalList(targets.length);
            }
            for (Target e : targets) {
                this.targets.add(e);
            }
            return this;
        }

        public final void setTargets(Collection<Target> targets) {
            this.targets = TargetsCopier.copy(targets);
        }

        @SafeVarargs
        public final void setTargets(Target ... targets) {
            if (this.targets == null) {
                this.targets = new SdkInternalList(targets.length);
            }
            for (Target e : targets) {
                this.targets.add(e);
            }
        }

        public final String getTaskArn() {
            return this.taskArn;
        }

        @Override
        public final Builder taskArn(String taskArn) {
            this.taskArn = taskArn;
            return this;
        }

        public final void setTaskArn(String taskArn) {
            this.taskArn = taskArn;
        }

        public final String getServiceRoleArn() {
            return this.serviceRoleArn;
        }

        @Override
        public final Builder serviceRoleArn(String serviceRoleArn) {
            this.serviceRoleArn = serviceRoleArn;
            return this;
        }

        public final void setServiceRoleArn(String serviceRoleArn) {
            this.serviceRoleArn = serviceRoleArn;
        }

        public final String getTaskType() {
            return this.taskType;
        }

        @Override
        public final Builder taskType(String taskType) {
            this.taskType = taskType;
            return this;
        }

        @Override
        public final Builder taskType(MaintenanceWindowTaskType taskType) {
            this.taskType(taskType.toString());
            return this;
        }

        public final void setTaskType(String taskType) {
            this.taskType = taskType;
        }

        public final void setTaskType(MaintenanceWindowTaskType taskType) {
            this.taskType(taskType.toString());
        }

        public final Map<String, MaintenanceWindowTaskParameterValueExpression> getTaskParameters() {
            return this.taskParameters;
        }

        @Override
        public final Builder taskParameters(Map<String, MaintenanceWindowTaskParameterValueExpression> taskParameters) {
            this.taskParameters = MaintenanceWindowTaskParametersCopier.copy(taskParameters);
            return this;
        }

        public final void setTaskParameters(Map<String, MaintenanceWindowTaskParameterValueExpression> taskParameters) {
            this.taskParameters = MaintenanceWindowTaskParametersCopier.copy(taskParameters);
        }

        public final Integer getPriority() {
            return this.priority;
        }

        @Override
        public final Builder priority(Integer priority) {
            this.priority = priority;
            return this;
        }

        public final void setPriority(Integer priority) {
            this.priority = priority;
        }

        public final String getMaxConcurrency() {
            return this.maxConcurrency;
        }

        @Override
        public final Builder maxConcurrency(String maxConcurrency) {
            this.maxConcurrency = maxConcurrency;
            return this;
        }

        public final void setMaxConcurrency(String maxConcurrency) {
            this.maxConcurrency = maxConcurrency;
        }

        public final String getMaxErrors() {
            return this.maxErrors;
        }

        @Override
        public final Builder maxErrors(String maxErrors) {
            this.maxErrors = maxErrors;
            return this;
        }

        public final void setMaxErrors(String maxErrors) {
            this.maxErrors = maxErrors;
        }

        public final LoggingInfo getLoggingInfo() {
            return this.loggingInfo;
        }

        @Override
        public final Builder loggingInfo(LoggingInfo loggingInfo) {
            this.loggingInfo = loggingInfo;
            return this;
        }

        public final void setLoggingInfo(LoggingInfo loggingInfo) {
            this.loggingInfo = loggingInfo;
        }

        public final String getClientToken() {
            return this.clientToken;
        }

        @Override
        public final Builder clientToken(String clientToken) {
            this.clientToken = clientToken;
            return this;
        }

        public final void setClientToken(String clientToken) {
            this.clientToken = clientToken;
        }

        public RegisterTaskWithMaintenanceWindowRequest build() {
            return new RegisterTaskWithMaintenanceWindowRequest(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, RegisterTaskWithMaintenanceWindowRequest> {
        public Builder windowId(String var1);

        public Builder targets(Collection<Target> var1);

        public Builder targets(Target ... var1);

        public Builder taskArn(String var1);

        public Builder serviceRoleArn(String var1);

        public Builder taskType(String var1);

        public Builder taskType(MaintenanceWindowTaskType var1);

        public Builder taskParameters(Map<String, MaintenanceWindowTaskParameterValueExpression> var1);

        public Builder priority(Integer var1);

        public Builder maxConcurrency(String var1);

        public Builder maxErrors(String var1);

        public Builder loggingInfo(LoggingInfo var1);

        public Builder clientToken(String var1);
    }
}

