/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ssm.model;

import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import software.amazon.awssdk.annotation.SdkInternalApi;
import software.amazon.awssdk.protocol.ProtocolMarshaller;
import software.amazon.awssdk.protocol.StructuredPojo;
import software.amazon.awssdk.runtime.StandardMemberCopier;
import software.amazon.awssdk.services.ssm.model.AutomationExecutionStatus;
import software.amazon.awssdk.services.ssm.model.AutomationParameterMapCopier;
import software.amazon.awssdk.services.ssm.model.FailureDetails;
import software.amazon.awssdk.services.ssm.model.NormalStringMapCopier;
import software.amazon.awssdk.services.ssm.transform.StepExecutionMarshaller;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class StepExecution
implements StructuredPojo,
ToCopyableBuilder<Builder, StepExecution> {
    private final String stepName;
    private final String action;
    private final Date executionStartTime;
    private final Date executionEndTime;
    private final String stepStatus;
    private final String responseCode;
    private final Map<String, String> inputs;
    private final Map<String, List<String>> outputs;
    private final String response;
    private final String failureMessage;
    private final FailureDetails failureDetails;

    private StepExecution(BuilderImpl builder) {
        this.stepName = builder.stepName;
        this.action = builder.action;
        this.executionStartTime = builder.executionStartTime;
        this.executionEndTime = builder.executionEndTime;
        this.stepStatus = builder.stepStatus;
        this.responseCode = builder.responseCode;
        this.inputs = builder.inputs;
        this.outputs = builder.outputs;
        this.response = builder.response;
        this.failureMessage = builder.failureMessage;
        this.failureDetails = builder.failureDetails;
    }

    public String stepName() {
        return this.stepName;
    }

    public String action() {
        return this.action;
    }

    public Date executionStartTime() {
        return this.executionStartTime;
    }

    public Date executionEndTime() {
        return this.executionEndTime;
    }

    public String stepStatus() {
        return this.stepStatus;
    }

    public String responseCode() {
        return this.responseCode;
    }

    public Map<String, String> inputs() {
        return this.inputs;
    }

    public Map<String, List<String>> outputs() {
        return this.outputs;
    }

    public String response() {
        return this.response;
    }

    public String failureMessage() {
        return this.failureMessage;
    }

    public FailureDetails failureDetails() {
        return this.failureDetails;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.stepName() == null ? 0 : this.stepName().hashCode());
        hashCode = 31 * hashCode + (this.action() == null ? 0 : this.action().hashCode());
        hashCode = 31 * hashCode + (this.executionStartTime() == null ? 0 : this.executionStartTime().hashCode());
        hashCode = 31 * hashCode + (this.executionEndTime() == null ? 0 : this.executionEndTime().hashCode());
        hashCode = 31 * hashCode + (this.stepStatus() == null ? 0 : this.stepStatus().hashCode());
        hashCode = 31 * hashCode + (this.responseCode() == null ? 0 : this.responseCode().hashCode());
        hashCode = 31 * hashCode + (this.inputs() == null ? 0 : this.inputs().hashCode());
        hashCode = 31 * hashCode + (this.outputs() == null ? 0 : this.outputs().hashCode());
        hashCode = 31 * hashCode + (this.response() == null ? 0 : this.response().hashCode());
        hashCode = 31 * hashCode + (this.failureMessage() == null ? 0 : this.failureMessage().hashCode());
        hashCode = 31 * hashCode + (this.failureDetails() == null ? 0 : this.failureDetails().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof StepExecution)) {
            return false;
        }
        StepExecution other = (StepExecution)obj;
        if (other.stepName() == null ^ this.stepName() == null) {
            return false;
        }
        if (other.stepName() != null && !other.stepName().equals(this.stepName())) {
            return false;
        }
        if (other.action() == null ^ this.action() == null) {
            return false;
        }
        if (other.action() != null && !other.action().equals(this.action())) {
            return false;
        }
        if (other.executionStartTime() == null ^ this.executionStartTime() == null) {
            return false;
        }
        if (other.executionStartTime() != null && !other.executionStartTime().equals(this.executionStartTime())) {
            return false;
        }
        if (other.executionEndTime() == null ^ this.executionEndTime() == null) {
            return false;
        }
        if (other.executionEndTime() != null && !other.executionEndTime().equals(this.executionEndTime())) {
            return false;
        }
        if (other.stepStatus() == null ^ this.stepStatus() == null) {
            return false;
        }
        if (other.stepStatus() != null && !other.stepStatus().equals(this.stepStatus())) {
            return false;
        }
        if (other.responseCode() == null ^ this.responseCode() == null) {
            return false;
        }
        if (other.responseCode() != null && !other.responseCode().equals(this.responseCode())) {
            return false;
        }
        if (other.inputs() == null ^ this.inputs() == null) {
            return false;
        }
        if (other.inputs() != null && !other.inputs().equals(this.inputs())) {
            return false;
        }
        if (other.outputs() == null ^ this.outputs() == null) {
            return false;
        }
        if (other.outputs() != null && !other.outputs().equals(this.outputs())) {
            return false;
        }
        if (other.response() == null ^ this.response() == null) {
            return false;
        }
        if (other.response() != null && !other.response().equals(this.response())) {
            return false;
        }
        if (other.failureMessage() == null ^ this.failureMessage() == null) {
            return false;
        }
        if (other.failureMessage() != null && !other.failureMessage().equals(this.failureMessage())) {
            return false;
        }
        if (other.failureDetails() == null ^ this.failureDetails() == null) {
            return false;
        }
        return other.failureDetails() == null || other.failureDetails().equals(this.failureDetails());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.stepName() != null) {
            sb.append("StepName: ").append(this.stepName()).append(",");
        }
        if (this.action() != null) {
            sb.append("Action: ").append(this.action()).append(",");
        }
        if (this.executionStartTime() != null) {
            sb.append("ExecutionStartTime: ").append(this.executionStartTime()).append(",");
        }
        if (this.executionEndTime() != null) {
            sb.append("ExecutionEndTime: ").append(this.executionEndTime()).append(",");
        }
        if (this.stepStatus() != null) {
            sb.append("StepStatus: ").append(this.stepStatus()).append(",");
        }
        if (this.responseCode() != null) {
            sb.append("ResponseCode: ").append(this.responseCode()).append(",");
        }
        if (this.inputs() != null) {
            sb.append("Inputs: ").append(this.inputs()).append(",");
        }
        if (this.outputs() != null) {
            sb.append("Outputs: ").append(this.outputs()).append(",");
        }
        if (this.response() != null) {
            sb.append("Response: ").append(this.response()).append(",");
        }
        if (this.failureMessage() != null) {
            sb.append("FailureMessage: ").append(this.failureMessage()).append(",");
        }
        if (this.failureDetails() != null) {
            sb.append("FailureDetails: ").append(this.failureDetails()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        StepExecutionMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    private static final class BuilderImpl
    implements Builder {
        private String stepName;
        private String action;
        private Date executionStartTime;
        private Date executionEndTime;
        private String stepStatus;
        private String responseCode;
        private Map<String, String> inputs;
        private Map<String, List<String>> outputs;
        private String response;
        private String failureMessage;
        private FailureDetails failureDetails;

        private BuilderImpl() {
        }

        private BuilderImpl(StepExecution model) {
            this.setStepName(model.stepName);
            this.setAction(model.action);
            this.setExecutionStartTime(model.executionStartTime);
            this.setExecutionEndTime(model.executionEndTime);
            this.setStepStatus(model.stepStatus);
            this.setResponseCode(model.responseCode);
            this.setInputs(model.inputs);
            this.setOutputs(model.outputs);
            this.setResponse(model.response);
            this.setFailureMessage(model.failureMessage);
            this.setFailureDetails(model.failureDetails);
        }

        public final String getStepName() {
            return this.stepName;
        }

        @Override
        public final Builder stepName(String stepName) {
            this.stepName = stepName;
            return this;
        }

        public final void setStepName(String stepName) {
            this.stepName = stepName;
        }

        public final String getAction() {
            return this.action;
        }

        @Override
        public final Builder action(String action) {
            this.action = action;
            return this;
        }

        public final void setAction(String action) {
            this.action = action;
        }

        public final Date getExecutionStartTime() {
            return this.executionStartTime;
        }

        @Override
        public final Builder executionStartTime(Date executionStartTime) {
            this.executionStartTime = StandardMemberCopier.copy((Date)executionStartTime);
            return this;
        }

        public final void setExecutionStartTime(Date executionStartTime) {
            this.executionStartTime = StandardMemberCopier.copy((Date)executionStartTime);
        }

        public final Date getExecutionEndTime() {
            return this.executionEndTime;
        }

        @Override
        public final Builder executionEndTime(Date executionEndTime) {
            this.executionEndTime = StandardMemberCopier.copy((Date)executionEndTime);
            return this;
        }

        public final void setExecutionEndTime(Date executionEndTime) {
            this.executionEndTime = StandardMemberCopier.copy((Date)executionEndTime);
        }

        public final String getStepStatus() {
            return this.stepStatus;
        }

        @Override
        public final Builder stepStatus(String stepStatus) {
            this.stepStatus = stepStatus;
            return this;
        }

        @Override
        public final Builder stepStatus(AutomationExecutionStatus stepStatus) {
            this.stepStatus(stepStatus.toString());
            return this;
        }

        public final void setStepStatus(String stepStatus) {
            this.stepStatus = stepStatus;
        }

        public final void setStepStatus(AutomationExecutionStatus stepStatus) {
            this.stepStatus(stepStatus.toString());
        }

        public final String getResponseCode() {
            return this.responseCode;
        }

        @Override
        public final Builder responseCode(String responseCode) {
            this.responseCode = responseCode;
            return this;
        }

        public final void setResponseCode(String responseCode) {
            this.responseCode = responseCode;
        }

        public final Map<String, String> getInputs() {
            return this.inputs;
        }

        @Override
        public final Builder inputs(Map<String, String> inputs) {
            this.inputs = NormalStringMapCopier.copy(inputs);
            return this;
        }

        public final void setInputs(Map<String, String> inputs) {
            this.inputs = NormalStringMapCopier.copy(inputs);
        }

        public final Map<String, ? extends Collection<String>> getOutputs() {
            return this.outputs;
        }

        @Override
        public final Builder outputs(Map<String, ? extends Collection<String>> outputs) {
            this.outputs = AutomationParameterMapCopier.copy(outputs);
            return this;
        }

        public final void setOutputs(Map<String, ? extends Collection<String>> outputs) {
            this.outputs = AutomationParameterMapCopier.copy(outputs);
        }

        public final String getResponse() {
            return this.response;
        }

        @Override
        public final Builder response(String response) {
            this.response = response;
            return this;
        }

        public final void setResponse(String response) {
            this.response = response;
        }

        public final String getFailureMessage() {
            return this.failureMessage;
        }

        @Override
        public final Builder failureMessage(String failureMessage) {
            this.failureMessage = failureMessage;
            return this;
        }

        public final void setFailureMessage(String failureMessage) {
            this.failureMessage = failureMessage;
        }

        public final FailureDetails getFailureDetails() {
            return this.failureDetails;
        }

        @Override
        public final Builder failureDetails(FailureDetails failureDetails) {
            this.failureDetails = failureDetails;
            return this;
        }

        public final void setFailureDetails(FailureDetails failureDetails) {
            this.failureDetails = failureDetails;
        }

        public StepExecution build() {
            return new StepExecution(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, StepExecution> {
        public Builder stepName(String var1);

        public Builder action(String var1);

        public Builder executionStartTime(Date var1);

        public Builder executionEndTime(Date var1);

        public Builder stepStatus(String var1);

        public Builder stepStatus(AutomationExecutionStatus var1);

        public Builder responseCode(String var1);

        public Builder inputs(Map<String, String> var1);

        public Builder outputs(Map<String, ? extends Collection<String>> var1);

        public Builder response(String var1);

        public Builder failureMessage(String var1);

        public Builder failureDetails(FailureDetails var1);
    }
}

