/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ssm.transform;

import java.util.Date;
import software.amazon.awssdk.SdkClientException;
import software.amazon.awssdk.annotation.SdkInternalApi;
import software.amazon.awssdk.protocol.MarshallLocation;
import software.amazon.awssdk.protocol.MarshallingInfo;
import software.amazon.awssdk.protocol.MarshallingType;
import software.amazon.awssdk.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.ssm.model.Activation;

@SdkInternalApi
public class ActivationMarshaller {
    private static final MarshallingInfo<String> ACTIVATIONID_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ActivationId").build();
    private static final MarshallingInfo<String> DESCRIPTION_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Description").build();
    private static final MarshallingInfo<String> DEFAULTINSTANCENAME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("DefaultInstanceName").build();
    private static final MarshallingInfo<String> IAMROLE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("IamRole").build();
    private static final MarshallingInfo<Integer> REGISTRATIONLIMIT_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INTEGER).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("RegistrationLimit").build();
    private static final MarshallingInfo<Integer> REGISTRATIONSCOUNT_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INTEGER).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("RegistrationsCount").build();
    private static final MarshallingInfo<Date> EXPIRATIONDATE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.DATE).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ExpirationDate").build();
    private static final MarshallingInfo<Boolean> EXPIRED_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.BOOLEAN).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Expired").build();
    private static final MarshallingInfo<Date> CREATEDDATE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.DATE).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("CreatedDate").build();
    private static final ActivationMarshaller instance = new ActivationMarshaller();

    public static ActivationMarshaller getInstance() {
        return instance;
    }

    public void marshall(Activation activation, ProtocolMarshaller protocolMarshaller) {
        if (activation == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall((Object)activation.activationId(), ACTIVATIONID_BINDING);
            protocolMarshaller.marshall((Object)activation.description(), DESCRIPTION_BINDING);
            protocolMarshaller.marshall((Object)activation.defaultInstanceName(), DEFAULTINSTANCENAME_BINDING);
            protocolMarshaller.marshall((Object)activation.iamRole(), IAMROLE_BINDING);
            protocolMarshaller.marshall((Object)activation.registrationLimit(), REGISTRATIONLIMIT_BINDING);
            protocolMarshaller.marshall((Object)activation.registrationsCount(), REGISTRATIONSCOUNT_BINDING);
            protocolMarshaller.marshall((Object)activation.expirationDate(), EXPIRATIONDATE_BINDING);
            protocolMarshaller.marshall((Object)activation.expired(), EXPIRED_BINDING);
            protocolMarshaller.marshall((Object)activation.createdDate(), CREATEDDATE_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

