/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ssm.transform;

import com.fasterxml.jackson.core.JsonToken;
import software.amazon.awssdk.runtime.transform.JsonUnmarshallerContext;
import software.amazon.awssdk.runtime.transform.Unmarshaller;
import software.amazon.awssdk.services.ssm.model.S3OutputLocation;

public class S3OutputLocationUnmarshaller
implements Unmarshaller<S3OutputLocation, JsonUnmarshallerContext> {
    private static S3OutputLocationUnmarshaller INSTANCE;

    public S3OutputLocation unmarshall(JsonUnmarshallerContext context) throws Exception {
        S3OutputLocation.Builder s3OutputLocationBuilder = S3OutputLocation.builder();
        int originalDepth = context.getCurrentDepth();
        String currentParentElement = context.getCurrentParentElement();
        int targetDepth = originalDepth + 1;
        JsonToken token = context.getCurrentToken();
        if (token == null) {
            token = context.nextToken();
        }
        if (token == JsonToken.VALUE_NULL) {
            return null;
        }
        while (token != null) {
            if (token == JsonToken.FIELD_NAME || token == JsonToken.START_OBJECT) {
                if (context.testExpression("OutputS3Region", targetDepth)) {
                    context.nextToken();
                    s3OutputLocationBuilder.outputS3Region((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
                if (context.testExpression("OutputS3BucketName", targetDepth)) {
                    context.nextToken();
                    s3OutputLocationBuilder.outputS3BucketName((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
                if (context.testExpression("OutputS3KeyPrefix", targetDepth)) {
                    context.nextToken();
                    s3OutputLocationBuilder.outputS3KeyPrefix((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
            } else if (!(token != JsonToken.END_ARRAY && token != JsonToken.END_OBJECT || context.getLastParsedParentElement() != null && !context.getLastParsedParentElement().equals(currentParentElement) || context.getCurrentDepth() > originalDepth)) break;
            token = context.nextToken();
        }
        return (S3OutputLocation)s3OutputLocationBuilder.build();
    }

    public static S3OutputLocationUnmarshaller getInstance() {
        if (INSTANCE == null) {
            INSTANCE = new S3OutputLocationUnmarshaller();
        }
        return INSTANCE;
    }
}

