/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ssm.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Generated;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.ssm.transform.DescribeActivationsFilterMarshaller;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Filter for the DescribeActivation API.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class DescribeActivationsFilter implements StructuredPojo,
        ToCopyableBuilder<DescribeActivationsFilter.Builder, DescribeActivationsFilter> {
    private final String filterKey;

    private final List<String> filterValues;

    private DescribeActivationsFilter(BuilderImpl builder) {
        this.filterKey = builder.filterKey;
        this.filterValues = builder.filterValues;
    }

    /**
     * <p>
     * The name of the filter.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #filterKey} will
     * return {@link DescribeActivationsFilterKeys#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #filterKeyAsString}.
     * </p>
     * 
     * @return The name of the filter.
     * @see DescribeActivationsFilterKeys
     */
    public DescribeActivationsFilterKeys filterKey() {
        return DescribeActivationsFilterKeys.fromValue(filterKey);
    }

    /**
     * <p>
     * The name of the filter.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #filterKey} will
     * return {@link DescribeActivationsFilterKeys#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #filterKeyAsString}.
     * </p>
     * 
     * @return The name of the filter.
     * @see DescribeActivationsFilterKeys
     */
    public String filterKeyAsString() {
        return filterKey;
    }

    /**
     * <p>
     * The filter values.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return The filter values.
     */
    public List<String> filterValues() {
        return filterValues;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(filterKeyAsString());
        hashCode = 31 * hashCode + Objects.hashCode(filterValues());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeActivationsFilter)) {
            return false;
        }
        DescribeActivationsFilter other = (DescribeActivationsFilter) obj;
        return Objects.equals(filterKeyAsString(), other.filterKeyAsString())
                && Objects.equals(filterValues(), other.filterValues());
    }

    @Override
    public String toString() {
        return ToString.builder("DescribeActivationsFilter").add("FilterKey", filterKeyAsString())
                .add("FilterValues", filterValues()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "FilterKey":
            return Optional.of(clazz.cast(filterKeyAsString()));
        case "FilterValues":
            return Optional.of(clazz.cast(filterValues()));
        default:
            return Optional.empty();
        }
    }

    @SdkInternalApi
    @Override
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        DescribeActivationsFilterMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    public interface Builder extends CopyableBuilder<Builder, DescribeActivationsFilter> {
        /**
         * <p>
         * The name of the filter.
         * </p>
         * 
         * @param filterKey
         *        The name of the filter.
         * @see DescribeActivationsFilterKeys
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see DescribeActivationsFilterKeys
         */
        Builder filterKey(String filterKey);

        /**
         * <p>
         * The name of the filter.
         * </p>
         * 
         * @param filterKey
         *        The name of the filter.
         * @see DescribeActivationsFilterKeys
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see DescribeActivationsFilterKeys
         */
        Builder filterKey(DescribeActivationsFilterKeys filterKey);

        /**
         * <p>
         * The filter values.
         * </p>
         * 
         * @param filterValues
         *        The filter values.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder filterValues(Collection<String> filterValues);

        /**
         * <p>
         * The filter values.
         * </p>
         * 
         * @param filterValues
         *        The filter values.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder filterValues(String... filterValues);
    }

    static final class BuilderImpl implements Builder {
        private String filterKey;

        private List<String> filterValues;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeActivationsFilter model) {
            filterKey(model.filterKey);
            filterValues(model.filterValues);
        }

        public final String getFilterKey() {
            return filterKey;
        }

        @Override
        public final Builder filterKey(String filterKey) {
            this.filterKey = filterKey;
            return this;
        }

        @Override
        public final Builder filterKey(DescribeActivationsFilterKeys filterKey) {
            this.filterKey(filterKey.toString());
            return this;
        }

        public final void setFilterKey(String filterKey) {
            this.filterKey = filterKey;
        }

        public final Collection<String> getFilterValues() {
            return filterValues;
        }

        @Override
        public final Builder filterValues(Collection<String> filterValues) {
            this.filterValues = StringListCopier.copy(filterValues);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder filterValues(String... filterValues) {
            filterValues(Arrays.asList(filterValues));
            return this;
        }

        public final void setFilterValues(Collection<String> filterValues) {
            this.filterValues = StringListCopier.copy(filterValues);
        }

        @Override
        public DescribeActivationsFilter build() {
            return new DescribeActivationsFilter(this);
        }
    }
}
