/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ssm.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfig;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public class DescribePatchGroupsRequest extends SSMRequest implements
        ToCopyableBuilder<DescribePatchGroupsRequest.Builder, DescribePatchGroupsRequest> {
    private final Integer maxResults;

    private final List<PatchOrchestratorFilter> filters;

    private final String nextToken;

    private DescribePatchGroupsRequest(BuilderImpl builder) {
        super(builder);
        this.maxResults = builder.maxResults;
        this.filters = builder.filters;
        this.nextToken = builder.nextToken;
    }

    /**
     * <p>
     * The maximum number of patch groups to return (per page).
     * </p>
     * 
     * @return The maximum number of patch groups to return (per page).
     */
    public Integer maxResults() {
        return maxResults;
    }

    /**
     * <p>
     * One or more filters. Use a filter to return a more specific list of results.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return One or more filters. Use a filter to return a more specific list of results.
     */
    public List<PatchOrchestratorFilter> filters() {
        return filters;
    }

    /**
     * <p>
     * The token for the next set of items to return. (You received this token from a previous call.)
     * </p>
     * 
     * @return The token for the next set of items to return. (You received this token from a previous call.)
     */
    public String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(maxResults());
        hashCode = 31 * hashCode + Objects.hashCode(filters());
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribePatchGroupsRequest)) {
            return false;
        }
        DescribePatchGroupsRequest other = (DescribePatchGroupsRequest) obj;
        return Objects.equals(maxResults(), other.maxResults()) && Objects.equals(filters(), other.filters())
                && Objects.equals(nextToken(), other.nextToken());
    }

    @Override
    public String toString() {
        return ToString.builder("DescribePatchGroupsRequest").add("MaxResults", maxResults()).add("Filters", filters())
                .add("NextToken", nextToken()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "MaxResults":
            return Optional.of(clazz.cast(maxResults()));
        case "Filters":
            return Optional.of(clazz.cast(filters()));
        case "NextToken":
            return Optional.of(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends SSMRequest.Builder, CopyableBuilder<Builder, DescribePatchGroupsRequest> {
        /**
         * <p>
         * The maximum number of patch groups to return (per page).
         * </p>
         * 
         * @param maxResults
         *        The maximum number of patch groups to return (per page).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maxResults(Integer maxResults);

        /**
         * <p>
         * One or more filters. Use a filter to return a more specific list of results.
         * </p>
         * 
         * @param filters
         *        One or more filters. Use a filter to return a more specific list of results.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder filters(Collection<PatchOrchestratorFilter> filters);

        /**
         * <p>
         * One or more filters. Use a filter to return a more specific list of results.
         * </p>
         * 
         * @param filters
         *        One or more filters. Use a filter to return a more specific list of results.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder filters(PatchOrchestratorFilter... filters);

        /**
         * <p>
         * One or more filters. Use a filter to return a more specific list of results.
         * </p>
         * This is a convenience that creates an instance of the {@link List<PatchOrchestratorFilter>.Builder} avoiding
         * the need to create one manually via {@link List<PatchOrchestratorFilter>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<PatchOrchestratorFilter>.Builder#build()} is called
         * immediately and its result is passed to {@link #filters(List<PatchOrchestratorFilter>)}.
         * 
         * @param filters
         *        a consumer that will call methods on {@link List<PatchOrchestratorFilter>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #filters(List<PatchOrchestratorFilter>)
         */
        Builder filters(Consumer<PatchOrchestratorFilter.Builder>... filters);

        /**
         * <p>
         * The token for the next set of items to return. (You received this token from a previous call.)
         * </p>
         * 
         * @param nextToken
         *        The token for the next set of items to return. (You received this token from a previous call.)
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);

        @Override
        Builder requestOverrideConfig(AwsRequestOverrideConfig awsRequestOverrideConfig);

        @Override
        Builder requestOverrideConfig(Consumer<AwsRequestOverrideConfig.Builder> builderConsumer);
    }

    static final class BuilderImpl extends SSMRequest.BuilderImpl implements Builder {
        private Integer maxResults;

        private List<PatchOrchestratorFilter> filters;

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribePatchGroupsRequest model) {
            super(model);
            maxResults(model.maxResults);
            filters(model.filters);
            nextToken(model.nextToken);
        }

        public final Integer getMaxResults() {
            return maxResults;
        }

        @Override
        public final Builder maxResults(Integer maxResults) {
            this.maxResults = maxResults;
            return this;
        }

        public final void setMaxResults(Integer maxResults) {
            this.maxResults = maxResults;
        }

        public final Collection<PatchOrchestratorFilter.Builder> getFilters() {
            return filters != null ? filters.stream().map(PatchOrchestratorFilter::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder filters(Collection<PatchOrchestratorFilter> filters) {
            this.filters = PatchOrchestratorFilterListCopier.copy(filters);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder filters(PatchOrchestratorFilter... filters) {
            filters(Arrays.asList(filters));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder filters(Consumer<PatchOrchestratorFilter.Builder>... filters) {
            filters(Stream.of(filters).map(c -> PatchOrchestratorFilter.builder().apply(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setFilters(Collection<PatchOrchestratorFilter.BuilderImpl> filters) {
            this.filters = PatchOrchestratorFilterListCopier.copyFromBuilder(filters);
        }

        public final String getNextToken() {
            return nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public Builder requestOverrideConfig(AwsRequestOverrideConfig awsRequestOverrideConfig) {
            super.requestOverrideConfig(awsRequestOverrideConfig);
            return this;
        }

        @Override
        public Builder requestOverrideConfig(Consumer<AwsRequestOverrideConfig.Builder> builderConsumer) {
            super.requestOverrideConfig(builderConsumer);
            return this;
        }

        @Override
        public DescribePatchGroupsRequest build() {
            return new DescribePatchGroupsRequest(this);
        }
    }
}
