/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ssm.model;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import javax.annotation.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfig;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public class GetMaintenanceWindowTaskRequest extends SSMRequest implements
        ToCopyableBuilder<GetMaintenanceWindowTaskRequest.Builder, GetMaintenanceWindowTaskRequest> {
    private final String windowId;

    private final String windowTaskId;

    private GetMaintenanceWindowTaskRequest(BuilderImpl builder) {
        super(builder);
        this.windowId = builder.windowId;
        this.windowTaskId = builder.windowTaskId;
    }

    /**
     * <p>
     * The Maintenance Window ID that includes the task to retrieve.
     * </p>
     * 
     * @return The Maintenance Window ID that includes the task to retrieve.
     */
    public String windowId() {
        return windowId;
    }

    /**
     * <p>
     * The Maintenance Window task ID to retrieve.
     * </p>
     * 
     * @return The Maintenance Window task ID to retrieve.
     */
    public String windowTaskId() {
        return windowTaskId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(windowId());
        hashCode = 31 * hashCode + Objects.hashCode(windowTaskId());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetMaintenanceWindowTaskRequest)) {
            return false;
        }
        GetMaintenanceWindowTaskRequest other = (GetMaintenanceWindowTaskRequest) obj;
        return Objects.equals(windowId(), other.windowId()) && Objects.equals(windowTaskId(), other.windowTaskId());
    }

    @Override
    public String toString() {
        return ToString.builder("GetMaintenanceWindowTaskRequest").add("WindowId", windowId())
                .add("WindowTaskId", windowTaskId()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "WindowId":
            return Optional.of(clazz.cast(windowId()));
        case "WindowTaskId":
            return Optional.of(clazz.cast(windowTaskId()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends SSMRequest.Builder, CopyableBuilder<Builder, GetMaintenanceWindowTaskRequest> {
        /**
         * <p>
         * The Maintenance Window ID that includes the task to retrieve.
         * </p>
         * 
         * @param windowId
         *        The Maintenance Window ID that includes the task to retrieve.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder windowId(String windowId);

        /**
         * <p>
         * The Maintenance Window task ID to retrieve.
         * </p>
         * 
         * @param windowTaskId
         *        The Maintenance Window task ID to retrieve.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder windowTaskId(String windowTaskId);

        @Override
        Builder requestOverrideConfig(AwsRequestOverrideConfig awsRequestOverrideConfig);

        @Override
        Builder requestOverrideConfig(Consumer<AwsRequestOverrideConfig.Builder> builderConsumer);
    }

    static final class BuilderImpl extends SSMRequest.BuilderImpl implements Builder {
        private String windowId;

        private String windowTaskId;

        private BuilderImpl() {
        }

        private BuilderImpl(GetMaintenanceWindowTaskRequest model) {
            super(model);
            windowId(model.windowId);
            windowTaskId(model.windowTaskId);
        }

        public final String getWindowId() {
            return windowId;
        }

        @Override
        public final Builder windowId(String windowId) {
            this.windowId = windowId;
            return this;
        }

        public final void setWindowId(String windowId) {
            this.windowId = windowId;
        }

        public final String getWindowTaskId() {
            return windowTaskId;
        }

        @Override
        public final Builder windowTaskId(String windowTaskId) {
            this.windowTaskId = windowTaskId;
            return this;
        }

        public final void setWindowTaskId(String windowTaskId) {
            this.windowTaskId = windowTaskId;
        }

        @Override
        public Builder requestOverrideConfig(AwsRequestOverrideConfig awsRequestOverrideConfig) {
            super.requestOverrideConfig(awsRequestOverrideConfig);
            return this;
        }

        @Override
        public Builder requestOverrideConfig(Consumer<AwsRequestOverrideConfig.Builder> builderConsumer) {
            super.requestOverrideConfig(builderConsumer);
            return this;
        }

        @Override
        public GetMaintenanceWindowTaskRequest build() {
            return new GetMaintenanceWindowTaskRequest(this);
        }
    }
}
