/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ssm.model;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import javax.annotation.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfig;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public class GetParameterRequest extends SSMRequest implements
        ToCopyableBuilder<GetParameterRequest.Builder, GetParameterRequest> {
    private final String name;

    private final Boolean withDecryption;

    private GetParameterRequest(BuilderImpl builder) {
        super(builder);
        this.name = builder.name;
        this.withDecryption = builder.withDecryption;
    }

    /**
     * <p>
     * The name of the parameter you want to query.
     * </p>
     * 
     * @return The name of the parameter you want to query.
     */
    public String name() {
        return name;
    }

    /**
     * <p>
     * Return decrypted values for secure string parameters. This flag is ignored for String and StringList parameter
     * types.
     * </p>
     * 
     * @return Return decrypted values for secure string parameters. This flag is ignored for String and StringList
     *         parameter types.
     */
    public Boolean withDecryption() {
        return withDecryption;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(withDecryption());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetParameterRequest)) {
            return false;
        }
        GetParameterRequest other = (GetParameterRequest) obj;
        return Objects.equals(name(), other.name()) && Objects.equals(withDecryption(), other.withDecryption());
    }

    @Override
    public String toString() {
        return ToString.builder("GetParameterRequest").add("Name", name()).add("WithDecryption", withDecryption()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Name":
            return Optional.of(clazz.cast(name()));
        case "WithDecryption":
            return Optional.of(clazz.cast(withDecryption()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends SSMRequest.Builder, CopyableBuilder<Builder, GetParameterRequest> {
        /**
         * <p>
         * The name of the parameter you want to query.
         * </p>
         * 
         * @param name
         *        The name of the parameter you want to query.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * Return decrypted values for secure string parameters. This flag is ignored for String and StringList
         * parameter types.
         * </p>
         * 
         * @param withDecryption
         *        Return decrypted values for secure string parameters. This flag is ignored for String and StringList
         *        parameter types.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder withDecryption(Boolean withDecryption);

        @Override
        Builder requestOverrideConfig(AwsRequestOverrideConfig awsRequestOverrideConfig);

        @Override
        Builder requestOverrideConfig(Consumer<AwsRequestOverrideConfig.Builder> builderConsumer);
    }

    static final class BuilderImpl extends SSMRequest.BuilderImpl implements Builder {
        private String name;

        private Boolean withDecryption;

        private BuilderImpl() {
        }

        private BuilderImpl(GetParameterRequest model) {
            super(model);
            name(model.name);
            withDecryption(model.withDecryption);
        }

        public final String getName() {
            return name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final void setName(String name) {
            this.name = name;
        }

        public final Boolean getWithDecryption() {
            return withDecryption;
        }

        @Override
        public final Builder withDecryption(Boolean withDecryption) {
            this.withDecryption = withDecryption;
            return this;
        }

        public final void setWithDecryption(Boolean withDecryption) {
            this.withDecryption = withDecryption;
        }

        @Override
        public Builder requestOverrideConfig(AwsRequestOverrideConfig awsRequestOverrideConfig) {
            super.requestOverrideConfig(awsRequestOverrideConfig);
            return this;
        }

        @Override
        public Builder requestOverrideConfig(Consumer<AwsRequestOverrideConfig.Builder> builderConsumer) {
            super.requestOverrideConfig(builderConsumer);
            return this;
        }

        @Override
        public GetParameterRequest build() {
            return new GetParameterRequest(this);
        }
    }
}
