/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ssm.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Generated;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.ssm.transform.InventoryFilterMarshaller;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * One or more filters. Use a filter to return a more specific list of results.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class InventoryFilter implements StructuredPojo, ToCopyableBuilder<InventoryFilter.Builder, InventoryFilter> {
    private final String key;

    private final List<String> values;

    private final String type;

    private InventoryFilter(BuilderImpl builder) {
        this.key = builder.key;
        this.values = builder.values;
        this.type = builder.type;
    }

    /**
     * <p>
     * The name of the filter key.
     * </p>
     * 
     * @return The name of the filter key.
     */
    public String key() {
        return key;
    }

    /**
     * <p>
     * Inventory filter values. Example: inventory filter where instance IDs are specified as values
     * Key=AWS:InstanceInformation.InstanceId,Values= i-a12b3c4d5e6g, i-1a2b3c4d5e6,Type=Equal
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return Inventory filter values. Example: inventory filter where instance IDs are specified as values
     *         Key=AWS:InstanceInformation.InstanceId,Values= i-a12b3c4d5e6g, i-1a2b3c4d5e6,Type=Equal
     */
    public List<String> values() {
        return values;
    }

    /**
     * <p>
     * The type of filter. Valid values include the following: "Equal"|"NotEqual"|"BeginWith"|"LessThan"|"GreaterThan"
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #type} will return
     * {@link InventoryQueryOperatorType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #typeAsString}.
     * </p>
     * 
     * @return The type of filter. Valid values include the following:
     *         "Equal"|"NotEqual"|"BeginWith"|"LessThan"|"GreaterThan"
     * @see InventoryQueryOperatorType
     */
    public InventoryQueryOperatorType type() {
        return InventoryQueryOperatorType.fromValue(type);
    }

    /**
     * <p>
     * The type of filter. Valid values include the following: "Equal"|"NotEqual"|"BeginWith"|"LessThan"|"GreaterThan"
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #type} will return
     * {@link InventoryQueryOperatorType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #typeAsString}.
     * </p>
     * 
     * @return The type of filter. Valid values include the following:
     *         "Equal"|"NotEqual"|"BeginWith"|"LessThan"|"GreaterThan"
     * @see InventoryQueryOperatorType
     */
    public String typeAsString() {
        return type;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(key());
        hashCode = 31 * hashCode + Objects.hashCode(values());
        hashCode = 31 * hashCode + Objects.hashCode(typeAsString());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof InventoryFilter)) {
            return false;
        }
        InventoryFilter other = (InventoryFilter) obj;
        return Objects.equals(key(), other.key()) && Objects.equals(values(), other.values())
                && Objects.equals(typeAsString(), other.typeAsString());
    }

    @Override
    public String toString() {
        return ToString.builder("InventoryFilter").add("Key", key()).add("Values", values()).add("Type", typeAsString()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Key":
            return Optional.of(clazz.cast(key()));
        case "Values":
            return Optional.of(clazz.cast(values()));
        case "Type":
            return Optional.of(clazz.cast(typeAsString()));
        default:
            return Optional.empty();
        }
    }

    @SdkInternalApi
    @Override
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        InventoryFilterMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    public interface Builder extends CopyableBuilder<Builder, InventoryFilter> {
        /**
         * <p>
         * The name of the filter key.
         * </p>
         * 
         * @param key
         *        The name of the filter key.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder key(String key);

        /**
         * <p>
         * Inventory filter values. Example: inventory filter where instance IDs are specified as values
         * Key=AWS:InstanceInformation.InstanceId,Values= i-a12b3c4d5e6g, i-1a2b3c4d5e6,Type=Equal
         * </p>
         * 
         * @param values
         *        Inventory filter values. Example: inventory filter where instance IDs are specified as values
         *        Key=AWS:InstanceInformation.InstanceId,Values= i-a12b3c4d5e6g, i-1a2b3c4d5e6,Type=Equal
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder values(Collection<String> values);

        /**
         * <p>
         * Inventory filter values. Example: inventory filter where instance IDs are specified as values
         * Key=AWS:InstanceInformation.InstanceId,Values= i-a12b3c4d5e6g, i-1a2b3c4d5e6,Type=Equal
         * </p>
         * 
         * @param values
         *        Inventory filter values. Example: inventory filter where instance IDs are specified as values
         *        Key=AWS:InstanceInformation.InstanceId,Values= i-a12b3c4d5e6g, i-1a2b3c4d5e6,Type=Equal
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder values(String... values);

        /**
         * <p>
         * The type of filter. Valid values include the following:
         * "Equal"|"NotEqual"|"BeginWith"|"LessThan"|"GreaterThan"
         * </p>
         * 
         * @param type
         *        The type of filter. Valid values include the following:
         *        "Equal"|"NotEqual"|"BeginWith"|"LessThan"|"GreaterThan"
         * @see InventoryQueryOperatorType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see InventoryQueryOperatorType
         */
        Builder type(String type);

        /**
         * <p>
         * The type of filter. Valid values include the following:
         * "Equal"|"NotEqual"|"BeginWith"|"LessThan"|"GreaterThan"
         * </p>
         * 
         * @param type
         *        The type of filter. Valid values include the following:
         *        "Equal"|"NotEqual"|"BeginWith"|"LessThan"|"GreaterThan"
         * @see InventoryQueryOperatorType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see InventoryQueryOperatorType
         */
        Builder type(InventoryQueryOperatorType type);
    }

    static final class BuilderImpl implements Builder {
        private String key;

        private List<String> values;

        private String type;

        private BuilderImpl() {
        }

        private BuilderImpl(InventoryFilter model) {
            key(model.key);
            values(model.values);
            type(model.type);
        }

        public final String getKey() {
            return key;
        }

        @Override
        public final Builder key(String key) {
            this.key = key;
            return this;
        }

        public final void setKey(String key) {
            this.key = key;
        }

        public final Collection<String> getValues() {
            return values;
        }

        @Override
        public final Builder values(Collection<String> values) {
            this.values = InventoryFilterValueListCopier.copy(values);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder values(String... values) {
            values(Arrays.asList(values));
            return this;
        }

        public final void setValues(Collection<String> values) {
            this.values = InventoryFilterValueListCopier.copy(values);
        }

        public final String getType() {
            return type;
        }

        @Override
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        @Override
        public final Builder type(InventoryQueryOperatorType type) {
            this.type(type.toString());
            return this;
        }

        public final void setType(String type) {
            this.type = type;
        }

        @Override
        public InventoryFilter build() {
            return new InventoryFilter(this);
        }
    }
}
