/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ssm.model;

import java.util.Objects;
import java.util.Optional;
import javax.annotation.Generated;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.ssm.transform.InventoryItemAttributeMarshaller;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Attributes are the entries within the inventory item content. It contains name and value.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class InventoryItemAttribute implements StructuredPojo,
        ToCopyableBuilder<InventoryItemAttribute.Builder, InventoryItemAttribute> {
    private final String name;

    private final String dataType;

    private InventoryItemAttribute(BuilderImpl builder) {
        this.name = builder.name;
        this.dataType = builder.dataType;
    }

    /**
     * <p>
     * Name of the inventory item attribute.
     * </p>
     * 
     * @return Name of the inventory item attribute.
     */
    public String name() {
        return name;
    }

    /**
     * <p>
     * The data type of the inventory item attribute.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #dataType} will
     * return {@link InventoryAttributeDataType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #dataTypeAsString}.
     * </p>
     * 
     * @return The data type of the inventory item attribute.
     * @see InventoryAttributeDataType
     */
    public InventoryAttributeDataType dataType() {
        return InventoryAttributeDataType.fromValue(dataType);
    }

    /**
     * <p>
     * The data type of the inventory item attribute.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #dataType} will
     * return {@link InventoryAttributeDataType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #dataTypeAsString}.
     * </p>
     * 
     * @return The data type of the inventory item attribute.
     * @see InventoryAttributeDataType
     */
    public String dataTypeAsString() {
        return dataType;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(dataTypeAsString());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof InventoryItemAttribute)) {
            return false;
        }
        InventoryItemAttribute other = (InventoryItemAttribute) obj;
        return Objects.equals(name(), other.name()) && Objects.equals(dataTypeAsString(), other.dataTypeAsString());
    }

    @Override
    public String toString() {
        return ToString.builder("InventoryItemAttribute").add("Name", name()).add("DataType", dataTypeAsString()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Name":
            return Optional.of(clazz.cast(name()));
        case "DataType":
            return Optional.of(clazz.cast(dataTypeAsString()));
        default:
            return Optional.empty();
        }
    }

    @SdkInternalApi
    @Override
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        InventoryItemAttributeMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    public interface Builder extends CopyableBuilder<Builder, InventoryItemAttribute> {
        /**
         * <p>
         * Name of the inventory item attribute.
         * </p>
         * 
         * @param name
         *        Name of the inventory item attribute.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * The data type of the inventory item attribute.
         * </p>
         * 
         * @param dataType
         *        The data type of the inventory item attribute.
         * @see InventoryAttributeDataType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see InventoryAttributeDataType
         */
        Builder dataType(String dataType);

        /**
         * <p>
         * The data type of the inventory item attribute.
         * </p>
         * 
         * @param dataType
         *        The data type of the inventory item attribute.
         * @see InventoryAttributeDataType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see InventoryAttributeDataType
         */
        Builder dataType(InventoryAttributeDataType dataType);
    }

    static final class BuilderImpl implements Builder {
        private String name;

        private String dataType;

        private BuilderImpl() {
        }

        private BuilderImpl(InventoryItemAttribute model) {
            name(model.name);
            dataType(model.dataType);
        }

        public final String getName() {
            return name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final void setName(String name) {
            this.name = name;
        }

        public final String getDataType() {
            return dataType;
        }

        @Override
        public final Builder dataType(String dataType) {
            this.dataType = dataType;
            return this;
        }

        @Override
        public final Builder dataType(InventoryAttributeDataType dataType) {
            this.dataType(dataType.toString());
            return this;
        }

        public final void setDataType(String dataType) {
            this.dataType = dataType;
        }

        @Override
        public InventoryItemAttribute build() {
            return new InventoryItemAttribute(this);
        }
    }
}
