/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ssm.model;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import javax.annotation.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfig;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public class ListTagsForResourceRequest extends SSMRequest implements
        ToCopyableBuilder<ListTagsForResourceRequest.Builder, ListTagsForResourceRequest> {
    private final String resourceType;

    private final String resourceId;

    private ListTagsForResourceRequest(BuilderImpl builder) {
        super(builder);
        this.resourceType = builder.resourceType;
        this.resourceId = builder.resourceId;
    }

    /**
     * <p>
     * Returns a list of tags for a specific resource type.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #resourceType} will
     * return {@link ResourceTypeForTagging#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #resourceTypeAsString}.
     * </p>
     * 
     * @return Returns a list of tags for a specific resource type.
     * @see ResourceTypeForTagging
     */
    public ResourceTypeForTagging resourceType() {
        return ResourceTypeForTagging.fromValue(resourceType);
    }

    /**
     * <p>
     * Returns a list of tags for a specific resource type.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #resourceType} will
     * return {@link ResourceTypeForTagging#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #resourceTypeAsString}.
     * </p>
     * 
     * @return Returns a list of tags for a specific resource type.
     * @see ResourceTypeForTagging
     */
    public String resourceTypeAsString() {
        return resourceType;
    }

    /**
     * <p>
     * The resource ID for which you want to see a list of tags.
     * </p>
     * 
     * @return The resource ID for which you want to see a list of tags.
     */
    public String resourceId() {
        return resourceId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(resourceTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(resourceId());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListTagsForResourceRequest)) {
            return false;
        }
        ListTagsForResourceRequest other = (ListTagsForResourceRequest) obj;
        return Objects.equals(resourceTypeAsString(), other.resourceTypeAsString())
                && Objects.equals(resourceId(), other.resourceId());
    }

    @Override
    public String toString() {
        return ToString.builder("ListTagsForResourceRequest").add("ResourceType", resourceTypeAsString())
                .add("ResourceId", resourceId()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ResourceType":
            return Optional.of(clazz.cast(resourceTypeAsString()));
        case "ResourceId":
            return Optional.of(clazz.cast(resourceId()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends SSMRequest.Builder, CopyableBuilder<Builder, ListTagsForResourceRequest> {
        /**
         * <p>
         * Returns a list of tags for a specific resource type.
         * </p>
         * 
         * @param resourceType
         *        Returns a list of tags for a specific resource type.
         * @see ResourceTypeForTagging
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ResourceTypeForTagging
         */
        Builder resourceType(String resourceType);

        /**
         * <p>
         * Returns a list of tags for a specific resource type.
         * </p>
         * 
         * @param resourceType
         *        Returns a list of tags for a specific resource type.
         * @see ResourceTypeForTagging
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ResourceTypeForTagging
         */
        Builder resourceType(ResourceTypeForTagging resourceType);

        /**
         * <p>
         * The resource ID for which you want to see a list of tags.
         * </p>
         * 
         * @param resourceId
         *        The resource ID for which you want to see a list of tags.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resourceId(String resourceId);

        @Override
        Builder requestOverrideConfig(AwsRequestOverrideConfig awsRequestOverrideConfig);

        @Override
        Builder requestOverrideConfig(Consumer<AwsRequestOverrideConfig.Builder> builderConsumer);
    }

    static final class BuilderImpl extends SSMRequest.BuilderImpl implements Builder {
        private String resourceType;

        private String resourceId;

        private BuilderImpl() {
        }

        private BuilderImpl(ListTagsForResourceRequest model) {
            super(model);
            resourceType(model.resourceType);
            resourceId(model.resourceId);
        }

        public final String getResourceType() {
            return resourceType;
        }

        @Override
        public final Builder resourceType(String resourceType) {
            this.resourceType = resourceType;
            return this;
        }

        @Override
        public final Builder resourceType(ResourceTypeForTagging resourceType) {
            this.resourceType(resourceType.toString());
            return this;
        }

        public final void setResourceType(String resourceType) {
            this.resourceType = resourceType;
        }

        public final String getResourceId() {
            return resourceId;
        }

        @Override
        public final Builder resourceId(String resourceId) {
            this.resourceId = resourceId;
            return this;
        }

        public final void setResourceId(String resourceId) {
            this.resourceId = resourceId;
        }

        @Override
        public Builder requestOverrideConfig(AwsRequestOverrideConfig awsRequestOverrideConfig) {
            super.requestOverrideConfig(awsRequestOverrideConfig);
            return this;
        }

        @Override
        public Builder requestOverrideConfig(Consumer<AwsRequestOverrideConfig.Builder> builderConsumer) {
            super.requestOverrideConfig(builderConsumer);
            return this;
        }

        @Override
        public ListTagsForResourceRequest build() {
            return new ListTagsForResourceRequest(this);
        }
    }
}
