/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ssm.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Generated;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.ssm.transform.ParametersFilterMarshaller;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * One or more filters. Use a filter to return a more specific list of results.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class ParametersFilter implements StructuredPojo, ToCopyableBuilder<ParametersFilter.Builder, ParametersFilter> {
    private final String key;

    private final List<String> values;

    private ParametersFilter(BuilderImpl builder) {
        this.key = builder.key;
        this.values = builder.values;
    }

    /**
     * <p>
     * The name of the filter.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #key} will return
     * {@link ParametersFilterKey#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #keyAsString}.
     * </p>
     * 
     * @return The name of the filter.
     * @see ParametersFilterKey
     */
    public ParametersFilterKey key() {
        return ParametersFilterKey.fromValue(key);
    }

    /**
     * <p>
     * The name of the filter.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #key} will return
     * {@link ParametersFilterKey#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #keyAsString}.
     * </p>
     * 
     * @return The name of the filter.
     * @see ParametersFilterKey
     */
    public String keyAsString() {
        return key;
    }

    /**
     * <p>
     * The filter values.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return The filter values.
     */
    public List<String> values() {
        return values;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(keyAsString());
        hashCode = 31 * hashCode + Objects.hashCode(values());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ParametersFilter)) {
            return false;
        }
        ParametersFilter other = (ParametersFilter) obj;
        return Objects.equals(keyAsString(), other.keyAsString()) && Objects.equals(values(), other.values());
    }

    @Override
    public String toString() {
        return ToString.builder("ParametersFilter").add("Key", keyAsString()).add("Values", values()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Key":
            return Optional.of(clazz.cast(keyAsString()));
        case "Values":
            return Optional.of(clazz.cast(values()));
        default:
            return Optional.empty();
        }
    }

    @SdkInternalApi
    @Override
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        ParametersFilterMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    public interface Builder extends CopyableBuilder<Builder, ParametersFilter> {
        /**
         * <p>
         * The name of the filter.
         * </p>
         * 
         * @param key
         *        The name of the filter.
         * @see ParametersFilterKey
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ParametersFilterKey
         */
        Builder key(String key);

        /**
         * <p>
         * The name of the filter.
         * </p>
         * 
         * @param key
         *        The name of the filter.
         * @see ParametersFilterKey
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ParametersFilterKey
         */
        Builder key(ParametersFilterKey key);

        /**
         * <p>
         * The filter values.
         * </p>
         * 
         * @param values
         *        The filter values.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder values(Collection<String> values);

        /**
         * <p>
         * The filter values.
         * </p>
         * 
         * @param values
         *        The filter values.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder values(String... values);
    }

    static final class BuilderImpl implements Builder {
        private String key;

        private List<String> values;

        private BuilderImpl() {
        }

        private BuilderImpl(ParametersFilter model) {
            key(model.key);
            values(model.values);
        }

        public final String getKey() {
            return key;
        }

        @Override
        public final Builder key(String key) {
            this.key = key;
            return this;
        }

        @Override
        public final Builder key(ParametersFilterKey key) {
            this.key(key.toString());
            return this;
        }

        public final void setKey(String key) {
            this.key = key;
        }

        public final Collection<String> getValues() {
            return values;
        }

        @Override
        public final Builder values(Collection<String> values) {
            this.values = ParametersFilterValueListCopier.copy(values);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder values(String... values) {
            values(Arrays.asList(values));
            return this;
        }

        public final void setValues(Collection<String> values) {
            this.values = ParametersFilterValueListCopier.copy(values);
        }

        @Override
        public ParametersFilter build() {
            return new ParametersFilter(this);
        }
    }
}
