/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ssm.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Generated;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.ssm.transform.PatchFilterGroupMarshaller;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A set of patch filters, typically used for approval rules.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class PatchFilterGroup implements StructuredPojo, ToCopyableBuilder<PatchFilterGroup.Builder, PatchFilterGroup> {
    private final List<PatchFilter> patchFilters;

    private PatchFilterGroup(BuilderImpl builder) {
        this.patchFilters = builder.patchFilters;
    }

    /**
     * <p>
     * The set of patch filters that make up the group.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return The set of patch filters that make up the group.
     */
    public List<PatchFilter> patchFilters() {
        return patchFilters;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(patchFilters());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PatchFilterGroup)) {
            return false;
        }
        PatchFilterGroup other = (PatchFilterGroup) obj;
        return Objects.equals(patchFilters(), other.patchFilters());
    }

    @Override
    public String toString() {
        return ToString.builder("PatchFilterGroup").add("PatchFilters", patchFilters()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "PatchFilters":
            return Optional.of(clazz.cast(patchFilters()));
        default:
            return Optional.empty();
        }
    }

    @SdkInternalApi
    @Override
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        PatchFilterGroupMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    public interface Builder extends CopyableBuilder<Builder, PatchFilterGroup> {
        /**
         * <p>
         * The set of patch filters that make up the group.
         * </p>
         * 
         * @param patchFilters
         *        The set of patch filters that make up the group.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder patchFilters(Collection<PatchFilter> patchFilters);

        /**
         * <p>
         * The set of patch filters that make up the group.
         * </p>
         * 
         * @param patchFilters
         *        The set of patch filters that make up the group.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder patchFilters(PatchFilter... patchFilters);

        /**
         * <p>
         * The set of patch filters that make up the group.
         * </p>
         * This is a convenience that creates an instance of the {@link List<PatchFilter>.Builder} avoiding the need to
         * create one manually via {@link List<PatchFilter>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<PatchFilter>.Builder#build()} is called immediately and its
         * result is passed to {@link #patchFilters(List<PatchFilter>)}.
         * 
         * @param patchFilters
         *        a consumer that will call methods on {@link List<PatchFilter>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #patchFilters(List<PatchFilter>)
         */
        Builder patchFilters(Consumer<PatchFilter.Builder>... patchFilters);
    }

    static final class BuilderImpl implements Builder {
        private List<PatchFilter> patchFilters;

        private BuilderImpl() {
        }

        private BuilderImpl(PatchFilterGroup model) {
            patchFilters(model.patchFilters);
        }

        public final Collection<PatchFilter.Builder> getPatchFilters() {
            return patchFilters != null ? patchFilters.stream().map(PatchFilter::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder patchFilters(Collection<PatchFilter> patchFilters) {
            this.patchFilters = PatchFilterListCopier.copy(patchFilters);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder patchFilters(PatchFilter... patchFilters) {
            patchFilters(Arrays.asList(patchFilters));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder patchFilters(Consumer<PatchFilter.Builder>... patchFilters) {
            patchFilters(Stream.of(patchFilters).map(c -> PatchFilter.builder().apply(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setPatchFilters(Collection<PatchFilter.BuilderImpl> patchFilters) {
            this.patchFilters = PatchFilterListCopier.copyFromBuilder(patchFilters);
        }

        @Override
        public PatchFilterGroup build() {
            return new PatchFilterGroup(this);
        }
    }
}
