/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ssm.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfig;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public class PutComplianceItemsRequest extends SSMRequest implements
        ToCopyableBuilder<PutComplianceItemsRequest.Builder, PutComplianceItemsRequest> {
    private final String resourceId;

    private final String resourceType;

    private final String complianceType;

    private final ComplianceExecutionSummary executionSummary;

    private final List<ComplianceItemEntry> items;

    private final String itemContentHash;

    private PutComplianceItemsRequest(BuilderImpl builder) {
        super(builder);
        this.resourceId = builder.resourceId;
        this.resourceType = builder.resourceType;
        this.complianceType = builder.complianceType;
        this.executionSummary = builder.executionSummary;
        this.items = builder.items;
        this.itemContentHash = builder.itemContentHash;
    }

    /**
     * <p>
     * Specify an ID for this resource. For a managed instance, this is the instance ID.
     * </p>
     * 
     * @return Specify an ID for this resource. For a managed instance, this is the instance ID.
     */
    public String resourceId() {
        return resourceId;
    }

    /**
     * <p>
     * Specify the type of resource. <code>ManagedInstance</code> is currently the only supported resource type.
     * </p>
     * 
     * @return Specify the type of resource. <code>ManagedInstance</code> is currently the only supported resource type.
     */
    public String resourceType() {
        return resourceType;
    }

    /**
     * <p>
     * Specify the compliance type. For example, specify Association (for a State Manager association), Patch, or
     * Custom:<code>string</code>.
     * </p>
     * 
     * @return Specify the compliance type. For example, specify Association (for a State Manager association), Patch,
     *         or Custom:<code>string</code>.
     */
    public String complianceType() {
        return complianceType;
    }

    /**
     * <p>
     * A summary of the call execution that includes an execution ID, the type of execution (for example,
     * <code>Command</code>), and the date/time of the execution using a datetime object that is saved in the following
     * format: yyyy-MM-dd'T'HH:mm:ss'Z'.
     * </p>
     * 
     * @return A summary of the call execution that includes an execution ID, the type of execution (for example,
     *         <code>Command</code>), and the date/time of the execution using a datetime object that is saved in the
     *         following format: yyyy-MM-dd'T'HH:mm:ss'Z'.
     */
    public ComplianceExecutionSummary executionSummary() {
        return executionSummary;
    }

    /**
     * <p>
     * Information about the compliance as defined by the resource type. For example, for a patch compliance type,
     * <code>Items</code> includes information about the PatchSeverity, Classification, etc.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return Information about the compliance as defined by the resource type. For example, for a patch compliance
     *         type, <code>Items</code> includes information about the PatchSeverity, Classification, etc.
     */
    public List<ComplianceItemEntry> items() {
        return items;
    }

    /**
     * <p>
     * MD5 or SHA-256 content hash. The content hash is used to determine if existing information should be overwritten
     * or ignored. If the content hashes match, the request to put compliance information is ignored.
     * </p>
     * 
     * @return MD5 or SHA-256 content hash. The content hash is used to determine if existing information should be
     *         overwritten or ignored. If the content hashes match, the request to put compliance information is
     *         ignored.
     */
    public String itemContentHash() {
        return itemContentHash;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(resourceId());
        hashCode = 31 * hashCode + Objects.hashCode(resourceType());
        hashCode = 31 * hashCode + Objects.hashCode(complianceType());
        hashCode = 31 * hashCode + Objects.hashCode(executionSummary());
        hashCode = 31 * hashCode + Objects.hashCode(items());
        hashCode = 31 * hashCode + Objects.hashCode(itemContentHash());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PutComplianceItemsRequest)) {
            return false;
        }
        PutComplianceItemsRequest other = (PutComplianceItemsRequest) obj;
        return Objects.equals(resourceId(), other.resourceId()) && Objects.equals(resourceType(), other.resourceType())
                && Objects.equals(complianceType(), other.complianceType())
                && Objects.equals(executionSummary(), other.executionSummary()) && Objects.equals(items(), other.items())
                && Objects.equals(itemContentHash(), other.itemContentHash());
    }

    @Override
    public String toString() {
        return ToString.builder("PutComplianceItemsRequest").add("ResourceId", resourceId()).add("ResourceType", resourceType())
                .add("ComplianceType", complianceType()).add("ExecutionSummary", executionSummary()).add("Items", items())
                .add("ItemContentHash", itemContentHash()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ResourceId":
            return Optional.of(clazz.cast(resourceId()));
        case "ResourceType":
            return Optional.of(clazz.cast(resourceType()));
        case "ComplianceType":
            return Optional.of(clazz.cast(complianceType()));
        case "ExecutionSummary":
            return Optional.of(clazz.cast(executionSummary()));
        case "Items":
            return Optional.of(clazz.cast(items()));
        case "ItemContentHash":
            return Optional.of(clazz.cast(itemContentHash()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends SSMRequest.Builder, CopyableBuilder<Builder, PutComplianceItemsRequest> {
        /**
         * <p>
         * Specify an ID for this resource. For a managed instance, this is the instance ID.
         * </p>
         * 
         * @param resourceId
         *        Specify an ID for this resource. For a managed instance, this is the instance ID.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resourceId(String resourceId);

        /**
         * <p>
         * Specify the type of resource. <code>ManagedInstance</code> is currently the only supported resource type.
         * </p>
         * 
         * @param resourceType
         *        Specify the type of resource. <code>ManagedInstance</code> is currently the only supported resource
         *        type.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resourceType(String resourceType);

        /**
         * <p>
         * Specify the compliance type. For example, specify Association (for a State Manager association), Patch, or
         * Custom:<code>string</code>.
         * </p>
         * 
         * @param complianceType
         *        Specify the compliance type. For example, specify Association (for a State Manager association),
         *        Patch, or Custom:<code>string</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder complianceType(String complianceType);

        /**
         * <p>
         * A summary of the call execution that includes an execution ID, the type of execution (for example,
         * <code>Command</code>), and the date/time of the execution using a datetime object that is saved in the
         * following format: yyyy-MM-dd'T'HH:mm:ss'Z'.
         * </p>
         * 
         * @param executionSummary
         *        A summary of the call execution that includes an execution ID, the type of execution (for example,
         *        <code>Command</code>), and the date/time of the execution using a datetime object that is saved in the
         *        following format: yyyy-MM-dd'T'HH:mm:ss'Z'.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder executionSummary(ComplianceExecutionSummary executionSummary);

        /**
         * <p>
         * A summary of the call execution that includes an execution ID, the type of execution (for example,
         * <code>Command</code>), and the date/time of the execution using a datetime object that is saved in the
         * following format: yyyy-MM-dd'T'HH:mm:ss'Z'.
         * </p>
         * This is a convenience that creates an instance of the {@link ComplianceExecutionSummary.Builder} avoiding the
         * need to create one manually via {@link ComplianceExecutionSummary#builder()}.
         *
         * When the {@link Consumer} completes, {@link ComplianceExecutionSummary.Builder#build()} is called immediately
         * and its result is passed to {@link #executionSummary(ComplianceExecutionSummary)}.
         * 
         * @param executionSummary
         *        a consumer that will call methods on {@link ComplianceExecutionSummary.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #executionSummary(ComplianceExecutionSummary)
         */
        default Builder executionSummary(Consumer<ComplianceExecutionSummary.Builder> executionSummary) {
            return executionSummary(ComplianceExecutionSummary.builder().apply(executionSummary).build());
        }

        /**
         * <p>
         * Information about the compliance as defined by the resource type. For example, for a patch compliance type,
         * <code>Items</code> includes information about the PatchSeverity, Classification, etc.
         * </p>
         * 
         * @param items
         *        Information about the compliance as defined by the resource type. For example, for a patch compliance
         *        type, <code>Items</code> includes information about the PatchSeverity, Classification, etc.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder items(Collection<ComplianceItemEntry> items);

        /**
         * <p>
         * Information about the compliance as defined by the resource type. For example, for a patch compliance type,
         * <code>Items</code> includes information about the PatchSeverity, Classification, etc.
         * </p>
         * 
         * @param items
         *        Information about the compliance as defined by the resource type. For example, for a patch compliance
         *        type, <code>Items</code> includes information about the PatchSeverity, Classification, etc.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder items(ComplianceItemEntry... items);

        /**
         * <p>
         * Information about the compliance as defined by the resource type. For example, for a patch compliance type,
         * <code>Items</code> includes information about the PatchSeverity, Classification, etc.
         * </p>
         * This is a convenience that creates an instance of the {@link List<ComplianceItemEntry>.Builder} avoiding the
         * need to create one manually via {@link List<ComplianceItemEntry>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<ComplianceItemEntry>.Builder#build()} is called immediately
         * and its result is passed to {@link #items(List<ComplianceItemEntry>)}.
         * 
         * @param items
         *        a consumer that will call methods on {@link List<ComplianceItemEntry>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #items(List<ComplianceItemEntry>)
         */
        Builder items(Consumer<ComplianceItemEntry.Builder>... items);

        /**
         * <p>
         * MD5 or SHA-256 content hash. The content hash is used to determine if existing information should be
         * overwritten or ignored. If the content hashes match, the request to put compliance information is ignored.
         * </p>
         * 
         * @param itemContentHash
         *        MD5 or SHA-256 content hash. The content hash is used to determine if existing information should be
         *        overwritten or ignored. If the content hashes match, the request to put compliance information is
         *        ignored.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder itemContentHash(String itemContentHash);

        @Override
        Builder requestOverrideConfig(AwsRequestOverrideConfig awsRequestOverrideConfig);

        @Override
        Builder requestOverrideConfig(Consumer<AwsRequestOverrideConfig.Builder> builderConsumer);
    }

    static final class BuilderImpl extends SSMRequest.BuilderImpl implements Builder {
        private String resourceId;

        private String resourceType;

        private String complianceType;

        private ComplianceExecutionSummary executionSummary;

        private List<ComplianceItemEntry> items;

        private String itemContentHash;

        private BuilderImpl() {
        }

        private BuilderImpl(PutComplianceItemsRequest model) {
            super(model);
            resourceId(model.resourceId);
            resourceType(model.resourceType);
            complianceType(model.complianceType);
            executionSummary(model.executionSummary);
            items(model.items);
            itemContentHash(model.itemContentHash);
        }

        public final String getResourceId() {
            return resourceId;
        }

        @Override
        public final Builder resourceId(String resourceId) {
            this.resourceId = resourceId;
            return this;
        }

        public final void setResourceId(String resourceId) {
            this.resourceId = resourceId;
        }

        public final String getResourceType() {
            return resourceType;
        }

        @Override
        public final Builder resourceType(String resourceType) {
            this.resourceType = resourceType;
            return this;
        }

        public final void setResourceType(String resourceType) {
            this.resourceType = resourceType;
        }

        public final String getComplianceType() {
            return complianceType;
        }

        @Override
        public final Builder complianceType(String complianceType) {
            this.complianceType = complianceType;
            return this;
        }

        public final void setComplianceType(String complianceType) {
            this.complianceType = complianceType;
        }

        public final ComplianceExecutionSummary.Builder getExecutionSummary() {
            return executionSummary != null ? executionSummary.toBuilder() : null;
        }

        @Override
        public final Builder executionSummary(ComplianceExecutionSummary executionSummary) {
            this.executionSummary = executionSummary;
            return this;
        }

        public final void setExecutionSummary(ComplianceExecutionSummary.BuilderImpl executionSummary) {
            this.executionSummary = executionSummary != null ? executionSummary.build() : null;
        }

        public final Collection<ComplianceItemEntry.Builder> getItems() {
            return items != null ? items.stream().map(ComplianceItemEntry::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder items(Collection<ComplianceItemEntry> items) {
            this.items = ComplianceItemEntryListCopier.copy(items);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder items(ComplianceItemEntry... items) {
            items(Arrays.asList(items));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder items(Consumer<ComplianceItemEntry.Builder>... items) {
            items(Stream.of(items).map(c -> ComplianceItemEntry.builder().apply(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setItems(Collection<ComplianceItemEntry.BuilderImpl> items) {
            this.items = ComplianceItemEntryListCopier.copyFromBuilder(items);
        }

        public final String getItemContentHash() {
            return itemContentHash;
        }

        @Override
        public final Builder itemContentHash(String itemContentHash) {
            this.itemContentHash = itemContentHash;
            return this;
        }

        public final void setItemContentHash(String itemContentHash) {
            this.itemContentHash = itemContentHash;
        }

        @Override
        public Builder requestOverrideConfig(AwsRequestOverrideConfig awsRequestOverrideConfig) {
            super.requestOverrideConfig(awsRequestOverrideConfig);
            return this;
        }

        @Override
        public Builder requestOverrideConfig(Consumer<AwsRequestOverrideConfig.Builder> builderConsumer) {
            super.requestOverrideConfig(builderConsumer);
            return this;
        }

        @Override
        public PutComplianceItemsRequest build() {
            return new PutComplianceItemsRequest(this);
        }
    }
}
