/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ssm.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfig;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public class UpdateMaintenanceWindowTargetRequest extends SSMRequest implements
        ToCopyableBuilder<UpdateMaintenanceWindowTargetRequest.Builder, UpdateMaintenanceWindowTargetRequest> {
    private final String windowId;

    private final String windowTargetId;

    private final List<Target> targets;

    private final String ownerInformation;

    private final String name;

    private final String description;

    private final Boolean replace;

    private UpdateMaintenanceWindowTargetRequest(BuilderImpl builder) {
        super(builder);
        this.windowId = builder.windowId;
        this.windowTargetId = builder.windowTargetId;
        this.targets = builder.targets;
        this.ownerInformation = builder.ownerInformation;
        this.name = builder.name;
        this.description = builder.description;
        this.replace = builder.replace;
    }

    /**
     * <p>
     * The Maintenance Window ID with which to modify the target.
     * </p>
     * 
     * @return The Maintenance Window ID with which to modify the target.
     */
    public String windowId() {
        return windowId;
    }

    /**
     * <p>
     * The target ID to modify.
     * </p>
     * 
     * @return The target ID to modify.
     */
    public String windowTargetId() {
        return windowTargetId;
    }

    /**
     * <p>
     * The targets to add or replace.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return The targets to add or replace.
     */
    public List<Target> targets() {
        return targets;
    }

    /**
     * <p>
     * User-provided value that will be included in any CloudWatch events raised while running tasks for these targets
     * in this Maintenance Window.
     * </p>
     * 
     * @return User-provided value that will be included in any CloudWatch events raised while running tasks for these
     *         targets in this Maintenance Window.
     */
    public String ownerInformation() {
        return ownerInformation;
    }

    /**
     * <p>
     * A name for the update.
     * </p>
     * 
     * @return A name for the update.
     */
    public String name() {
        return name;
    }

    /**
     * <p>
     * An optional description for the update.
     * </p>
     * 
     * @return An optional description for the update.
     */
    public String description() {
        return description;
    }

    /**
     * <p>
     * If True, then all fields that are required by the RegisterTargetWithMaintenanceWindow action are also required
     * for this API request. Optional fields that are not specified are set to null.
     * </p>
     * 
     * @return If True, then all fields that are required by the RegisterTargetWithMaintenanceWindow action are also
     *         required for this API request. Optional fields that are not specified are set to null.
     */
    public Boolean replace() {
        return replace;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(windowId());
        hashCode = 31 * hashCode + Objects.hashCode(windowTargetId());
        hashCode = 31 * hashCode + Objects.hashCode(targets());
        hashCode = 31 * hashCode + Objects.hashCode(ownerInformation());
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(description());
        hashCode = 31 * hashCode + Objects.hashCode(replace());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateMaintenanceWindowTargetRequest)) {
            return false;
        }
        UpdateMaintenanceWindowTargetRequest other = (UpdateMaintenanceWindowTargetRequest) obj;
        return Objects.equals(windowId(), other.windowId()) && Objects.equals(windowTargetId(), other.windowTargetId())
                && Objects.equals(targets(), other.targets()) && Objects.equals(ownerInformation(), other.ownerInformation())
                && Objects.equals(name(), other.name()) && Objects.equals(description(), other.description())
                && Objects.equals(replace(), other.replace());
    }

    @Override
    public String toString() {
        return ToString.builder("UpdateMaintenanceWindowTargetRequest").add("WindowId", windowId())
                .add("WindowTargetId", windowTargetId()).add("Targets", targets()).add("OwnerInformation", ownerInformation())
                .add("Name", name()).add("Description", description()).add("Replace", replace()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "WindowId":
            return Optional.of(clazz.cast(windowId()));
        case "WindowTargetId":
            return Optional.of(clazz.cast(windowTargetId()));
        case "Targets":
            return Optional.of(clazz.cast(targets()));
        case "OwnerInformation":
            return Optional.of(clazz.cast(ownerInformation()));
        case "Name":
            return Optional.of(clazz.cast(name()));
        case "Description":
            return Optional.of(clazz.cast(description()));
        case "Replace":
            return Optional.of(clazz.cast(replace()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends SSMRequest.Builder, CopyableBuilder<Builder, UpdateMaintenanceWindowTargetRequest> {
        /**
         * <p>
         * The Maintenance Window ID with which to modify the target.
         * </p>
         * 
         * @param windowId
         *        The Maintenance Window ID with which to modify the target.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder windowId(String windowId);

        /**
         * <p>
         * The target ID to modify.
         * </p>
         * 
         * @param windowTargetId
         *        The target ID to modify.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder windowTargetId(String windowTargetId);

        /**
         * <p>
         * The targets to add or replace.
         * </p>
         * 
         * @param targets
         *        The targets to add or replace.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder targets(Collection<Target> targets);

        /**
         * <p>
         * The targets to add or replace.
         * </p>
         * 
         * @param targets
         *        The targets to add or replace.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder targets(Target... targets);

        /**
         * <p>
         * The targets to add or replace.
         * </p>
         * This is a convenience that creates an instance of the {@link List<Target>.Builder} avoiding the need to
         * create one manually via {@link List<Target>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<Target>.Builder#build()} is called immediately and its
         * result is passed to {@link #targets(List<Target>)}.
         * 
         * @param targets
         *        a consumer that will call methods on {@link List<Target>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #targets(List<Target>)
         */
        Builder targets(Consumer<Target.Builder>... targets);

        /**
         * <p>
         * User-provided value that will be included in any CloudWatch events raised while running tasks for these
         * targets in this Maintenance Window.
         * </p>
         * 
         * @param ownerInformation
         *        User-provided value that will be included in any CloudWatch events raised while running tasks for
         *        these targets in this Maintenance Window.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ownerInformation(String ownerInformation);

        /**
         * <p>
         * A name for the update.
         * </p>
         * 
         * @param name
         *        A name for the update.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * An optional description for the update.
         * </p>
         * 
         * @param description
         *        An optional description for the update.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * <p>
         * If True, then all fields that are required by the RegisterTargetWithMaintenanceWindow action are also
         * required for this API request. Optional fields that are not specified are set to null.
         * </p>
         * 
         * @param replace
         *        If True, then all fields that are required by the RegisterTargetWithMaintenanceWindow action are also
         *        required for this API request. Optional fields that are not specified are set to null.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder replace(Boolean replace);

        @Override
        Builder requestOverrideConfig(AwsRequestOverrideConfig awsRequestOverrideConfig);

        @Override
        Builder requestOverrideConfig(Consumer<AwsRequestOverrideConfig.Builder> builderConsumer);
    }

    static final class BuilderImpl extends SSMRequest.BuilderImpl implements Builder {
        private String windowId;

        private String windowTargetId;

        private List<Target> targets;

        private String ownerInformation;

        private String name;

        private String description;

        private Boolean replace;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateMaintenanceWindowTargetRequest model) {
            super(model);
            windowId(model.windowId);
            windowTargetId(model.windowTargetId);
            targets(model.targets);
            ownerInformation(model.ownerInformation);
            name(model.name);
            description(model.description);
            replace(model.replace);
        }

        public final String getWindowId() {
            return windowId;
        }

        @Override
        public final Builder windowId(String windowId) {
            this.windowId = windowId;
            return this;
        }

        public final void setWindowId(String windowId) {
            this.windowId = windowId;
        }

        public final String getWindowTargetId() {
            return windowTargetId;
        }

        @Override
        public final Builder windowTargetId(String windowTargetId) {
            this.windowTargetId = windowTargetId;
            return this;
        }

        public final void setWindowTargetId(String windowTargetId) {
            this.windowTargetId = windowTargetId;
        }

        public final Collection<Target.Builder> getTargets() {
            return targets != null ? targets.stream().map(Target::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder targets(Collection<Target> targets) {
            this.targets = TargetsCopier.copy(targets);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder targets(Target... targets) {
            targets(Arrays.asList(targets));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder targets(Consumer<Target.Builder>... targets) {
            targets(Stream.of(targets).map(c -> Target.builder().apply(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setTargets(Collection<Target.BuilderImpl> targets) {
            this.targets = TargetsCopier.copyFromBuilder(targets);
        }

        public final String getOwnerInformation() {
            return ownerInformation;
        }

        @Override
        public final Builder ownerInformation(String ownerInformation) {
            this.ownerInformation = ownerInformation;
            return this;
        }

        public final void setOwnerInformation(String ownerInformation) {
            this.ownerInformation = ownerInformation;
        }

        public final String getName() {
            return name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final void setName(String name) {
            this.name = name;
        }

        public final String getDescription() {
            return description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        public final Boolean getReplace() {
            return replace;
        }

        @Override
        public final Builder replace(Boolean replace) {
            this.replace = replace;
            return this;
        }

        public final void setReplace(Boolean replace) {
            this.replace = replace;
        }

        @Override
        public Builder requestOverrideConfig(AwsRequestOverrideConfig awsRequestOverrideConfig) {
            super.requestOverrideConfig(awsRequestOverrideConfig);
            return this;
        }

        @Override
        public Builder requestOverrideConfig(Consumer<AwsRequestOverrideConfig.Builder> builderConsumer) {
            super.requestOverrideConfig(builderConsumer);
            return this;
        }

        @Override
        public UpdateMaintenanceWindowTargetRequest build() {
            return new UpdateMaintenanceWindowTargetRequest(this);
        }
    }
}
