/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ssm.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfig;
import software.amazon.awssdk.utils.CollectionUtils;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public class UpdateMaintenanceWindowTaskRequest extends SSMRequest implements
        ToCopyableBuilder<UpdateMaintenanceWindowTaskRequest.Builder, UpdateMaintenanceWindowTaskRequest> {
    private final String windowId;

    private final String windowTaskId;

    private final List<Target> targets;

    private final String taskArn;

    private final String serviceRoleArn;

    private final Map<String, MaintenanceWindowTaskParameterValueExpression> taskParameters;

    private final MaintenanceWindowTaskInvocationParameters taskInvocationParameters;

    private final Integer priority;

    private final String maxConcurrency;

    private final String maxErrors;

    private final LoggingInfo loggingInfo;

    private final String name;

    private final String description;

    private final Boolean replace;

    private UpdateMaintenanceWindowTaskRequest(BuilderImpl builder) {
        super(builder);
        this.windowId = builder.windowId;
        this.windowTaskId = builder.windowTaskId;
        this.targets = builder.targets;
        this.taskArn = builder.taskArn;
        this.serviceRoleArn = builder.serviceRoleArn;
        this.taskParameters = builder.taskParameters;
        this.taskInvocationParameters = builder.taskInvocationParameters;
        this.priority = builder.priority;
        this.maxConcurrency = builder.maxConcurrency;
        this.maxErrors = builder.maxErrors;
        this.loggingInfo = builder.loggingInfo;
        this.name = builder.name;
        this.description = builder.description;
        this.replace = builder.replace;
    }

    /**
     * <p>
     * The Maintenance Window ID that contains the task to modify.
     * </p>
     * 
     * @return The Maintenance Window ID that contains the task to modify.
     */
    public String windowId() {
        return windowId;
    }

    /**
     * <p>
     * The task ID to modify.
     * </p>
     * 
     * @return The task ID to modify.
     */
    public String windowTaskId() {
        return windowTaskId;
    }

    /**
     * <p>
     * The targets (either instances or tags) to modify. Instances are specified using
     * Key=instanceids,Values=instanceID_1,instanceID_2. Tags are specified using Key=tag_name,Values=tag_value.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return The targets (either instances or tags) to modify. Instances are specified using
     *         Key=instanceids,Values=instanceID_1,instanceID_2. Tags are specified using Key=tag_name,Values=tag_value.
     */
    public List<Target> targets() {
        return targets;
    }

    /**
     * <p>
     * The task ARN to modify.
     * </p>
     * 
     * @return The task ARN to modify.
     */
    public String taskArn() {
        return taskArn;
    }

    /**
     * <p>
     * The IAM service role ARN to modify. The system assumes this role during task execution.
     * </p>
     * 
     * @return The IAM service role ARN to modify. The system assumes this role during task execution.
     */
    public String serviceRoleArn() {
        return serviceRoleArn;
    }

    /**
     * <p>
     * The parameters to modify. The map has the following format:
     * </p>
     * <p>
     * Key: string, between 1 and 255 characters
     * </p>
     * <p>
     * Value: an array of strings, each string is between 1 and 255 characters
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return The parameters to modify. The map has the following format:</p>
     *         <p>
     *         Key: string, between 1 and 255 characters
     *         </p>
     *         <p>
     *         Value: an array of strings, each string is between 1 and 255 characters
     */
    public Map<String, MaintenanceWindowTaskParameterValueExpression> taskParameters() {
        return taskParameters;
    }

    /**
     * <p>
     * The parameters that the task should use during execution. Populate only the fields that match the task type. All
     * other fields should be empty.
     * </p>
     * 
     * @return The parameters that the task should use during execution. Populate only the fields that match the task
     *         type. All other fields should be empty.
     */
    public MaintenanceWindowTaskInvocationParameters taskInvocationParameters() {
        return taskInvocationParameters;
    }

    /**
     * <p>
     * The new task priority to specify. The lower the number, the higher the priority. Tasks that have the same
     * priority are scheduled in parallel.
     * </p>
     * 
     * @return The new task priority to specify. The lower the number, the higher the priority. Tasks that have the same
     *         priority are scheduled in parallel.
     */
    public Integer priority() {
        return priority;
    }

    /**
     * <p>
     * The new <code>MaxConcurrency</code> value you want to specify. <code>MaxConcurrency</code> is the number of
     * targets that are allowed to run this task in parallel.
     * </p>
     * 
     * @return The new <code>MaxConcurrency</code> value you want to specify. <code>MaxConcurrency</code> is the number
     *         of targets that are allowed to run this task in parallel.
     */
    public String maxConcurrency() {
        return maxConcurrency;
    }

    /**
     * <p>
     * The new <code>MaxErrors</code> value to specify. <code>MaxErrors</code> is the maximum number of errors that are
     * allowed before the task stops being scheduled.
     * </p>
     * 
     * @return The new <code>MaxErrors</code> value to specify. <code>MaxErrors</code> is the maximum number of errors
     *         that are allowed before the task stops being scheduled.
     */
    public String maxErrors() {
        return maxErrors;
    }

    /**
     * <p>
     * The new logging location in Amazon S3 to specify.
     * </p>
     * 
     * @return The new logging location in Amazon S3 to specify.
     */
    public LoggingInfo loggingInfo() {
        return loggingInfo;
    }

    /**
     * <p>
     * The new task name to specify.
     * </p>
     * 
     * @return The new task name to specify.
     */
    public String name() {
        return name;
    }

    /**
     * <p>
     * The new task description to specify.
     * </p>
     * 
     * @return The new task description to specify.
     */
    public String description() {
        return description;
    }

    /**
     * <p>
     * If True, then all fields that are required by the RegisterTaskWithMaintenanceWndow action are also required for
     * this API request. Optional fields that are not specified are set to null.
     * </p>
     * 
     * @return If True, then all fields that are required by the RegisterTaskWithMaintenanceWndow action are also
     *         required for this API request. Optional fields that are not specified are set to null.
     */
    public Boolean replace() {
        return replace;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(windowId());
        hashCode = 31 * hashCode + Objects.hashCode(windowTaskId());
        hashCode = 31 * hashCode + Objects.hashCode(targets());
        hashCode = 31 * hashCode + Objects.hashCode(taskArn());
        hashCode = 31 * hashCode + Objects.hashCode(serviceRoleArn());
        hashCode = 31 * hashCode + Objects.hashCode(taskParameters());
        hashCode = 31 * hashCode + Objects.hashCode(taskInvocationParameters());
        hashCode = 31 * hashCode + Objects.hashCode(priority());
        hashCode = 31 * hashCode + Objects.hashCode(maxConcurrency());
        hashCode = 31 * hashCode + Objects.hashCode(maxErrors());
        hashCode = 31 * hashCode + Objects.hashCode(loggingInfo());
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(description());
        hashCode = 31 * hashCode + Objects.hashCode(replace());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateMaintenanceWindowTaskRequest)) {
            return false;
        }
        UpdateMaintenanceWindowTaskRequest other = (UpdateMaintenanceWindowTaskRequest) obj;
        return Objects.equals(windowId(), other.windowId()) && Objects.equals(windowTaskId(), other.windowTaskId())
                && Objects.equals(targets(), other.targets()) && Objects.equals(taskArn(), other.taskArn())
                && Objects.equals(serviceRoleArn(), other.serviceRoleArn())
                && Objects.equals(taskParameters(), other.taskParameters())
                && Objects.equals(taskInvocationParameters(), other.taskInvocationParameters())
                && Objects.equals(priority(), other.priority()) && Objects.equals(maxConcurrency(), other.maxConcurrency())
                && Objects.equals(maxErrors(), other.maxErrors()) && Objects.equals(loggingInfo(), other.loggingInfo())
                && Objects.equals(name(), other.name()) && Objects.equals(description(), other.description())
                && Objects.equals(replace(), other.replace());
    }

    @Override
    public String toString() {
        return ToString.builder("UpdateMaintenanceWindowTaskRequest").add("WindowId", windowId())
                .add("WindowTaskId", windowTaskId()).add("Targets", targets()).add("TaskArn", taskArn())
                .add("ServiceRoleArn", serviceRoleArn()).add("TaskParameters", taskParameters())
                .add("TaskInvocationParameters", taskInvocationParameters()).add("Priority", priority())
                .add("MaxConcurrency", maxConcurrency()).add("MaxErrors", maxErrors()).add("LoggingInfo", loggingInfo())
                .add("Name", name()).add("Description", description()).add("Replace", replace()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "WindowId":
            return Optional.of(clazz.cast(windowId()));
        case "WindowTaskId":
            return Optional.of(clazz.cast(windowTaskId()));
        case "Targets":
            return Optional.of(clazz.cast(targets()));
        case "TaskArn":
            return Optional.of(clazz.cast(taskArn()));
        case "ServiceRoleArn":
            return Optional.of(clazz.cast(serviceRoleArn()));
        case "TaskParameters":
            return Optional.of(clazz.cast(taskParameters()));
        case "TaskInvocationParameters":
            return Optional.of(clazz.cast(taskInvocationParameters()));
        case "Priority":
            return Optional.of(clazz.cast(priority()));
        case "MaxConcurrency":
            return Optional.of(clazz.cast(maxConcurrency()));
        case "MaxErrors":
            return Optional.of(clazz.cast(maxErrors()));
        case "LoggingInfo":
            return Optional.of(clazz.cast(loggingInfo()));
        case "Name":
            return Optional.of(clazz.cast(name()));
        case "Description":
            return Optional.of(clazz.cast(description()));
        case "Replace":
            return Optional.of(clazz.cast(replace()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends SSMRequest.Builder, CopyableBuilder<Builder, UpdateMaintenanceWindowTaskRequest> {
        /**
         * <p>
         * The Maintenance Window ID that contains the task to modify.
         * </p>
         * 
         * @param windowId
         *        The Maintenance Window ID that contains the task to modify.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder windowId(String windowId);

        /**
         * <p>
         * The task ID to modify.
         * </p>
         * 
         * @param windowTaskId
         *        The task ID to modify.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder windowTaskId(String windowTaskId);

        /**
         * <p>
         * The targets (either instances or tags) to modify. Instances are specified using
         * Key=instanceids,Values=instanceID_1,instanceID_2. Tags are specified using Key=tag_name,Values=tag_value.
         * </p>
         * 
         * @param targets
         *        The targets (either instances or tags) to modify. Instances are specified using
         *        Key=instanceids,Values=instanceID_1,instanceID_2. Tags are specified using
         *        Key=tag_name,Values=tag_value.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder targets(Collection<Target> targets);

        /**
         * <p>
         * The targets (either instances or tags) to modify. Instances are specified using
         * Key=instanceids,Values=instanceID_1,instanceID_2. Tags are specified using Key=tag_name,Values=tag_value.
         * </p>
         * 
         * @param targets
         *        The targets (either instances or tags) to modify. Instances are specified using
         *        Key=instanceids,Values=instanceID_1,instanceID_2. Tags are specified using
         *        Key=tag_name,Values=tag_value.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder targets(Target... targets);

        /**
         * <p>
         * The targets (either instances or tags) to modify. Instances are specified using
         * Key=instanceids,Values=instanceID_1,instanceID_2. Tags are specified using Key=tag_name,Values=tag_value.
         * </p>
         * This is a convenience that creates an instance of the {@link List<Target>.Builder} avoiding the need to
         * create one manually via {@link List<Target>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<Target>.Builder#build()} is called immediately and its
         * result is passed to {@link #targets(List<Target>)}.
         * 
         * @param targets
         *        a consumer that will call methods on {@link List<Target>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #targets(List<Target>)
         */
        Builder targets(Consumer<Target.Builder>... targets);

        /**
         * <p>
         * The task ARN to modify.
         * </p>
         * 
         * @param taskArn
         *        The task ARN to modify.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder taskArn(String taskArn);

        /**
         * <p>
         * The IAM service role ARN to modify. The system assumes this role during task execution.
         * </p>
         * 
         * @param serviceRoleArn
         *        The IAM service role ARN to modify. The system assumes this role during task execution.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder serviceRoleArn(String serviceRoleArn);

        /**
         * <p>
         * The parameters to modify. The map has the following format:
         * </p>
         * <p>
         * Key: string, between 1 and 255 characters
         * </p>
         * <p>
         * Value: an array of strings, each string is between 1 and 255 characters
         * </p>
         * 
         * @param taskParameters
         *        The parameters to modify. The map has the following format:</p>
         *        <p>
         *        Key: string, between 1 and 255 characters
         *        </p>
         *        <p>
         *        Value: an array of strings, each string is between 1 and 255 characters
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder taskParameters(Map<String, MaintenanceWindowTaskParameterValueExpression> taskParameters);

        /**
         * <p>
         * The parameters that the task should use during execution. Populate only the fields that match the task type.
         * All other fields should be empty.
         * </p>
         * 
         * @param taskInvocationParameters
         *        The parameters that the task should use during execution. Populate only the fields that match the task
         *        type. All other fields should be empty.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder taskInvocationParameters(MaintenanceWindowTaskInvocationParameters taskInvocationParameters);

        /**
         * <p>
         * The parameters that the task should use during execution. Populate only the fields that match the task type.
         * All other fields should be empty.
         * </p>
         * This is a convenience that creates an instance of the
         * {@link MaintenanceWindowTaskInvocationParameters.Builder} avoiding the need to create one manually via
         * {@link MaintenanceWindowTaskInvocationParameters#builder()}.
         *
         * When the {@link Consumer} completes, {@link MaintenanceWindowTaskInvocationParameters.Builder#build()} is
         * called immediately and its result is passed to
         * {@link #taskInvocationParameters(MaintenanceWindowTaskInvocationParameters)}.
         * 
         * @param taskInvocationParameters
         *        a consumer that will call methods on {@link MaintenanceWindowTaskInvocationParameters.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #taskInvocationParameters(MaintenanceWindowTaskInvocationParameters)
         */
        default Builder taskInvocationParameters(
                Consumer<MaintenanceWindowTaskInvocationParameters.Builder> taskInvocationParameters) {
            return taskInvocationParameters(MaintenanceWindowTaskInvocationParameters.builder().apply(taskInvocationParameters)
                    .build());
        }

        /**
         * <p>
         * The new task priority to specify. The lower the number, the higher the priority. Tasks that have the same
         * priority are scheduled in parallel.
         * </p>
         * 
         * @param priority
         *        The new task priority to specify. The lower the number, the higher the priority. Tasks that have the
         *        same priority are scheduled in parallel.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder priority(Integer priority);

        /**
         * <p>
         * The new <code>MaxConcurrency</code> value you want to specify. <code>MaxConcurrency</code> is the number of
         * targets that are allowed to run this task in parallel.
         * </p>
         * 
         * @param maxConcurrency
         *        The new <code>MaxConcurrency</code> value you want to specify. <code>MaxConcurrency</code> is the
         *        number of targets that are allowed to run this task in parallel.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maxConcurrency(String maxConcurrency);

        /**
         * <p>
         * The new <code>MaxErrors</code> value to specify. <code>MaxErrors</code> is the maximum number of errors that
         * are allowed before the task stops being scheduled.
         * </p>
         * 
         * @param maxErrors
         *        The new <code>MaxErrors</code> value to specify. <code>MaxErrors</code> is the maximum number of
         *        errors that are allowed before the task stops being scheduled.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maxErrors(String maxErrors);

        /**
         * <p>
         * The new logging location in Amazon S3 to specify.
         * </p>
         * 
         * @param loggingInfo
         *        The new logging location in Amazon S3 to specify.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder loggingInfo(LoggingInfo loggingInfo);

        /**
         * <p>
         * The new logging location in Amazon S3 to specify.
         * </p>
         * This is a convenience that creates an instance of the {@link LoggingInfo.Builder} avoiding the need to create
         * one manually via {@link LoggingInfo#builder()}.
         *
         * When the {@link Consumer} completes, {@link LoggingInfo.Builder#build()} is called immediately and its result
         * is passed to {@link #loggingInfo(LoggingInfo)}.
         * 
         * @param loggingInfo
         *        a consumer that will call methods on {@link LoggingInfo.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #loggingInfo(LoggingInfo)
         */
        default Builder loggingInfo(Consumer<LoggingInfo.Builder> loggingInfo) {
            return loggingInfo(LoggingInfo.builder().apply(loggingInfo).build());
        }

        /**
         * <p>
         * The new task name to specify.
         * </p>
         * 
         * @param name
         *        The new task name to specify.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * The new task description to specify.
         * </p>
         * 
         * @param description
         *        The new task description to specify.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * <p>
         * If True, then all fields that are required by the RegisterTaskWithMaintenanceWndow action are also required
         * for this API request. Optional fields that are not specified are set to null.
         * </p>
         * 
         * @param replace
         *        If True, then all fields that are required by the RegisterTaskWithMaintenanceWndow action are also
         *        required for this API request. Optional fields that are not specified are set to null.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder replace(Boolean replace);

        @Override
        Builder requestOverrideConfig(AwsRequestOverrideConfig awsRequestOverrideConfig);

        @Override
        Builder requestOverrideConfig(Consumer<AwsRequestOverrideConfig.Builder> builderConsumer);
    }

    static final class BuilderImpl extends SSMRequest.BuilderImpl implements Builder {
        private String windowId;

        private String windowTaskId;

        private List<Target> targets;

        private String taskArn;

        private String serviceRoleArn;

        private Map<String, MaintenanceWindowTaskParameterValueExpression> taskParameters;

        private MaintenanceWindowTaskInvocationParameters taskInvocationParameters;

        private Integer priority;

        private String maxConcurrency;

        private String maxErrors;

        private LoggingInfo loggingInfo;

        private String name;

        private String description;

        private Boolean replace;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateMaintenanceWindowTaskRequest model) {
            super(model);
            windowId(model.windowId);
            windowTaskId(model.windowTaskId);
            targets(model.targets);
            taskArn(model.taskArn);
            serviceRoleArn(model.serviceRoleArn);
            taskParameters(model.taskParameters);
            taskInvocationParameters(model.taskInvocationParameters);
            priority(model.priority);
            maxConcurrency(model.maxConcurrency);
            maxErrors(model.maxErrors);
            loggingInfo(model.loggingInfo);
            name(model.name);
            description(model.description);
            replace(model.replace);
        }

        public final String getWindowId() {
            return windowId;
        }

        @Override
        public final Builder windowId(String windowId) {
            this.windowId = windowId;
            return this;
        }

        public final void setWindowId(String windowId) {
            this.windowId = windowId;
        }

        public final String getWindowTaskId() {
            return windowTaskId;
        }

        @Override
        public final Builder windowTaskId(String windowTaskId) {
            this.windowTaskId = windowTaskId;
            return this;
        }

        public final void setWindowTaskId(String windowTaskId) {
            this.windowTaskId = windowTaskId;
        }

        public final Collection<Target.Builder> getTargets() {
            return targets != null ? targets.stream().map(Target::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder targets(Collection<Target> targets) {
            this.targets = TargetsCopier.copy(targets);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder targets(Target... targets) {
            targets(Arrays.asList(targets));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder targets(Consumer<Target.Builder>... targets) {
            targets(Stream.of(targets).map(c -> Target.builder().apply(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setTargets(Collection<Target.BuilderImpl> targets) {
            this.targets = TargetsCopier.copyFromBuilder(targets);
        }

        public final String getTaskArn() {
            return taskArn;
        }

        @Override
        public final Builder taskArn(String taskArn) {
            this.taskArn = taskArn;
            return this;
        }

        public final void setTaskArn(String taskArn) {
            this.taskArn = taskArn;
        }

        public final String getServiceRoleArn() {
            return serviceRoleArn;
        }

        @Override
        public final Builder serviceRoleArn(String serviceRoleArn) {
            this.serviceRoleArn = serviceRoleArn;
            return this;
        }

        public final void setServiceRoleArn(String serviceRoleArn) {
            this.serviceRoleArn = serviceRoleArn;
        }

        public final Map<String, MaintenanceWindowTaskParameterValueExpression.Builder> getTaskParameters() {
            return taskParameters != null ? CollectionUtils.mapValues(taskParameters,
                    MaintenanceWindowTaskParameterValueExpression::toBuilder) : null;
        }

        @Override
        public final Builder taskParameters(Map<String, MaintenanceWindowTaskParameterValueExpression> taskParameters) {
            this.taskParameters = MaintenanceWindowTaskParametersCopier.copy(taskParameters);
            return this;
        }

        public final void setTaskParameters(Map<String, MaintenanceWindowTaskParameterValueExpression.BuilderImpl> taskParameters) {
            this.taskParameters = MaintenanceWindowTaskParametersCopier.copyFromBuilder(taskParameters);
        }

        public final MaintenanceWindowTaskInvocationParameters.Builder getTaskInvocationParameters() {
            return taskInvocationParameters != null ? taskInvocationParameters.toBuilder() : null;
        }

        @Override
        public final Builder taskInvocationParameters(MaintenanceWindowTaskInvocationParameters taskInvocationParameters) {
            this.taskInvocationParameters = taskInvocationParameters;
            return this;
        }

        public final void setTaskInvocationParameters(
                MaintenanceWindowTaskInvocationParameters.BuilderImpl taskInvocationParameters) {
            this.taskInvocationParameters = taskInvocationParameters != null ? taskInvocationParameters.build() : null;
        }

        public final Integer getPriority() {
            return priority;
        }

        @Override
        public final Builder priority(Integer priority) {
            this.priority = priority;
            return this;
        }

        public final void setPriority(Integer priority) {
            this.priority = priority;
        }

        public final String getMaxConcurrency() {
            return maxConcurrency;
        }

        @Override
        public final Builder maxConcurrency(String maxConcurrency) {
            this.maxConcurrency = maxConcurrency;
            return this;
        }

        public final void setMaxConcurrency(String maxConcurrency) {
            this.maxConcurrency = maxConcurrency;
        }

        public final String getMaxErrors() {
            return maxErrors;
        }

        @Override
        public final Builder maxErrors(String maxErrors) {
            this.maxErrors = maxErrors;
            return this;
        }

        public final void setMaxErrors(String maxErrors) {
            this.maxErrors = maxErrors;
        }

        public final LoggingInfo.Builder getLoggingInfo() {
            return loggingInfo != null ? loggingInfo.toBuilder() : null;
        }

        @Override
        public final Builder loggingInfo(LoggingInfo loggingInfo) {
            this.loggingInfo = loggingInfo;
            return this;
        }

        public final void setLoggingInfo(LoggingInfo.BuilderImpl loggingInfo) {
            this.loggingInfo = loggingInfo != null ? loggingInfo.build() : null;
        }

        public final String getName() {
            return name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final void setName(String name) {
            this.name = name;
        }

        public final String getDescription() {
            return description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        public final Boolean getReplace() {
            return replace;
        }

        @Override
        public final Builder replace(Boolean replace) {
            this.replace = replace;
            return this;
        }

        public final void setReplace(Boolean replace) {
            this.replace = replace;
        }

        @Override
        public Builder requestOverrideConfig(AwsRequestOverrideConfig awsRequestOverrideConfig) {
            super.requestOverrideConfig(awsRequestOverrideConfig);
            return this;
        }

        @Override
        public Builder requestOverrideConfig(Consumer<AwsRequestOverrideConfig.Builder> builderConsumer) {
            super.requestOverrideConfig(builderConsumer);
            return this;
        }

        @Override
        public UpdateMaintenanceWindowTaskRequest build() {
            return new UpdateMaintenanceWindowTaskRequest(this);
        }
    }
}
