/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ssm.transform;

import java.time.Instant;
import javax.annotation.Generated;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.ssm.model.ComplianceExecutionSummary;
import software.amazon.awssdk.utils.Validate;

/**
 * {@link ComplianceExecutionSummary} Marshaller
 */
@Generated("software.amazon.awssdk:codegen")
@SdkInternalApi
public class ComplianceExecutionSummaryMarshaller {
    private static final MarshallingInfo<Instant> EXECUTIONTIME_BINDING = MarshallingInfo.builder(MarshallingType.INSTANT)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ExecutionTime").isBinary(false).build();

    private static final MarshallingInfo<String> EXECUTIONID_BINDING = MarshallingInfo.builder(MarshallingType.STRING)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ExecutionId").isBinary(false).build();

    private static final MarshallingInfo<String> EXECUTIONTYPE_BINDING = MarshallingInfo.builder(MarshallingType.STRING)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ExecutionType").isBinary(false).build();

    private static final ComplianceExecutionSummaryMarshaller INSTANCE = new ComplianceExecutionSummaryMarshaller();

    private ComplianceExecutionSummaryMarshaller() {
    }

    public static ComplianceExecutionSummaryMarshaller getInstance() {
        return INSTANCE;
    }

    /**
     * Marshall the given parameter object
     */
    public void marshall(ComplianceExecutionSummary complianceExecutionSummary, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull(complianceExecutionSummary, "complianceExecutionSummary");
        Validate.paramNotNull(protocolMarshaller, "protocolMarshaller");
        try {
            protocolMarshaller.marshall(complianceExecutionSummary.executionTime(), EXECUTIONTIME_BINDING);
            protocolMarshaller.marshall(complianceExecutionSummary.executionId(), EXECUTIONID_BINDING);
            protocolMarshaller.marshall(complianceExecutionSummary.executionType(), EXECUTIONTYPE_BINDING);
        } catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), e);
        }
    }
}
