/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ssm.transform;

import java.util.List;
import javax.annotation.Generated;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.ssm.model.InventoryResultItem;
import software.amazon.awssdk.utils.Validate;

/**
 * {@link InventoryResultItem} Marshaller
 */
@Generated("software.amazon.awssdk:codegen")
@SdkInternalApi
public class InventoryResultItemMarshaller {
    private static final MarshallingInfo<String> TYPENAME_BINDING = MarshallingInfo.builder(MarshallingType.STRING)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("TypeName").isBinary(false).build();

    private static final MarshallingInfo<String> SCHEMAVERSION_BINDING = MarshallingInfo.builder(MarshallingType.STRING)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("SchemaVersion").isBinary(false).build();

    private static final MarshallingInfo<String> CAPTURETIME_BINDING = MarshallingInfo.builder(MarshallingType.STRING)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("CaptureTime").isBinary(false).build();

    private static final MarshallingInfo<String> CONTENTHASH_BINDING = MarshallingInfo.builder(MarshallingType.STRING)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ContentHash").isBinary(false).build();

    private static final MarshallingInfo<List> CONTENT_BINDING = MarshallingInfo.builder(MarshallingType.LIST)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Content").isBinary(false).build();

    private static final InventoryResultItemMarshaller INSTANCE = new InventoryResultItemMarshaller();

    private InventoryResultItemMarshaller() {
    }

    public static InventoryResultItemMarshaller getInstance() {
        return INSTANCE;
    }

    /**
     * Marshall the given parameter object
     */
    public void marshall(InventoryResultItem inventoryResultItem, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull(inventoryResultItem, "inventoryResultItem");
        Validate.paramNotNull(protocolMarshaller, "protocolMarshaller");
        try {
            protocolMarshaller.marshall(inventoryResultItem.typeName(), TYPENAME_BINDING);
            protocolMarshaller.marshall(inventoryResultItem.schemaVersion(), SCHEMAVERSION_BINDING);
            protocolMarshaller.marshall(inventoryResultItem.captureTime(), CAPTURETIME_BINDING);
            protocolMarshaller.marshall(inventoryResultItem.contentHash(), CONTENTHASH_BINDING);
            protocolMarshaller.marshall(inventoryResultItem.content(), CONTENT_BINDING);
        } catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), e);
        }
    }
}
