/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ssm.transform;

import java.time.Instant;
import javax.annotation.Generated;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.ssm.model.MaintenanceWindowExecution;
import software.amazon.awssdk.utils.Validate;

/**
 * {@link MaintenanceWindowExecution} Marshaller
 */
@Generated("software.amazon.awssdk:codegen")
@SdkInternalApi
public class MaintenanceWindowExecutionMarshaller {
    private static final MarshallingInfo<String> WINDOWID_BINDING = MarshallingInfo.builder(MarshallingType.STRING)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("WindowId").isBinary(false).build();

    private static final MarshallingInfo<String> WINDOWEXECUTIONID_BINDING = MarshallingInfo.builder(MarshallingType.STRING)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("WindowExecutionId").isBinary(false).build();

    private static final MarshallingInfo<String> STATUS_BINDING = MarshallingInfo.builder(MarshallingType.STRING)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Status").isBinary(false).build();

    private static final MarshallingInfo<String> STATUSDETAILS_BINDING = MarshallingInfo.builder(MarshallingType.STRING)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("StatusDetails").isBinary(false).build();

    private static final MarshallingInfo<Instant> STARTTIME_BINDING = MarshallingInfo.builder(MarshallingType.INSTANT)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("StartTime").isBinary(false).build();

    private static final MarshallingInfo<Instant> ENDTIME_BINDING = MarshallingInfo.builder(MarshallingType.INSTANT)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("EndTime").isBinary(false).build();

    private static final MaintenanceWindowExecutionMarshaller INSTANCE = new MaintenanceWindowExecutionMarshaller();

    private MaintenanceWindowExecutionMarshaller() {
    }

    public static MaintenanceWindowExecutionMarshaller getInstance() {
        return INSTANCE;
    }

    /**
     * Marshall the given parameter object
     */
    public void marshall(MaintenanceWindowExecution maintenanceWindowExecution, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull(maintenanceWindowExecution, "maintenanceWindowExecution");
        Validate.paramNotNull(protocolMarshaller, "protocolMarshaller");
        try {
            protocolMarshaller.marshall(maintenanceWindowExecution.windowId(), WINDOWID_BINDING);
            protocolMarshaller.marshall(maintenanceWindowExecution.windowExecutionId(), WINDOWEXECUTIONID_BINDING);
            protocolMarshaller.marshall(maintenanceWindowExecution.statusAsString(), STATUS_BINDING);
            protocolMarshaller.marshall(maintenanceWindowExecution.statusDetails(), STATUSDETAILS_BINDING);
            protocolMarshaller.marshall(maintenanceWindowExecution.startTime(), STARTTIME_BINDING);
            protocolMarshaller.marshall(maintenanceWindowExecution.endTime(), ENDTIME_BINDING);
        } catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), e);
        }
    }
}
