/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ssm.transform;

import java.time.Instant;
import javax.annotation.Generated;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.ssm.model.PatchComplianceData;
import software.amazon.awssdk.utils.Validate;

/**
 * {@link PatchComplianceData} Marshaller
 */
@Generated("software.amazon.awssdk:codegen")
@SdkInternalApi
public class PatchComplianceDataMarshaller {
    private static final MarshallingInfo<String> TITLE_BINDING = MarshallingInfo.builder(MarshallingType.STRING)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Title").isBinary(false).build();

    private static final MarshallingInfo<String> KBID_BINDING = MarshallingInfo.builder(MarshallingType.STRING)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("KBId").isBinary(false).build();

    private static final MarshallingInfo<String> CLASSIFICATION_BINDING = MarshallingInfo.builder(MarshallingType.STRING)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Classification").isBinary(false).build();

    private static final MarshallingInfo<String> SEVERITY_BINDING = MarshallingInfo.builder(MarshallingType.STRING)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Severity").isBinary(false).build();

    private static final MarshallingInfo<String> STATE_BINDING = MarshallingInfo.builder(MarshallingType.STRING)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("State").isBinary(false).build();

    private static final MarshallingInfo<Instant> INSTALLEDTIME_BINDING = MarshallingInfo.builder(MarshallingType.INSTANT)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("InstalledTime").isBinary(false).build();

    private static final PatchComplianceDataMarshaller INSTANCE = new PatchComplianceDataMarshaller();

    private PatchComplianceDataMarshaller() {
    }

    public static PatchComplianceDataMarshaller getInstance() {
        return INSTANCE;
    }

    /**
     * Marshall the given parameter object
     */
    public void marshall(PatchComplianceData patchComplianceData, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull(patchComplianceData, "patchComplianceData");
        Validate.paramNotNull(protocolMarshaller, "protocolMarshaller");
        try {
            protocolMarshaller.marshall(patchComplianceData.title(), TITLE_BINDING);
            protocolMarshaller.marshall(patchComplianceData.kbId(), KBID_BINDING);
            protocolMarshaller.marshall(patchComplianceData.classification(), CLASSIFICATION_BINDING);
            protocolMarshaller.marshall(patchComplianceData.severity(), SEVERITY_BINDING);
            protocolMarshaller.marshall(patchComplianceData.stateAsString(), STATE_BINDING);
            protocolMarshaller.marshall(patchComplianceData.installedTime(), INSTALLEDTIME_BINDING);
        } catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), e);
        }
    }
}
