/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ssm.transform;

import java.util.List;
import javax.annotation.Generated;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.ssm.model.PutComplianceItemsRequest;
import software.amazon.awssdk.utils.Validate;

/**
 * {@link PutComplianceItemsRequest} Marshaller
 */
@Generated("software.amazon.awssdk:codegen")
@SdkInternalApi
public class PutComplianceItemsRequestModelMarshaller {
    private static final MarshallingInfo<String> RESOURCEID_BINDING = MarshallingInfo.builder(MarshallingType.STRING)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ResourceId").isBinary(false).build();

    private static final MarshallingInfo<String> RESOURCETYPE_BINDING = MarshallingInfo.builder(MarshallingType.STRING)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ResourceType").isBinary(false).build();

    private static final MarshallingInfo<String> COMPLIANCETYPE_BINDING = MarshallingInfo.builder(MarshallingType.STRING)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ComplianceType").isBinary(false).build();

    private static final MarshallingInfo<StructuredPojo> EXECUTIONSUMMARY_BINDING = MarshallingInfo
            .builder(MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD)
            .marshallLocationName("ExecutionSummary").isBinary(false).build();

    private static final MarshallingInfo<List> ITEMS_BINDING = MarshallingInfo.builder(MarshallingType.LIST)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Items").isBinary(false).build();

    private static final MarshallingInfo<String> ITEMCONTENTHASH_BINDING = MarshallingInfo.builder(MarshallingType.STRING)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ItemContentHash").isBinary(false).build();

    private static final PutComplianceItemsRequestModelMarshaller INSTANCE = new PutComplianceItemsRequestModelMarshaller();

    private PutComplianceItemsRequestModelMarshaller() {
    }

    public static PutComplianceItemsRequestModelMarshaller getInstance() {
        return INSTANCE;
    }

    /**
     * Marshall the given parameter object
     */
    public void marshall(PutComplianceItemsRequest putComplianceItemsRequest, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull(putComplianceItemsRequest, "putComplianceItemsRequest");
        Validate.paramNotNull(protocolMarshaller, "protocolMarshaller");
        try {
            protocolMarshaller.marshall(putComplianceItemsRequest.resourceId(), RESOURCEID_BINDING);
            protocolMarshaller.marshall(putComplianceItemsRequest.resourceType(), RESOURCETYPE_BINDING);
            protocolMarshaller.marshall(putComplianceItemsRequest.complianceType(), COMPLIANCETYPE_BINDING);
            protocolMarshaller.marshall(putComplianceItemsRequest.executionSummary(), EXECUTIONSUMMARY_BINDING);
            protocolMarshaller.marshall(putComplianceItemsRequest.items(), ITEMS_BINDING);
            protocolMarshaller.marshall(putComplianceItemsRequest.itemContentHash(), ITEMCONTENTHASH_BINDING);
        } catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), e);
        }
    }
}
