/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ssm.transform;

import javax.annotation.Generated;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.ssm.model.ResourceComplianceSummaryItem;
import software.amazon.awssdk.utils.Validate;

/**
 * {@link ResourceComplianceSummaryItem} Marshaller
 */
@Generated("software.amazon.awssdk:codegen")
@SdkInternalApi
public class ResourceComplianceSummaryItemMarshaller {
    private static final MarshallingInfo<String> COMPLIANCETYPE_BINDING = MarshallingInfo.builder(MarshallingType.STRING)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ComplianceType").isBinary(false).build();

    private static final MarshallingInfo<String> RESOURCETYPE_BINDING = MarshallingInfo.builder(MarshallingType.STRING)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ResourceType").isBinary(false).build();

    private static final MarshallingInfo<String> RESOURCEID_BINDING = MarshallingInfo.builder(MarshallingType.STRING)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ResourceId").isBinary(false).build();

    private static final MarshallingInfo<String> STATUS_BINDING = MarshallingInfo.builder(MarshallingType.STRING)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Status").isBinary(false).build();

    private static final MarshallingInfo<String> OVERALLSEVERITY_BINDING = MarshallingInfo.builder(MarshallingType.STRING)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("OverallSeverity").isBinary(false).build();

    private static final MarshallingInfo<StructuredPojo> EXECUTIONSUMMARY_BINDING = MarshallingInfo
            .builder(MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD)
            .marshallLocationName("ExecutionSummary").isBinary(false).build();

    private static final MarshallingInfo<StructuredPojo> COMPLIANTSUMMARY_BINDING = MarshallingInfo
            .builder(MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD)
            .marshallLocationName("CompliantSummary").isBinary(false).build();

    private static final MarshallingInfo<StructuredPojo> NONCOMPLIANTSUMMARY_BINDING = MarshallingInfo
            .builder(MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD)
            .marshallLocationName("NonCompliantSummary").isBinary(false).build();

    private static final ResourceComplianceSummaryItemMarshaller INSTANCE = new ResourceComplianceSummaryItemMarshaller();

    private ResourceComplianceSummaryItemMarshaller() {
    }

    public static ResourceComplianceSummaryItemMarshaller getInstance() {
        return INSTANCE;
    }

    /**
     * Marshall the given parameter object
     */
    public void marshall(ResourceComplianceSummaryItem resourceComplianceSummaryItem, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull(resourceComplianceSummaryItem, "resourceComplianceSummaryItem");
        Validate.paramNotNull(protocolMarshaller, "protocolMarshaller");
        try {
            protocolMarshaller.marshall(resourceComplianceSummaryItem.complianceType(), COMPLIANCETYPE_BINDING);
            protocolMarshaller.marshall(resourceComplianceSummaryItem.resourceType(), RESOURCETYPE_BINDING);
            protocolMarshaller.marshall(resourceComplianceSummaryItem.resourceId(), RESOURCEID_BINDING);
            protocolMarshaller.marshall(resourceComplianceSummaryItem.statusAsString(), STATUS_BINDING);
            protocolMarshaller.marshall(resourceComplianceSummaryItem.overallSeverityAsString(), OVERALLSEVERITY_BINDING);
            protocolMarshaller.marshall(resourceComplianceSummaryItem.executionSummary(), EXECUTIONSUMMARY_BINDING);
            protocolMarshaller.marshall(resourceComplianceSummaryItem.compliantSummary(), COMPLIANTSUMMARY_BINDING);
            protocolMarshaller.marshall(resourceComplianceSummaryItem.nonCompliantSummary(), NONCOMPLIANTSUMMARY_BINDING);
        } catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), e);
        }
    }
}
