/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ssm.transform;

import javax.annotation.Generated;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.ssm.model.SeveritySummary;
import software.amazon.awssdk.utils.Validate;

/**
 * {@link SeveritySummary} Marshaller
 */
@Generated("software.amazon.awssdk:codegen")
@SdkInternalApi
public class SeveritySummaryMarshaller {
    private static final MarshallingInfo<Integer> CRITICALCOUNT_BINDING = MarshallingInfo.builder(MarshallingType.INTEGER)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("CriticalCount").isBinary(false).build();

    private static final MarshallingInfo<Integer> HIGHCOUNT_BINDING = MarshallingInfo.builder(MarshallingType.INTEGER)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("HighCount").isBinary(false).build();

    private static final MarshallingInfo<Integer> MEDIUMCOUNT_BINDING = MarshallingInfo.builder(MarshallingType.INTEGER)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("MediumCount").isBinary(false).build();

    private static final MarshallingInfo<Integer> LOWCOUNT_BINDING = MarshallingInfo.builder(MarshallingType.INTEGER)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("LowCount").isBinary(false).build();

    private static final MarshallingInfo<Integer> INFORMATIONALCOUNT_BINDING = MarshallingInfo.builder(MarshallingType.INTEGER)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("InformationalCount").isBinary(false).build();

    private static final MarshallingInfo<Integer> UNSPECIFIEDCOUNT_BINDING = MarshallingInfo.builder(MarshallingType.INTEGER)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("UnspecifiedCount").isBinary(false).build();

    private static final SeveritySummaryMarshaller INSTANCE = new SeveritySummaryMarshaller();

    private SeveritySummaryMarshaller() {
    }

    public static SeveritySummaryMarshaller getInstance() {
        return INSTANCE;
    }

    /**
     * Marshall the given parameter object
     */
    public void marshall(SeveritySummary severitySummary, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull(severitySummary, "severitySummary");
        Validate.paramNotNull(protocolMarshaller, "protocolMarshaller");
        try {
            protocolMarshaller.marshall(severitySummary.criticalCount(), CRITICALCOUNT_BINDING);
            protocolMarshaller.marshall(severitySummary.highCount(), HIGHCOUNT_BINDING);
            protocolMarshaller.marshall(severitySummary.mediumCount(), MEDIUMCOUNT_BINDING);
            protocolMarshaller.marshall(severitySummary.lowCount(), LOWCOUNT_BINDING);
            protocolMarshaller.marshall(severitySummary.informationalCount(), INFORMATIONALCOUNT_BINDING);
            protocolMarshaller.marshall(severitySummary.unspecifiedCount(), UNSPECIFIEDCOUNT_BINDING);
        } catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), e);
        }
    }
}
