/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ssm.transform;

import java.time.Instant;
import java.util.Map;
import javax.annotation.Generated;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.ssm.model.StepExecution;
import software.amazon.awssdk.utils.Validate;

/**
 * {@link StepExecution} Marshaller
 */
@Generated("software.amazon.awssdk:codegen")
@SdkInternalApi
public class StepExecutionMarshaller {
    private static final MarshallingInfo<String> STEPNAME_BINDING = MarshallingInfo.builder(MarshallingType.STRING)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("StepName").isBinary(false).build();

    private static final MarshallingInfo<String> ACTION_BINDING = MarshallingInfo.builder(MarshallingType.STRING)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Action").isBinary(false).build();

    private static final MarshallingInfo<Instant> EXECUTIONSTARTTIME_BINDING = MarshallingInfo.builder(MarshallingType.INSTANT)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ExecutionStartTime").isBinary(false).build();

    private static final MarshallingInfo<Instant> EXECUTIONENDTIME_BINDING = MarshallingInfo.builder(MarshallingType.INSTANT)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ExecutionEndTime").isBinary(false).build();

    private static final MarshallingInfo<String> STEPSTATUS_BINDING = MarshallingInfo.builder(MarshallingType.STRING)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("StepStatus").isBinary(false).build();

    private static final MarshallingInfo<String> RESPONSECODE_BINDING = MarshallingInfo.builder(MarshallingType.STRING)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ResponseCode").isBinary(false).build();

    private static final MarshallingInfo<Map> INPUTS_BINDING = MarshallingInfo.builder(MarshallingType.MAP)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Inputs").isBinary(false).build();

    private static final MarshallingInfo<Map> OUTPUTS_BINDING = MarshallingInfo.builder(MarshallingType.MAP)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Outputs").isBinary(false).build();

    private static final MarshallingInfo<String> RESPONSE_BINDING = MarshallingInfo.builder(MarshallingType.STRING)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Response").isBinary(false).build();

    private static final MarshallingInfo<String> FAILUREMESSAGE_BINDING = MarshallingInfo.builder(MarshallingType.STRING)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("FailureMessage").isBinary(false).build();

    private static final MarshallingInfo<StructuredPojo> FAILUREDETAILS_BINDING = MarshallingInfo
            .builder(MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD)
            .marshallLocationName("FailureDetails").isBinary(false).build();

    private static final StepExecutionMarshaller INSTANCE = new StepExecutionMarshaller();

    private StepExecutionMarshaller() {
    }

    public static StepExecutionMarshaller getInstance() {
        return INSTANCE;
    }

    /**
     * Marshall the given parameter object
     */
    public void marshall(StepExecution stepExecution, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull(stepExecution, "stepExecution");
        Validate.paramNotNull(protocolMarshaller, "protocolMarshaller");
        try {
            protocolMarshaller.marshall(stepExecution.stepName(), STEPNAME_BINDING);
            protocolMarshaller.marshall(stepExecution.action(), ACTION_BINDING);
            protocolMarshaller.marshall(stepExecution.executionStartTime(), EXECUTIONSTARTTIME_BINDING);
            protocolMarshaller.marshall(stepExecution.executionEndTime(), EXECUTIONENDTIME_BINDING);
            protocolMarshaller.marshall(stepExecution.stepStatusAsString(), STEPSTATUS_BINDING);
            protocolMarshaller.marshall(stepExecution.responseCode(), RESPONSECODE_BINDING);
            protocolMarshaller.marshall(stepExecution.inputs(), INPUTS_BINDING);
            protocolMarshaller.marshall(stepExecution.outputs(), OUTPUTS_BINDING);
            protocolMarshaller.marshall(stepExecution.response(), RESPONSE_BINDING);
            protocolMarshaller.marshall(stepExecution.failureMessage(), FAILUREMESSAGE_BINDING);
            protocolMarshaller.marshall(stepExecution.failureDetails(), FAILUREDETAILS_BINDING);
        } catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), e);
        }
    }
}
