/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ssm.model;

import java.time.Instant;
import java.util.Objects;
import java.util.Optional;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.ssm.model.AssociationStatusName;
import software.amazon.awssdk.services.ssm.transform.AssociationStatusMarshaller;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class AssociationStatus
implements StructuredPojo,
ToCopyableBuilder<Builder, AssociationStatus> {
    private final Instant date;
    private final String name;
    private final String message;
    private final String additionalInfo;

    private AssociationStatus(BuilderImpl builder) {
        this.date = builder.date;
        this.name = builder.name;
        this.message = builder.message;
        this.additionalInfo = builder.additionalInfo;
    }

    public Instant date() {
        return this.date;
    }

    public AssociationStatusName name() {
        return AssociationStatusName.fromValue(this.name);
    }

    public String nameAsString() {
        return this.name;
    }

    public String message() {
        return this.message;
    }

    public String additionalInfo() {
        return this.additionalInfo;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.date());
        hashCode = 31 * hashCode + Objects.hashCode(this.nameAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.message());
        hashCode = 31 * hashCode + Objects.hashCode(this.additionalInfo());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AssociationStatus)) {
            return false;
        }
        AssociationStatus other = (AssociationStatus)obj;
        return Objects.equals(this.date(), other.date()) && Objects.equals(this.nameAsString(), other.nameAsString()) && Objects.equals(this.message(), other.message()) && Objects.equals(this.additionalInfo(), other.additionalInfo());
    }

    public String toString() {
        return ToString.builder((String)"AssociationStatus").add("Date", (Object)this.date()).add("Name", (Object)this.nameAsString()).add("Message", (Object)this.message()).add("AdditionalInfo", (Object)this.additionalInfo()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Date": {
                return Optional.of(clazz.cast(this.date()));
            }
            case "Name": {
                return Optional.of(clazz.cast(this.nameAsString()));
            }
            case "Message": {
                return Optional.of(clazz.cast(this.message()));
            }
            case "AdditionalInfo": {
                return Optional.of(clazz.cast(this.additionalInfo()));
            }
        }
        return Optional.empty();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        AssociationStatusMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    static final class BuilderImpl
    implements Builder {
        private Instant date;
        private String name;
        private String message;
        private String additionalInfo;

        private BuilderImpl() {
        }

        private BuilderImpl(AssociationStatus model) {
            this.date(model.date);
            this.name(model.name);
            this.message(model.message);
            this.additionalInfo(model.additionalInfo);
        }

        public final Instant getDate() {
            return this.date;
        }

        @Override
        public final Builder date(Instant date) {
            this.date = date;
            return this;
        }

        public final void setDate(Instant date) {
            this.date = date;
        }

        public final String getName() {
            return this.name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        @Override
        public final Builder name(AssociationStatusName name) {
            this.name(name.toString());
            return this;
        }

        public final void setName(String name) {
            this.name = name;
        }

        public final String getMessage() {
            return this.message;
        }

        @Override
        public final Builder message(String message) {
            this.message = message;
            return this;
        }

        public final void setMessage(String message) {
            this.message = message;
        }

        public final String getAdditionalInfo() {
            return this.additionalInfo;
        }

        @Override
        public final Builder additionalInfo(String additionalInfo) {
            this.additionalInfo = additionalInfo;
            return this;
        }

        public final void setAdditionalInfo(String additionalInfo) {
            this.additionalInfo = additionalInfo;
        }

        public AssociationStatus build() {
            return new AssociationStatus(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, AssociationStatus> {
        public Builder date(Instant var1);

        public Builder name(String var1);

        public Builder name(AssociationStatusName var1);

        public Builder message(String var1);

        public Builder additionalInfo(String var1);
    }
}

