/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ssm.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfig;
import software.amazon.awssdk.services.ssm.model.InstanceInformationFilter;
import software.amazon.awssdk.services.ssm.model.InstanceInformationFilterListCopier;
import software.amazon.awssdk.services.ssm.model.InstanceInformationStringFilter;
import software.amazon.awssdk.services.ssm.model.InstanceInformationStringFilterListCopier;
import software.amazon.awssdk.services.ssm.model.SSMRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class DescribeInstanceInformationRequest
extends SSMRequest
implements ToCopyableBuilder<Builder, DescribeInstanceInformationRequest> {
    private final List<InstanceInformationFilter> instanceInformationFilterList;
    private final List<InstanceInformationStringFilter> filters;
    private final Integer maxResults;
    private final String nextToken;

    private DescribeInstanceInformationRequest(BuilderImpl builder) {
        super(builder);
        this.instanceInformationFilterList = builder.instanceInformationFilterList;
        this.filters = builder.filters;
        this.maxResults = builder.maxResults;
        this.nextToken = builder.nextToken;
    }

    public List<InstanceInformationFilter> instanceInformationFilterList() {
        return this.instanceInformationFilterList;
    }

    public List<InstanceInformationStringFilter> filters() {
        return this.filters;
    }

    public Integer maxResults() {
        return this.maxResults;
    }

    public String nextToken() {
        return this.nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.instanceInformationFilterList());
        hashCode = 31 * hashCode + Objects.hashCode(this.filters());
        hashCode = 31 * hashCode + Objects.hashCode(this.maxResults());
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeInstanceInformationRequest)) {
            return false;
        }
        DescribeInstanceInformationRequest other = (DescribeInstanceInformationRequest)((Object)obj);
        return Objects.equals(this.instanceInformationFilterList(), other.instanceInformationFilterList()) && Objects.equals(this.filters(), other.filters()) && Objects.equals(this.maxResults(), other.maxResults()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public String toString() {
        return ToString.builder((String)"DescribeInstanceInformationRequest").add("InstanceInformationFilterList", this.instanceInformationFilterList()).add("Filters", this.filters()).add("MaxResults", (Object)this.maxResults()).add("NextToken", (Object)this.nextToken()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "InstanceInformationFilterList": {
                return Optional.of(clazz.cast(this.instanceInformationFilterList()));
            }
            case "Filters": {
                return Optional.of(clazz.cast(this.filters()));
            }
            case "MaxResults": {
                return Optional.of(clazz.cast(this.maxResults()));
            }
            case "NextToken": {
                return Optional.of(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends SSMRequest.BuilderImpl
    implements Builder {
        private List<InstanceInformationFilter> instanceInformationFilterList;
        private List<InstanceInformationStringFilter> filters;
        private Integer maxResults;
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeInstanceInformationRequest model) {
            super(model);
            this.instanceInformationFilterList(model.instanceInformationFilterList);
            this.filters(model.filters);
            this.maxResults(model.maxResults);
            this.nextToken(model.nextToken);
        }

        public final Collection<InstanceInformationFilter.Builder> getInstanceInformationFilterList() {
            return this.instanceInformationFilterList != null ? (Collection)this.instanceInformationFilterList.stream().map(InstanceInformationFilter::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder instanceInformationFilterList(Collection<InstanceInformationFilter> instanceInformationFilterList) {
            this.instanceInformationFilterList = InstanceInformationFilterListCopier.copy(instanceInformationFilterList);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder instanceInformationFilterList(InstanceInformationFilter ... instanceInformationFilterList) {
            this.instanceInformationFilterList(Arrays.asList(instanceInformationFilterList));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder instanceInformationFilterList(Consumer<InstanceInformationFilter.Builder> ... instanceInformationFilterList) {
            this.instanceInformationFilterList(Stream.of(instanceInformationFilterList).map(c -> (InstanceInformationFilter)((InstanceInformationFilter.Builder)InstanceInformationFilter.builder().apply((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setInstanceInformationFilterList(Collection<InstanceInformationFilter.BuilderImpl> instanceInformationFilterList) {
            this.instanceInformationFilterList = InstanceInformationFilterListCopier.copyFromBuilder(instanceInformationFilterList);
        }

        public final Collection<InstanceInformationStringFilter.Builder> getFilters() {
            return this.filters != null ? (Collection)this.filters.stream().map(InstanceInformationStringFilter::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder filters(Collection<InstanceInformationStringFilter> filters) {
            this.filters = InstanceInformationStringFilterListCopier.copy(filters);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder filters(InstanceInformationStringFilter ... filters) {
            this.filters(Arrays.asList(filters));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder filters(Consumer<InstanceInformationStringFilter.Builder> ... filters) {
            this.filters(Stream.of(filters).map(c -> (InstanceInformationStringFilter)((InstanceInformationStringFilter.Builder)InstanceInformationStringFilter.builder().apply((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setFilters(Collection<InstanceInformationStringFilter.BuilderImpl> filters) {
            this.filters = InstanceInformationStringFilterListCopier.copyFromBuilder(filters);
        }

        public final Integer getMaxResults() {
            return this.maxResults;
        }

        @Override
        public final Builder maxResults(Integer maxResults) {
            this.maxResults = maxResults;
            return this;
        }

        public final void setMaxResults(Integer maxResults) {
            this.maxResults = maxResults;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public Builder requestOverrideConfig(AwsRequestOverrideConfig awsRequestOverrideConfig) {
            super.requestOverrideConfig(awsRequestOverrideConfig);
            return this;
        }

        @Override
        public Builder requestOverrideConfig(Consumer<AwsRequestOverrideConfig.Builder> builderConsumer) {
            super.requestOverrideConfig(builderConsumer);
            return this;
        }

        @Override
        public DescribeInstanceInformationRequest build() {
            return new DescribeInstanceInformationRequest(this);
        }
    }

    public static interface Builder
    extends SSMRequest.Builder,
    CopyableBuilder<Builder, DescribeInstanceInformationRequest> {
        public Builder instanceInformationFilterList(Collection<InstanceInformationFilter> var1);

        public Builder instanceInformationFilterList(InstanceInformationFilter ... var1);

        public Builder instanceInformationFilterList(Consumer<InstanceInformationFilter.Builder> ... var1);

        public Builder filters(Collection<InstanceInformationStringFilter> var1);

        public Builder filters(InstanceInformationStringFilter ... var1);

        public Builder filters(Consumer<InstanceInformationStringFilter.Builder> ... var1);

        public Builder maxResults(Integer var1);

        public Builder nextToken(String var1);

        public Builder requestOverrideConfig(AwsRequestOverrideConfig var1);

        public Builder requestOverrideConfig(Consumer<AwsRequestOverrideConfig.Builder> var1);
    }
}

