/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ssm.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.services.ssm.model.InventoryItemSchema;
import software.amazon.awssdk.services.ssm.model.InventoryItemSchemaResultListCopier;
import software.amazon.awssdk.services.ssm.model.SSMResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class GetInventorySchemaResponse
extends SSMResponse
implements ToCopyableBuilder<Builder, GetInventorySchemaResponse> {
    private final List<InventoryItemSchema> schemas;
    private final String nextToken;

    private GetInventorySchemaResponse(BuilderImpl builder) {
        super(builder);
        this.schemas = builder.schemas;
        this.nextToken = builder.nextToken;
    }

    public List<InventoryItemSchema> schemas() {
        return this.schemas;
    }

    public String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.schemas());
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetInventorySchemaResponse)) {
            return false;
        }
        GetInventorySchemaResponse other = (GetInventorySchemaResponse)((Object)obj);
        return Objects.equals(this.schemas(), other.schemas()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public String toString() {
        return ToString.builder((String)"GetInventorySchemaResponse").add("Schemas", this.schemas()).add("NextToken", (Object)this.nextToken()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Schemas": {
                return Optional.of(clazz.cast(this.schemas()));
            }
            case "NextToken": {
                return Optional.of(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends SSMResponse.BuilderImpl
    implements Builder {
        private List<InventoryItemSchema> schemas;
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(GetInventorySchemaResponse model) {
            super(model);
            this.schemas(model.schemas);
            this.nextToken(model.nextToken);
        }

        public final Collection<InventoryItemSchema.Builder> getSchemas() {
            return this.schemas != null ? (Collection)this.schemas.stream().map(InventoryItemSchema::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder schemas(Collection<InventoryItemSchema> schemas) {
            this.schemas = InventoryItemSchemaResultListCopier.copy(schemas);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder schemas(InventoryItemSchema ... schemas) {
            this.schemas(Arrays.asList(schemas));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder schemas(Consumer<InventoryItemSchema.Builder> ... schemas) {
            this.schemas(Stream.of(schemas).map(c -> (InventoryItemSchema)((InventoryItemSchema.Builder)InventoryItemSchema.builder().apply((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setSchemas(Collection<InventoryItemSchema.BuilderImpl> schemas) {
            this.schemas = InventoryItemSchemaResultListCopier.copyFromBuilder(schemas);
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public GetInventorySchemaResponse build() {
            return new GetInventorySchemaResponse(this);
        }
    }

    public static interface Builder
    extends SSMResponse.Builder,
    CopyableBuilder<Builder, GetInventorySchemaResponse> {
        public Builder schemas(Collection<InventoryItemSchema> var1);

        public Builder schemas(InventoryItemSchema ... var1);

        public Builder schemas(Consumer<InventoryItemSchema.Builder> ... var1);

        public Builder nextToken(String var1);
    }
}

