/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ssm.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfig;
import software.amazon.awssdk.services.ssm.model.DocumentFilter;
import software.amazon.awssdk.services.ssm.model.DocumentFilterListCopier;
import software.amazon.awssdk.services.ssm.model.DocumentKeyValuesFilter;
import software.amazon.awssdk.services.ssm.model.DocumentKeyValuesFilterListCopier;
import software.amazon.awssdk.services.ssm.model.SSMRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class ListDocumentsRequest
extends SSMRequest
implements ToCopyableBuilder<Builder, ListDocumentsRequest> {
    private final List<DocumentFilter> documentFilterList;
    private final List<DocumentKeyValuesFilter> filters;
    private final Integer maxResults;
    private final String nextToken;

    private ListDocumentsRequest(BuilderImpl builder) {
        super(builder);
        this.documentFilterList = builder.documentFilterList;
        this.filters = builder.filters;
        this.maxResults = builder.maxResults;
        this.nextToken = builder.nextToken;
    }

    public List<DocumentFilter> documentFilterList() {
        return this.documentFilterList;
    }

    public List<DocumentKeyValuesFilter> filters() {
        return this.filters;
    }

    public Integer maxResults() {
        return this.maxResults;
    }

    public String nextToken() {
        return this.nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.documentFilterList());
        hashCode = 31 * hashCode + Objects.hashCode(this.filters());
        hashCode = 31 * hashCode + Objects.hashCode(this.maxResults());
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListDocumentsRequest)) {
            return false;
        }
        ListDocumentsRequest other = (ListDocumentsRequest)((Object)obj);
        return Objects.equals(this.documentFilterList(), other.documentFilterList()) && Objects.equals(this.filters(), other.filters()) && Objects.equals(this.maxResults(), other.maxResults()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public String toString() {
        return ToString.builder((String)"ListDocumentsRequest").add("DocumentFilterList", this.documentFilterList()).add("Filters", this.filters()).add("MaxResults", (Object)this.maxResults()).add("NextToken", (Object)this.nextToken()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "DocumentFilterList": {
                return Optional.of(clazz.cast(this.documentFilterList()));
            }
            case "Filters": {
                return Optional.of(clazz.cast(this.filters()));
            }
            case "MaxResults": {
                return Optional.of(clazz.cast(this.maxResults()));
            }
            case "NextToken": {
                return Optional.of(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends SSMRequest.BuilderImpl
    implements Builder {
        private List<DocumentFilter> documentFilterList;
        private List<DocumentKeyValuesFilter> filters;
        private Integer maxResults;
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListDocumentsRequest model) {
            super(model);
            this.documentFilterList(model.documentFilterList);
            this.filters(model.filters);
            this.maxResults(model.maxResults);
            this.nextToken(model.nextToken);
        }

        public final Collection<DocumentFilter.Builder> getDocumentFilterList() {
            return this.documentFilterList != null ? (Collection)this.documentFilterList.stream().map(DocumentFilter::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder documentFilterList(Collection<DocumentFilter> documentFilterList) {
            this.documentFilterList = DocumentFilterListCopier.copy(documentFilterList);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder documentFilterList(DocumentFilter ... documentFilterList) {
            this.documentFilterList(Arrays.asList(documentFilterList));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder documentFilterList(Consumer<DocumentFilter.Builder> ... documentFilterList) {
            this.documentFilterList(Stream.of(documentFilterList).map(c -> (DocumentFilter)((DocumentFilter.Builder)DocumentFilter.builder().apply((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setDocumentFilterList(Collection<DocumentFilter.BuilderImpl> documentFilterList) {
            this.documentFilterList = DocumentFilterListCopier.copyFromBuilder(documentFilterList);
        }

        public final Collection<DocumentKeyValuesFilter.Builder> getFilters() {
            return this.filters != null ? (Collection)this.filters.stream().map(DocumentKeyValuesFilter::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder filters(Collection<DocumentKeyValuesFilter> filters) {
            this.filters = DocumentKeyValuesFilterListCopier.copy(filters);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder filters(DocumentKeyValuesFilter ... filters) {
            this.filters(Arrays.asList(filters));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder filters(Consumer<DocumentKeyValuesFilter.Builder> ... filters) {
            this.filters(Stream.of(filters).map(c -> (DocumentKeyValuesFilter)((DocumentKeyValuesFilter.Builder)DocumentKeyValuesFilter.builder().apply((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setFilters(Collection<DocumentKeyValuesFilter.BuilderImpl> filters) {
            this.filters = DocumentKeyValuesFilterListCopier.copyFromBuilder(filters);
        }

        public final Integer getMaxResults() {
            return this.maxResults;
        }

        @Override
        public final Builder maxResults(Integer maxResults) {
            this.maxResults = maxResults;
            return this;
        }

        public final void setMaxResults(Integer maxResults) {
            this.maxResults = maxResults;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public Builder requestOverrideConfig(AwsRequestOverrideConfig awsRequestOverrideConfig) {
            super.requestOverrideConfig(awsRequestOverrideConfig);
            return this;
        }

        @Override
        public Builder requestOverrideConfig(Consumer<AwsRequestOverrideConfig.Builder> builderConsumer) {
            super.requestOverrideConfig(builderConsumer);
            return this;
        }

        @Override
        public ListDocumentsRequest build() {
            return new ListDocumentsRequest(this);
        }
    }

    public static interface Builder
    extends SSMRequest.Builder,
    CopyableBuilder<Builder, ListDocumentsRequest> {
        public Builder documentFilterList(Collection<DocumentFilter> var1);

        public Builder documentFilterList(DocumentFilter ... var1);

        public Builder documentFilterList(Consumer<DocumentFilter.Builder> ... var1);

        public Builder filters(Collection<DocumentKeyValuesFilter> var1);

        public Builder filters(DocumentKeyValuesFilter ... var1);

        public Builder filters(Consumer<DocumentKeyValuesFilter.Builder> ... var1);

        public Builder maxResults(Integer var1);

        public Builder nextToken(String var1);

        public Builder requestOverrideConfig(AwsRequestOverrideConfig var1);

        public Builder requestOverrideConfig(Consumer<AwsRequestOverrideConfig.Builder> var1);
    }
}

