/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ssm.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.SdkIterable;
import software.amazon.awssdk.core.pagination.SyncPageFetcher;
import software.amazon.awssdk.services.ssm.SSMClient;
import software.amazon.awssdk.services.ssm.model.Activation;
import software.amazon.awssdk.services.ssm.model.DescribeActivationsRequest;
import software.amazon.awssdk.services.ssm.model.DescribeActivationsResponse;

public class DescribeActivationsIterable
implements SdkIterable<DescribeActivationsResponse> {
    private final SSMClient client;
    private final DescribeActivationsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public DescribeActivationsIterable(SSMClient client, DescribeActivationsRequest firstRequest) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.nextPageFetcher = new DescribeActivationsResponseFetcher();
    }

    public Iterator<DescribeActivationsResponse> iterator() {
        return new PaginatedResponsesIterator(this.nextPageFetcher);
    }

    public final SdkIterable<Activation> activationList() {
        Function<DescribeActivationsResponse, Iterator> getIterator = response -> {
            if (response != null && response.activationList() != null) {
                return response.activationList().iterator();
            }
            return Collections.emptyIterator();
        };
        return new PaginatedItemsIterable((SdkIterable)this, getIterator);
    }

    public final DescribeActivationsIterable resume(DescribeActivationsResponse lastSuccessfulPage) {
        if (this.nextPageFetcher.hasNextPage((Object)lastSuccessfulPage)) {
            return new DescribeActivationsIterable(this.client, (DescribeActivationsRequest)((Object)this.firstRequest.toBuilder().nextToken(lastSuccessfulPage.nextToken()).build()));
        }
        return new DescribeActivationsIterable(this.client, this.firstRequest){

            @Override
            public Iterator<DescribeActivationsResponse> iterator() {
                return Collections.emptyIterator();
            }
        };
    }

    private class DescribeActivationsResponseFetcher
    implements SyncPageFetcher<DescribeActivationsResponse> {
        private DescribeActivationsResponseFetcher() {
        }

        public boolean hasNextPage(DescribeActivationsResponse previousPage) {
            return previousPage.nextToken() != null;
        }

        public DescribeActivationsResponse nextPage(DescribeActivationsResponse previousPage) {
            if (previousPage == null) {
                return DescribeActivationsIterable.this.client.describeActivations(DescribeActivationsIterable.this.firstRequest);
            }
            return DescribeActivationsIterable.this.client.describeActivations((DescribeActivationsRequest)((Object)DescribeActivationsIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

